/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.client.ReadType;
import alluxio.conf.PropertyKey;
import alluxio.job.plan.transform.format.JobPath;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobPathTest {
    @Test
    public void testCache() throws Exception {
        try (MockedStatic jobPathMocked = Mockito.mockStatic(JobPath.class);
             MockedStatic userGroupInfoMocked = Mockito.mockStatic(UserGroupInformation.class);){
            jobPathMocked.when(() -> JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()))).thenAnswer(p -> (FileSystem)Mockito.mock(FileSystem.class));
            userGroupInfoMocked.when(UserGroupInformation::getCurrentUser).thenReturn(null);
            Configuration conf = new Configuration();
            JobPath jobPath = new JobPath("foo", "bar", "/baz");
            FileSystem fileSystem = jobPath.getFileSystem(conf);
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)1));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            Assert.assertEquals((Object)fileSystem, (Object)jobPath.getFileSystem(conf));
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)1));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            conf.set(PropertyKey.USER_FILE_READ_TYPE_DEFAULT.toString(), ReadType.NO_CACHE.toString());
            FileSystem newFileSystem = jobPath.getFileSystem(conf);
            Assert.assertNotEquals((Object)fileSystem, (Object)newFileSystem);
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)2));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            conf.set("foo", "bar");
            Assert.assertEquals((Object)newFileSystem, (Object)jobPath.getFileSystem(conf));
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)2));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            jobPath = new JobPath("foo", "bar", "/bar");
            Assert.assertEquals((Object)newFileSystem, (Object)jobPath.getFileSystem(conf));
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)2));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            jobPath = new JobPath("foo", "baz", "/bar");
            Assert.assertNotEquals((Object)newFileSystem, (Object)jobPath.getFileSystem(conf));
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)3));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
            jobPath = new JobPath("bar", "bar", "/bar");
            Assert.assertNotEquals((Object)newFileSystem, (Object)jobPath.getFileSystem(conf));
            Mockito.verify(JobPath.class, (VerificationMode)Mockito.times((int)4));
            JobPath.fileSystemGet((URI)((URI)Mockito.any()), (Configuration)((Configuration)Mockito.any()));
        }
    }
}

