/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.command;

import alluxio.grpc.JobCommand;
import alluxio.job.JobConfig;
import alluxio.job.TestPlanConfig;
import alluxio.job.util.SerializationUtils;
import alluxio.master.job.command.CommandManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class CommandManagerTest {
    private CommandManager mManager;

    @Before
    public void before() {
        this.mManager = new CommandManager();
    }

    @Test
    public void submitRunTaskCommand() throws Exception {
        long jobId = 0L;
        int taskId = 1;
        TestPlanConfig jobConfig = new TestPlanConfig("/test");
        long workerId = 2L;
        ArrayList args = Lists.newArrayList((Object[])new Integer[]{1});
        this.mManager.submitRunTaskCommand(jobId, (long)taskId, (JobConfig)jobConfig, (Object)args, workerId);
        List commands = this.mManager.pollAllPendingCommands(workerId);
        Assert.assertEquals((long)1L, (long)commands.size());
        JobCommand command = (JobCommand)commands.get(0);
        Assert.assertEquals((long)jobId, (long)command.getRunTaskCommand().getJobId());
        Assert.assertEquals((long)taskId, (long)command.getRunTaskCommand().getTaskId());
        Assert.assertEquals((Object)jobConfig, (Object)SerializationUtils.deserialize((byte[])command.getRunTaskCommand().getJobConfig().toByteArray()));
        Assert.assertEquals((Object)args, (Object)SerializationUtils.deserialize((byte[])command.getRunTaskCommand().getTaskArgs().toByteArray()));
    }

    @Test
    public void submitCancelTaskCommand() {
        long jobId = 0L;
        int taskId = 1;
        long workerId = 2L;
        this.mManager.submitCancelTaskCommand(jobId, (long)taskId, workerId);
        List commands = this.mManager.pollAllPendingCommands(workerId);
        Assert.assertEquals((long)1L, (long)commands.size());
        JobCommand command = (JobCommand)commands.get(0);
        Assert.assertEquals((long)jobId, (long)command.getCancelTaskCommand().getJobId());
        Assert.assertEquals((long)taskId, (long)command.getCancelTaskCommand().getTaskId());
    }
}

