/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.plan;

import alluxio.AlluxioMockUtil;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.collections.Pair;
import alluxio.grpc.JobCommand;
import alluxio.job.JobConfig;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.PlanDefinition;
import alluxio.job.plan.PlanDefinitionRegistry;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.master.job.command.CommandManager;
import alluxio.master.job.plan.PlanCoordinator;
import alluxio.underfs.UfsManager;
import alluxio.wire.WorkerInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public final class PlanCoordinatorTest {
    private WorkerInfo mWorkerInfo;
    private long mJobId;
    private JobConfig mJobconfig;
    private JobServerContext mJobServerContext;
    private CommandManager mCommandManager;
    private PlanDefinition<JobConfig, Serializable, Serializable> mPlanDefinition;
    private List<WorkerInfo> mWorkerInfoList;

    @Before
    public void before() throws Exception {
        this.mCommandManager = new CommandManager();
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemContext fsCtx = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        UfsManager ufsManager = (UfsManager)Mockito.mock(UfsManager.class);
        this.mJobServerContext = new JobServerContext(fs, fsCtx, ufsManager);
        this.mJobconfig = (JobConfig)Mockito.mock(JobConfig.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)this.mJobconfig.getName()).thenReturn((Object)"mock");
        this.mJobId = 1L;
        PlanDefinition mockPlanDefinition = (PlanDefinition)Mockito.mock(PlanDefinition.class);
        PlanDefinitionRegistry singleton = (PlanDefinitionRegistry)Mockito.mock(PlanDefinitionRegistry.class);
        AlluxioMockUtil.setInternalState(PlanDefinitionRegistry.class, (String)"INSTANCE", (Object)singleton);
        Mockito.when((Object)singleton.getJobDefinition(this.mJobconfig)).thenReturn((Object)mockPlanDefinition);
        this.mPlanDefinition = mockPlanDefinition;
        this.mWorkerInfo = new WorkerInfo();
        this.mWorkerInfo.setId(0L);
        this.mWorkerInfoList = Lists.newArrayList((Object[])new WorkerInfo[]{this.mWorkerInfo});
    }

    @Test
    public void createJobCoordinator() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        List commands = this.mCommandManager.pollAllPendingCommands(this.mWorkerInfo.getId());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((long)this.mJobId, (long)((JobCommand)commands.get(0)).getRunTaskCommand().getJobId());
        Assert.assertEquals((long)0L, (long)((JobCommand)commands.get(0)).getRunTaskCommand().getTaskId());
    }

    @Test
    public void updateStatusFailure() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.RUNNING, Status.FAILED, Status.COMPLETED);
        Assert.assertEquals((Object)Status.FAILED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
        Assert.assertTrue((boolean)planCoordinator.getPlanInfoWire(true).getErrorMessage().contains("Task execution failed"));
    }

    @Test
    public void updateStatusFailureOverCancel() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.RUNNING, Status.FAILED, Status.COMPLETED);
        Assert.assertEquals((Object)Status.FAILED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    @Test
    public void updateStatusCancel() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.CANCELED, Status.RUNNING, Status.COMPLETED);
        Assert.assertEquals((Object)Status.CANCELED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    @Test
    public void updateStatusRunning() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.COMPLETED, Status.RUNNING, Status.COMPLETED);
        Assert.assertEquals((Object)Status.RUNNING, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    @Test
    public void updateStatusCompleted() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.COMPLETED, Status.COMPLETED, Status.COMPLETED);
        Assert.assertEquals((Object)Status.COMPLETED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    @Test
    public void updateStatusJoinFailure() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        Mockito.when((Object)this.mPlanDefinition.join((JobConfig)Mockito.eq((Object)this.mJobconfig), Mockito.anyMapOf(WorkerInfo.class, Serializable.class))).thenThrow(new Throwable[]{new UnsupportedOperationException("test exception")});
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        this.setTasksWithStatuses(planCoordinator, Status.COMPLETED, Status.COMPLETED, Status.COMPLETED);
        Assert.assertEquals((Object)Status.FAILED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
        Assert.assertEquals((Object)"test exception", (Object)planCoordinator.getPlanInfoWire(true).getErrorMessage());
    }

    @Test
    public void noTasks() throws Exception {
        this.mockSelectExecutors(new WorkerInfo[0]);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        Assert.assertEquals((Object)Status.COMPLETED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    @Test
    public void failWorker() throws Exception {
        this.mockSelectExecutors(this.mWorkerInfo);
        PlanCoordinator planCoordinator = PlanCoordinator.create((CommandManager)this.mCommandManager, (JobServerContext)this.mJobServerContext, this.mWorkerInfoList, (Long)this.mJobId, (JobConfig)this.mJobconfig, null);
        planCoordinator.failTasksForWorker(this.mWorkerInfo.getId());
        Assert.assertEquals((Object)Status.FAILED, (Object)planCoordinator.getPlanInfoWire(true).getStatus());
    }

    private void mockSelectExecutors(WorkerInfo ... workerInfos) throws Exception {
        HashSet taskAddressToArgs = Sets.newHashSet();
        for (WorkerInfo workerInfo : workerInfos) {
            taskAddressToArgs.add(new Pair((Object)workerInfo, null));
        }
        Mockito.when((Object)this.mPlanDefinition.selectExecutors((JobConfig)Mockito.eq((Object)this.mJobconfig), (List)Mockito.eq((Object)Lists.newArrayList((Object[])new WorkerInfo[]{this.mWorkerInfo})), (SelectExecutorsContext)Mockito.any(SelectExecutorsContext.class))).thenReturn((Object)taskAddressToArgs);
    }

    private void setTasksWithStatuses(PlanCoordinator planCoordinator, Status ... statuses) throws Exception {
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        int taskId = 0;
        for (Status status : statuses) {
            taskInfos.add(new TaskInfo().setTaskId((long)taskId++).setJobId(this.mJobId).setStatus(status));
        }
        planCoordinator.updateTasks(taskInfos);
    }
}

