/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.JobDoesNotExistException;
import alluxio.grpc.OperationType;
import alluxio.job.CmdConfig;
import alluxio.job.cmd.load.LoadCliConfig;
import alluxio.job.cmd.migrate.MigrateCliConfig;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.JobSource;
import alluxio.job.wire.SimpleJobStatusBlock;
import alluxio.job.wire.Status;
import alluxio.master.job.common.CmdInfo;
import alluxio.master.job.tracker.CmdJobTracker;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.master.job.tracker.DistLoadCliRunner;
import alluxio.master.job.tracker.MigrateCliRunner;
import alluxio.master.job.tracker.PersistRunner;
import com.beust.jcommander.internal.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public final class CmdJobTrackerTest {
    private static final int REPEATED_ATTEMPT_COUNT = 5;
    private static final int ONE_ATTEMPT = 1;
    private CmdJobTracker mCmdJobTracker;
    private FileSystem mFs;
    private long mLoadJobId;
    private long mMigrateJobId;
    private MigrateCliRunner mMigrateCliRunner;
    private DistLoadCliRunner mDistLoadRunner;
    private PersistRunner mPersistRunner;
    private LoadCliConfig mLoad;
    private MigrateCliConfig mMigrate;
    private List<Status> mSearchingCriteria = Lists.newArrayList();
    @Rule
    public ExpectedException mException = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemContext fsCtx = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        this.mMigrateCliRunner = (MigrateCliRunner)Mockito.mock(MigrateCliRunner.class);
        this.mDistLoadRunner = (DistLoadCliRunner)Mockito.mock(DistLoadCliRunner.class);
        this.mPersistRunner = (PersistRunner)Mockito.mock(PersistRunner.class);
        this.mCmdJobTracker = new CmdJobTracker(fsCtx, this.mDistLoadRunner, this.mMigrateCliRunner, this.mPersistRunner);
        this.mLoad = new LoadCliConfig("/path/to/load", Integer.valueOf(3), Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, true);
        this.mMigrate = new MigrateCliConfig("/path/from", "/path/to", WriteType.THROUGH, true, 2);
        this.mLoadJobId = 1L;
        this.mMigrateJobId = 2L;
        this.mSearchingCriteria.clear();
    }

    @Test
    public void runDistLoadBatchCompleteTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mLoadJobId, OperationType.DIST_LOAD, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareDistLoadTest(cmdInfo, this.mLoad, this.mLoadJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mLoad, this.mLoadJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mLoadJobId);
        Assert.assertEquals((Object)s, (Object)Status.COMPLETED);
    }

    @Test
    public void runDistLoadBatchFailTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mLoadJobId, OperationType.DIST_LOAD, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareDistLoadTest(cmdInfo, this.mLoad, this.mLoadJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mLoad, this.mLoadJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mLoadJobId);
        Assert.assertEquals((Object)s, (Object)Status.FAILED);
    }

    @Test
    public void runDistLoadBatchCancelTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mLoadJobId, OperationType.DIST_LOAD, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareDistLoadTest(cmdInfo, this.mLoad, this.mLoadJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mLoad, this.mLoadJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mLoadJobId);
        Assert.assertEquals((Object)s, (Object)Status.CANCELED);
    }

    @Test
    public void runDistLoadBatchRunningTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mLoadJobId, OperationType.DIST_LOAD, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.RUNNING, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.CREATED, cmdInfo, 5);
        this.prepareDistLoadTest(cmdInfo, this.mLoad, this.mLoadJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mLoad, this.mLoadJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mLoadJobId);
        Assert.assertEquals((Object)s, (Object)Status.RUNNING);
    }

    @Test
    public void runDistCpBatchCompleteTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mMigrateJobId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareDistCpTest(cmdInfo, this.mMigrate, this.mMigrateJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mMigrate, this.mMigrateJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mMigrateJobId);
        Assert.assertEquals((Object)s, (Object)Status.COMPLETED);
    }

    @Test
    public void runDistCpBatchFailTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mMigrateJobId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareDistCpTest(cmdInfo, this.mMigrate, this.mMigrateJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mMigrate, this.mMigrateJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mMigrateJobId);
        Assert.assertEquals((Object)s, (Object)Status.FAILED);
    }

    @Test
    public void runDistCpBatchCancelTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mMigrateJobId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareDistCpTest(cmdInfo, this.mMigrate, this.mMigrateJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mMigrate, this.mMigrateJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mMigrateJobId);
        Assert.assertEquals((Object)s, (Object)Status.CANCELED);
    }

    @Test
    public void runDistCpBatchRunningTest() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mMigrateJobId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
        this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.RUNNING, cmdInfo, 1);
        this.prepareAttemptWithStatus(Status.CREATED, cmdInfo, 5);
        this.prepareDistCpTest(cmdInfo, this.mMigrate, this.mMigrateJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mMigrate, this.mMigrateJobId);
        Status s = this.mCmdJobTracker.getCmdStatus(this.mMigrateJobId);
        Assert.assertEquals((Object)s, (Object)Status.RUNNING);
    }

    @Test
    public void testFindCmdIdsForComplete() throws Exception {
        long completedId = this.generateMigrateCommandForStatus(Status.COMPLETED);
        this.mSearchingCriteria.add(Status.COMPLETED);
        Set completedCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)completedCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)completedCmdIds.contains(completedId));
    }

    @Test
    public void testFindCmdIdsForFailed() throws Exception {
        long failedId = this.generateMigrateCommandForStatus(Status.FAILED);
        this.mSearchingCriteria.add(Status.FAILED);
        Set failedCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)failedCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)failedCmdIds.contains(failedId));
    }

    @Test
    public void testFindCmdIdsForRunning() throws Exception {
        long runningId = this.generateMigrateCommandForStatus(Status.RUNNING);
        this.mSearchingCriteria.add(Status.RUNNING);
        Set runningCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)runningCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)runningCmdIds.contains(runningId));
    }

    @Test
    public void testFindCmdIdsForCancel() throws Exception {
        long cancelId = this.generateMigrateCommandForStatus(Status.CANCELED);
        this.mSearchingCriteria.add(Status.CANCELED);
        Set cancelCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)cancelCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)cancelCmdIds.contains(cancelId));
    }

    @Test
    public void testFindCmdIdsForMultipleCmds() throws Exception {
        long cancelId = this.generateLoadCommandForStatus(Status.CANCELED);
        long runningIdA = this.generateLoadCommandForStatus(Status.RUNNING);
        long runningIdB = this.generateLoadCommandForStatus(Status.RUNNING);
        long failedId = this.generateMigrateCommandForStatus(Status.FAILED);
        long completedIdA = this.generateMigrateCommandForStatus(Status.COMPLETED);
        long completedIB = this.generateMigrateCommandForStatus(Status.COMPLETED);
        long createdId = this.generateMigrateCommandForStatus(Status.CREATED);
        this.mSearchingCriteria.add(Status.CANCELED);
        Set cancelCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)cancelCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)cancelCmdIds.contains(cancelId));
        this.mSearchingCriteria.clear();
        this.mSearchingCriteria.add(Status.COMPLETED);
        Set completedCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)completedCmdIds.size(), (long)2L);
        Assert.assertTrue((boolean)completedCmdIds.contains(completedIdA));
        Assert.assertTrue((boolean)completedCmdIds.contains(completedIB));
        this.mSearchingCriteria.clear();
        this.mSearchingCriteria.add(Status.FAILED);
        Set failCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)failCmdIds.size(), (long)1L);
        Assert.assertTrue((boolean)failCmdIds.contains(failedId));
        this.mSearchingCriteria.clear();
        this.mSearchingCriteria.add(Status.RUNNING);
        Set runningCmdIds = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)runningCmdIds.size(), (long)3L);
        Assert.assertTrue((boolean)runningCmdIds.contains(runningIdA));
        Assert.assertTrue((boolean)runningCmdIds.contains(runningIdB));
        Assert.assertTrue((boolean)runningCmdIds.contains(createdId));
        this.mSearchingCriteria.clear();
        this.mSearchingCriteria.add(Status.COMPLETED);
        this.mSearchingCriteria.add(Status.RUNNING);
        Set ids = this.mCmdJobTracker.findCmdIds(this.mSearchingCriteria);
        Assert.assertEquals((long)ids.size(), (long)5L);
        Assert.assertTrue((boolean)ids.contains(completedIdA));
        Assert.assertTrue((boolean)ids.contains(completedIB));
        Assert.assertTrue((boolean)ids.contains(runningIdA));
        Assert.assertTrue((boolean)ids.contains(runningIdB));
        Assert.assertTrue((boolean)ids.contains(createdId));
    }

    @Test
    public void testGetCmdStatusBlock() throws Exception {
        CmdInfo cmdInfo = new CmdInfo(this.mMigrateJobId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        CmdStatusBlock expectedStatusBlock = new CmdStatusBlock(this.mMigrateJobId, OperationType.DIST_CP);
        int completedCount = 5;
        int runningCount = 5;
        int offset = completedCount;
        this.addJobStatusBlockWithStatus(Status.COMPLETED, cmdInfo, completedCount, expectedStatusBlock, 0);
        this.addJobStatusBlockWithStatus(Status.RUNNING, cmdInfo, runningCount, expectedStatusBlock, offset);
        this.prepareDistCpTest(cmdInfo, this.mMigrate, this.mMigrateJobId);
        this.mCmdJobTracker.run((CmdConfig)this.mMigrate, this.mMigrateJobId);
        CmdStatusBlock actualStatusBlock = this.mCmdJobTracker.getCmdStatusBlock(this.mMigrateJobId);
        Assert.assertEquals((long)actualStatusBlock.getJobControlId(), (long)expectedStatusBlock.getJobControlId());
        Assert.assertEquals((Object)actualStatusBlock.toProto(), (Object)expectedStatusBlock.toProto());
    }

    private void prepareDistLoadTest(CmdInfo cmdInfo, LoadCliConfig loadCliConfig, long loadId) throws Exception {
        AlluxioURI filePath = new AlluxioURI(loadCliConfig.getFilePath());
        int replication = loadCliConfig.getReplication();
        Set workerSet = loadCliConfig.getWorkerSet();
        Set excludedWorkerSet = loadCliConfig.getExcludedWorkerSet();
        Set localityIds = loadCliConfig.getLocalityIds();
        Set excludedLocalityIds = loadCliConfig.getExcludedLocalityIds();
        boolean directCache = loadCliConfig.getDirectCache();
        int batch = loadCliConfig.getBatchSize();
        Mockito.when((Object)this.mDistLoadRunner.runDistLoad(batch, filePath, replication, workerSet, excludedWorkerSet, localityIds, excludedLocalityIds, directCache, loadId)).thenReturn((Object)cmdInfo);
    }

    private void prepareDistCpTest(CmdInfo cmdInfo, MigrateCliConfig migrateCliConfig, long migrateId) throws Exception {
        AlluxioURI src = new AlluxioURI(migrateCliConfig.getSource());
        AlluxioURI dst = new AlluxioURI(migrateCliConfig.getDestination());
        boolean overwt = migrateCliConfig.getOverWrite();
        int batch = migrateCliConfig.getBatchSize();
        Mockito.when((Object)this.mMigrateCliRunner.runDistCp(src, dst, overwt, batch, migrateId)).thenReturn((Object)cmdInfo);
    }

    private void prepareAttemptWithStatus(Status status, CmdInfo cmdInfo, int number) {
        for (int i = 0; i < number; ++i) {
            CmdRunAttempt attempt = (CmdRunAttempt)Mockito.mock(CmdRunAttempt.class);
            long jobId = new Random().nextLong();
            Mockito.when((Object)attempt.getJobId()).thenReturn((Object)jobId);
            Mockito.when((Object)attempt.checkJobStatus()).thenReturn((Object)status);
            cmdInfo.addCmdRunAttempt(attempt);
        }
    }

    private long generateLoadCommandForStatus(Status status) throws Exception {
        long jobControlId = new Random().nextLong();
        LoadCliConfig config = new LoadCliConfig("/path/to/load", Integer.valueOf(3), Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, true);
        CmdInfo cmdInfo = new CmdInfo(jobControlId, OperationType.DIST_LOAD, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        switch (status) {
            case COMPLETED: {
                this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
                break;
            }
            case FAILED: {
                this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
                break;
            }
            case RUNNING: {
                this.prepareAttemptWithStatus(Status.RUNNING, cmdInfo, 1);
                break;
            }
            case CANCELED: {
                this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
                break;
            }
            case CREATED: {
                this.prepareAttemptWithStatus(Status.CREATED, cmdInfo, 5);
                break;
            }
            default: {
                throw new JobDoesNotExistException("No such job");
            }
        }
        this.prepareDistLoadTest(cmdInfo, config, jobControlId);
        this.mCmdJobTracker.run((CmdConfig)config, jobControlId);
        return jobControlId;
    }

    private long generateMigrateCommandForStatus(Status status) throws Exception {
        long jobControlId = new Random().nextLong();
        MigrateCliConfig config = new MigrateCliConfig("/path/from", "/path/to", WriteType.THROUGH, true, 2);
        CmdInfo cmdInfo = new CmdInfo(jobControlId, OperationType.DIST_CP, JobSource.CLI, System.currentTimeMillis(), Lists.newArrayList());
        switch (status) {
            case COMPLETED: {
                this.prepareAttemptWithStatus(Status.COMPLETED, cmdInfo, 5);
                break;
            }
            case FAILED: {
                this.prepareAttemptWithStatus(Status.FAILED, cmdInfo, 1);
                break;
            }
            case RUNNING: {
                this.prepareAttemptWithStatus(Status.RUNNING, cmdInfo, 1);
                break;
            }
            case CANCELED: {
                this.prepareAttemptWithStatus(Status.CANCELED, cmdInfo, 1);
                break;
            }
            case CREATED: {
                this.prepareAttemptWithStatus(Status.CREATED, cmdInfo, 5);
                break;
            }
            default: {
                throw new JobDoesNotExistException("No such job");
            }
        }
        this.prepareDistCpTest(cmdInfo, config, jobControlId);
        this.mCmdJobTracker.run((CmdConfig)config, jobControlId);
        return jobControlId;
    }

    private void addJobStatusBlockWithStatus(Status status, CmdInfo cmdInfo, int number, CmdStatusBlock cmdStatusBlock, int offset) {
        for (int i = 0; i < number; ++i) {
            CmdRunAttempt attempt = (CmdRunAttempt)Mockito.mock(CmdRunAttempt.class);
            String filePath = String.format("filePath-%s", i + offset);
            Mockito.when((Object)attempt.getJobId()).thenReturn((Object)(i + offset));
            Mockito.when((Object)attempt.checkJobStatus()).thenReturn((Object)status);
            Mockito.when((Object)attempt.getFilePath()).thenReturn((Object)filePath);
            cmdInfo.addCmdRunAttempt(attempt);
            cmdStatusBlock.addJobStatusBlock(new SimpleJobStatusBlock((long)(i + offset), status, filePath, ""));
        }
    }
}

