/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.workflow;

import alluxio.exception.status.ResourceExhaustedException;
import alluxio.job.JobConfig;
import alluxio.job.JobServerContext;
import alluxio.job.SleepJobConfig;
import alluxio.job.TestPlanConfig;
import alluxio.job.plan.PlanConfig;
import alluxio.job.plan.meta.PlanInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.WorkflowInfo;
import alluxio.job.workflow.WorkflowConfig;
import alluxio.job.workflow.composite.CompositeConfig;
import alluxio.master.job.JobMaster;
import alluxio.master.job.command.CommandManager;
import alluxio.master.job.plan.PlanTracker;
import alluxio.master.job.workflow.WorkflowTracker;
import alluxio.wire.WorkerInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WorkflowTrackerTest {
    private static final long CAPACITY = 5L;
    private static final long RETENTION_TIME = 0L;
    private static final long PURGE_CONUT = -1L;
    private PlanTracker mPlanTracker;
    private WorkflowTracker mWorkflowTracker;
    private JobMaster mMockJobMaster;
    private long mJobIdCounter;
    private ArrayList<WorkerInfo> mWorkers;
    private CommandManager mCommandManager;
    private JobServerContext mMockJobServerContext;

    @Before
    public void before() throws Exception {
        this.mMockJobMaster = (JobMaster)Mockito.mock(JobMaster.class);
        this.mWorkflowTracker = new WorkflowTracker(this.mMockJobMaster);
        this.mPlanTracker = new PlanTracker(5L, 0L, -1L, this.mWorkflowTracker);
        this.mJobIdCounter = 100L;
        Mockito.when((Object)this.mMockJobMaster.getNewJobId()).thenAnswer(invocation -> this.mJobIdCounter++);
        this.mWorkers = Lists.newArrayList((Object[])new WorkerInfo[]{new WorkerInfo()});
        this.mCommandManager = new CommandManager();
        this.mMockJobServerContext = (JobServerContext)Mockito.mock(JobServerContext.class);
    }

    @Test
    public void testEmpty() throws Exception {
        ArrayList jobs = Lists.newArrayList();
        CompositeConfig config = new CompositeConfig(jobs, Boolean.valueOf(true));
        this.mWorkflowTracker.run((WorkflowConfig)config, 0L);
        WorkflowInfo info = this.mWorkflowTracker.getStatus(0L, true);
        Assert.assertEquals((Object)Status.COMPLETED, (Object)info.getStatus());
    }

    @Test
    public void testBasic() throws Exception {
        ArrayList jobs = Lists.newArrayList();
        TestPlanConfig child1 = new TestPlanConfig("1");
        TestPlanConfig child2 = new TestPlanConfig("2");
        jobs.add(child1);
        jobs.add(child2);
        CompositeConfig config = new CompositeConfig(jobs, Boolean.valueOf(true));
        this.mWorkflowTracker.run((WorkflowConfig)config, 0L);
        ((JobMaster)Mockito.verify((Object)this.mMockJobMaster)).run((JobConfig)child1, 100L);
        WorkflowInfo info = this.mWorkflowTracker.getStatus(0L, true);
        Assert.assertEquals((Object)Status.RUNNING, (Object)info.getStatus());
        ((JobMaster)Mockito.verify((Object)this.mMockJobMaster, (VerificationMode)Mockito.never())).run((JobConfig)child2, 101L);
        PlanInfo plan100 = new PlanInfo(100L, (JobConfig)child1, null);
        plan100.setStatus(Status.COMPLETED);
        this.mWorkflowTracker.onPlanStatusChange(plan100);
        ((JobMaster)Mockito.verify((Object)this.mMockJobMaster)).run((JobConfig)child2, 101L);
        Assert.assertEquals((Object)Status.RUNNING, (Object)this.mWorkflowTracker.getStatus(0L, true).getStatus());
        PlanInfo plan101 = new PlanInfo(101L, (JobConfig)child2, null);
        plan101.setStatus(Status.COMPLETED);
        this.mWorkflowTracker.onPlanStatusChange(plan101);
        Assert.assertEquals((Object)Status.COMPLETED, (Object)this.mWorkflowTracker.getStatus(0L, true).getStatus());
    }

    @Test
    public void testCleanup() throws Exception {
        SleepJobConfig jobConfig = new SleepJobConfig(1L);
        this.mPlanTracker.run((PlanConfig)jobConfig, this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 1L);
        jobConfig = new SleepJobConfig(1L);
        this.mPlanTracker.run((PlanConfig)jobConfig, this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 2L);
        jobConfig = new SleepJobConfig(1L);
        this.mPlanTracker.run((PlanConfig)jobConfig, this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 3L);
        ((JobMaster)Mockito.doAnswer(invocation -> {
            PlanConfig config = (PlanConfig)invocation.getArgument(0, PlanConfig.class);
            long jobId = (Long)invocation.getArgument(1, Long.class);
            this.mPlanTracker.run(config, this.mCommandManager, this.mMockJobServerContext, this.mWorkers, jobId);
            return null;
        }).when((Object)this.mMockJobMaster)).run((JobConfig)Mockito.any(PlanConfig.class), ((Long)Mockito.any(Long.class)).longValue());
        ArrayList jobs = Lists.newArrayList();
        SleepJobConfig child1 = new SleepJobConfig(1L);
        SleepJobConfig child2 = new SleepJobConfig(2L);
        jobs.add(child1);
        jobs.add(child2);
        CompositeConfig config = new CompositeConfig(jobs, Boolean.valueOf(false));
        this.mWorkflowTracker.run((WorkflowConfig)config, 0L);
        try {
            this.mPlanTracker.run((PlanConfig)new SleepJobConfig(1L), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 4L);
            Assert.fail();
        }
        catch (ResourceExhaustedException resourceExhaustedException) {
            // empty catch block
        }
        this.mPlanTracker.coordinators().stream().filter(coordinator -> coordinator.getJobId() == 100L).findFirst().get().setJobAsFailed("TestError", "failed");
        this.mPlanTracker.run((PlanConfig)new SleepJobConfig(1L), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 4L);
        Assert.assertNotNull((Object)this.mWorkflowTracker.getStatus(0L, true));
        try {
            this.mPlanTracker.run((PlanConfig)new SleepJobConfig(1L), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 5L);
            Assert.fail();
        }
        catch (ResourceExhaustedException resourceExhaustedException) {
            // empty catch block
        }
        this.mPlanTracker.coordinators().stream().filter(coordinator -> coordinator.getJobId() == 101L).findFirst().get().setJobAsFailed("TestError", "failed");
        this.mPlanTracker.run((PlanConfig)new SleepJobConfig(1L), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, 5L);
        Assert.assertNull((Object)this.mWorkflowTracker.getStatus(100L, true));
    }
}

