/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.job.JobConfig;
import alluxio.job.plan.PlanDefinition;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public enum PlanDefinitionRegistry {
    INSTANCE;

    private static final Logger LOG;
    private final Map<Class<?>, PlanDefinition<?, ?, ?>> mDefinitions = new HashMap();

    private void discoverJobDefinitions() {
        ServiceLoader<PlanDefinition> discoveredDefinitions = ServiceLoader.load(PlanDefinition.class, PlanDefinition.class.getClassLoader());
        for (PlanDefinition definition : discoveredDefinitions) {
            this.add(definition.getJobConfigClass(), definition);
            LOG.info("Loaded job definition " + definition.getClass().getSimpleName() + " for config " + definition.getJobConfigClass().getName());
        }
    }

    private <T extends JobConfig> void add(Class<T> jobConfig, PlanDefinition<T, ?, ?> definition) {
        this.mDefinitions.put(jobConfig, definition);
    }

    public synchronized <T extends JobConfig> PlanDefinition<T, Serializable, Serializable> getJobDefinition(T jobConfig) throws JobDoesNotExistException {
        if (!this.mDefinitions.containsKey(jobConfig.getClass())) {
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobConfig.getName()}));
        }
        try {
            return (PlanDefinition)this.mDefinitions.get(jobConfig.getClass()).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(PlanDefinitionRegistry.class);
        INSTANCE.discoverJobDefinitions();
    }
}

