/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.batch;

import alluxio.collections.Pair;
import alluxio.job.JobConfig;
import alluxio.job.RunTaskContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.AbstractVoidPlanDefinition;
import alluxio.job.plan.BatchedJobConfig;
import alluxio.job.plan.PlanDefinition;
import alluxio.job.plan.load.LoadDefinition;
import alluxio.job.plan.migrate.MigrateDefinition;
import alluxio.job.plan.persist.PersistDefinition;
import alluxio.job.util.SerializableVoid;
import alluxio.wire.WorkerInfo;
import com.beust.jcommander.internal.Sets;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class BatchedJobDefinition
extends AbstractVoidPlanDefinition<BatchedJobConfig, BatchedJobTask> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedJobDefinition.class);

    @Override
    public Set<Pair<WorkerInfo, BatchedJobTask>> selectExecutors(BatchedJobConfig config, List<WorkerInfo> jobWorkerInfoList, SelectExecutorsContext context) throws Exception {
        String jobType = config.getJobType();
        PlanDefinition plan = JobDefinitionFactory.create(jobType);
        ObjectMapper mapper = new ObjectMapper();
        Class jobConfigClass = plan.getJobConfigClass();
        Set allTasks = Sets.newHashSet();
        for (Map configMap : config.getJobConfigs()) {
            JobConfig jobConfig = (JobConfig)mapper.convertValue((Object)configMap, jobConfigClass);
            Set tasks = plan.selectExecutors(jobConfig, jobWorkerInfoList, context);
            for (Pair task : tasks) {
                BatchedJobTask batchedTask = new BatchedJobTask(jobConfig, (Serializable)task.getSecond());
                allTasks.add(new Pair(task.getFirst(), (Object)batchedTask));
            }
        }
        return allTasks;
    }

    @Override
    public SerializableVoid runTask(BatchedJobConfig config, BatchedJobTask task, RunTaskContext context) throws Exception {
        String jobType = config.getJobType();
        PlanDefinition plan = JobDefinitionFactory.create(jobType);
        plan.runTask(task.getJobConfig(), task.getJobTaskArgs(), context);
        return null;
    }

    @Override
    public Class<BatchedJobConfig> getJobConfigClass() {
        return BatchedJobConfig.class;
    }

    public static class JobDefinitionFactory {
        public static PlanDefinition create(String jobName) {
            switch (jobName) {
                case "Load": {
                    return new LoadDefinition();
                }
                case "Migrate": {
                    return new MigrateDefinition();
                }
                case "Persist": {
                    return new PersistDefinition();
                }
            }
            throw new IllegalStateException("Batched Job currently doesn't support this jobType: " + jobName);
        }
    }

    public static class BatchedJobTask
    implements Serializable {
        private static final long serialVersionUID = -3643377264144315329L;
        final Serializable mJobTasks;
        final JobConfig mJobConfig;

        public BatchedJobTask(JobConfig config, Serializable jobTasks) {
            this.mJobConfig = config;
            this.mJobTasks = jobTasks;
        }

        public Serializable getJobTaskArgs() {
            return this.mJobTasks;
        }

        public JobConfig getJobConfig() {
            return this.mJobConfig;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("jobConfig", (Object)this.mJobConfig).add("jobTaskArgs", (Object)this.mJobTasks).toString();
        }
    }
}

