/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow;

import alluxio.job.JobConfig;
import alluxio.job.wire.Status;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.util.CommonUtils;
import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public abstract class WorkflowExecution {
    private Status mStatus;
    private long mLastUpdated;
    private String mErrorType;
    private String mErrorMessage;

    public WorkflowExecution() {
        this.setStatus(Status.RUNNING);
        this.mErrorType = null;
        this.mErrorMessage = null;
    }

    public abstract String getName();

    public final Set<JobConfig> next() {
        Preconditions.checkArgument((!this.mStatus.isFinished() ? 1 : 0) != 0);
        Set<JobConfig> jobConfigs = this.nextJobs();
        if (jobConfigs.isEmpty()) {
            this.setStatus(Status.COMPLETED);
        }
        this.mLastUpdated = CommonUtils.getCurrentMs();
        return jobConfigs;
    }

    public final void stop(Status status, String errorType, String errorMessage) {
        Preconditions.checkArgument((status.equals((Object)Status.CANCELED) || status.equals((Object)Status.FAILED) ? 1 : 0) != 0);
        this.setStatus(status);
        if (this.mErrorMessage == null) {
            this.mErrorType = errorType;
            this.mErrorMessage = errorMessage;
        }
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    public final long getLastUpdated() {
        return this.mLastUpdated;
    }

    @Nullable
    public final String getErrorType() {
        return this.mErrorType;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.mErrorMessage;
    }

    private void setStatus(Status status) {
        if (this.mStatus != status) {
            if (this.mStatus != null) {
                Metrics.counter(this.mStatus).dec();
            }
            Metrics.counter(status).inc();
        }
        this.mStatus = status;
        this.mLastUpdated = CommonUtils.getCurrentMs();
    }

    protected abstract Set<JobConfig> nextJobs();

    @ThreadSafe
    private static final class Metrics {
        private static final Counter JOB_CANCELED = MetricsSystem.counter((String)MetricKey.MASTER_JOB_CANCELED.getName());
        private static final Counter JOB_COMPLETED = MetricsSystem.counter((String)MetricKey.MASTER_JOB_COMPLETED.getName());
        private static final Counter JOB_CREATED = MetricsSystem.counter((String)MetricKey.MASTER_JOB_CREATED.getName());
        private static final Counter JOB_FAILED = MetricsSystem.counter((String)MetricKey.MASTER_JOB_FAILED.getName());
        private static final Counter JOB_RUNNING = MetricsSystem.counter((String)MetricKey.MASTER_JOB_RUNNING.getName());

        private Metrics() {
        }

        private static Counter counter(Status status) {
            switch (status) {
                case CANCELED: {
                    return JOB_CANCELED;
                }
                case COMPLETED: {
                    return JOB_COMPLETED;
                }
                case CREATED: {
                    return JOB_CREATED;
                }
                case FAILED: {
                    return JOB_FAILED;
                }
            }
            return JOB_RUNNING;
        }
    }
}

