/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow.composite;

import alluxio.job.JobConfig;
import alluxio.job.workflow.WorkflowExecution;
import alluxio.job.workflow.composite.CompositeConfig;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;

public class CompositeExecution
extends WorkflowExecution {
    private final ArrayList<JobConfig> mJobs;
    private final boolean mSequential;
    private int mPosition;

    public CompositeExecution(CompositeConfig compositeConfig) {
        this.mJobs = compositeConfig.getJobs();
        this.mSequential = compositeConfig.isSequential();
        this.mPosition = 0;
    }

    @Override
    public String getName() {
        return "Composite";
    }

    @Override
    protected Set<JobConfig> nextJobs() {
        if (this.mPosition >= this.mJobs.size()) {
            return Sets.newHashSet();
        }
        if (this.mSequential) {
            return Sets.newHashSet((Object[])new JobConfig[]{this.mJobs.get(this.mPosition++)});
        }
        this.mPosition = this.mJobs.size();
        return Sets.newHashSet(this.mJobs);
    }
}

