/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Server;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcServerBuilder;
import alluxio.grpc.JournalDomain;
import alluxio.master.AlluxioSimpleMasterProcess;
import alluxio.master.MasterContext;
import alluxio.master.MasterProcess;
import alluxio.master.MasterRegistry;
import alluxio.master.PrimarySelector;
import alluxio.master.job.JobMaster;
import alluxio.master.journal.DefaultJournalMaster;
import alluxio.master.journal.JournalMaster;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.raft.RaftJournalSystem;
import alluxio.master.journal.ufs.UfsJournalSingleMasterPrimarySelector;
import alluxio.master.service.SimpleService;
import alluxio.master.service.rpc.RpcServerService;
import alluxio.master.service.web.WebServerService;
import alluxio.underfs.JobUfsManager;
import alluxio.underfs.UfsManager;
import alluxio.util.CommonUtils;
import alluxio.util.URIUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.JobMasterWebServer;
import alluxio.web.WebServer;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioJobMasterProcess
extends AlluxioSimpleMasterProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioJobMasterProcess.class);

    AlluxioJobMasterProcess(JournalSystem journalSystem, PrimarySelector leaderSelector) {
        super("job", JournalDomain.JOB_MASTER, journalSystem, leaderSelector, NetworkAddressUtils.ServiceType.JOB_MASTER_WEB, NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, PropertyKey.JOB_MASTER_HOSTNAME);
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        FileSystem fileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
        JobUfsManager ufsManager = new JobUfsManager();
        try {
            MasterContext context = new MasterContext(this.mJournalSystem, leaderSelector, null, (UfsManager)ufsManager);
            this.mRegistry.add(JobMaster.class, (Server)new JobMaster(context, fileSystem, fsContext, (UfsManager)ufsManager));
            this.mRegistry.add(JournalMaster.class, (Server)new DefaultJournalMaster(JournalDomain.JOB_MASTER, context));
        }
        catch (Exception e) {
            LOG.error("Failed to create job master", (Throwable)e);
            throw new RuntimeException("Failed to create job master", e);
        }
    }

    public JobMaster getJobMaster() {
        return (JobMaster)this.mRegistry.get(JobMaster.class);
    }

    public WebServer createWebServer() {
        return new JobMasterWebServer(NetworkAddressUtils.ServiceType.JOB_MASTER_WEB.getServiceName(), this.mWebBindAddress, this);
    }

    public GrpcServerBuilder createBaseRpcServer() {
        return GrpcServerBuilder.forAddress((GrpcServerAddress)GrpcServerAddress.create((String)this.mRpcConnectAddress.getHostName(), (SocketAddress)this.mRpcBindAddress), (AlluxioConfiguration)Configuration.global()).flowControlWindow((int)Configuration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_FLOWCONTROL_WINDOW)).keepAliveTime(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).keepAliveTimeout(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_KEEPALIVE_TIMEOUT_MS), TimeUnit.MILLISECONDS).permitKeepAlive(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_PERMIT_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).maxInboundMessageSize((int)Configuration.getBytes((PropertyKey)PropertyKey.JOB_MASTER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
    }

    @ThreadSafe
    static final class Factory {
        public static AlluxioJobMasterProcess create() {
            Object primarySelector;
            URI journalLocation = JournalUtils.getJournalLocation();
            JournalSystem journalSystem = new JournalSystem.Builder().setLocation(URIUtils.appendPathOrDie((URI)journalLocation, (String)"JobJournal")).build(CommonUtils.ProcessType.JOB_MASTER);
            if (Configuration.getBoolean((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED)) {
                Preconditions.checkState((!(journalSystem instanceof RaftJournalSystem) ? 1 : 0) != 0, (Object)"Raft journal cannot be used with Zookeeper enabled");
                primarySelector = PrimarySelector.Factory.createZkJobPrimarySelector();
            } else {
                primarySelector = journalSystem instanceof RaftJournalSystem ? ((RaftJournalSystem)journalSystem).getPrimarySelector() : new UfsJournalSingleMasterPrimarySelector();
            }
            AlluxioJobMasterProcess ajmp = new AlluxioJobMasterProcess(journalSystem, (PrimarySelector)primarySelector);
            ajmp.registerService((SimpleService)RpcServerService.Factory.create((InetSocketAddress)ajmp.getRpcBindAddress(), (MasterProcess)ajmp, (MasterRegistry)ajmp.getRegistry()));
            ajmp.registerService((SimpleService)WebServerService.Factory.create((InetSocketAddress)ajmp.getWebBindAddress(), (MasterProcess)ajmp));
            return ajmp;
        }

        private Factory() {
        }
    }
}

