/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file;

import alluxio.AbstractMasterClient;
import alluxio.grpc.FileSystemMasterWorkerServiceGrpc;
import alluxio.grpc.GetFileInfoPRequest;
import alluxio.grpc.GetUfsInfoPRequest;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ServiceType;
import alluxio.grpc.UfsInfo;
import alluxio.master.MasterClientContext;
import alluxio.wire.FileInfo;
import io.grpc.Channel;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileSystemMasterClient
extends AbstractMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMasterClient.class);
    private FileSystemMasterWorkerServiceGrpc.FileSystemMasterWorkerServiceBlockingStub mClient = null;

    public FileSystemMasterClient(MasterClientContext conf) {
        super(conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.FILE_SYSTEM_MASTER_JOB_SERVICE;
    }

    protected String getServiceName() {
        return "FileSystemMasterJob";
    }

    protected long getServiceVersion() {
        return 2L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = FileSystemMasterWorkerServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    public FileInfo getFileInfo(long fileId) throws IOException {
        return (FileInfo)this.retryRPC(() -> GrpcUtils.fromProto((alluxio.grpc.FileInfo)this.mClient.getFileInfo(GetFileInfoPRequest.newBuilder().setFileId(fileId).build()).getFileInfo()), LOG, "GetFileInfo", "fileId=%d", new Object[]{fileId});
    }

    public UfsInfo getUfsInfo(long mountId) throws IOException {
        return (UfsInfo)this.retryRPC(() -> this.mClient.getUfsInfo(GetUfsInfoPRequest.newBuilder().setMountId(mountId).build()).getUfsInfo(), LOG, "GetUfsInfo", "mountId=%d", new Object[]{mountId});
    }
}

