/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.csv;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.Format;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.job.plan.transform.format.JobPath;
import alluxio.job.plan.transform.format.ReadWriterUtils;
import alluxio.job.plan.transform.format.TableReader;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.csv.CsvRow;
import alluxio.job.plan.transform.format.csv.CsvSchema;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.csv.AvroCSVReader;
import org.apache.parquet.cli.csv.CSVProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvReader
implements TableReader {
    private static final Logger LOG = LoggerFactory.getLogger(CsvReader.class);
    private final FileSystem mFs;
    private final AvroCSVReader<GenericData.Record> mReader;
    private final Closer mCloser = Closer.create();
    private final CsvSchema mSchema;

    private CsvReader(JobPath inputPath, PartitionInfo pInfo) throws IOException {
        try {
            this.mSchema = new CsvSchema(pInfo.getFields());
            Configuration conf = ReadWriterUtils.readNoCacheConf();
            this.mFs = inputPath.getFileSystem(conf);
            boolean isGzipped = pInfo.getFormat(inputPath.getName()).equals((Object)Format.GZIP_CSV);
            InputStream input = CsvReader.open(this.mFs, inputPath, isGzipped);
            CSVProperties props = this.buildProperties(pInfo.getTableProperties(), pInfo.getSerdeProperties());
            try {
                this.mReader = (AvroCSVReader)this.mCloser.register((Closeable)new AvroCSVReader(input, props, this.mSchema.getReadSchema(), GenericData.Record.class, false));
            }
            catch (RuntimeException e) {
                throw new IOException("Failed to create CSV reader", e);
            }
        }
        catch (IOException e) {
            try {
                this.mCloser.close();
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
    }

    private CSVProperties buildProperties(Map<String, String> tableProperties, Map<String, String> serdeProperties) {
        CSVProperties.Builder propsBuilder = new CSVProperties.Builder();
        if (tableProperties.containsKey("skip.header.line.count")) {
            propsBuilder.linesToSkip(Integer.parseInt(tableProperties.get("skip.header.line.count")));
        }
        if (serdeProperties.containsKey("field.delim")) {
            propsBuilder.delimiter(serdeProperties.get("field.delim"));
        }
        return propsBuilder.build();
    }

    private static InputStream open(FileSystem fs, Path path, boolean isGzipped) throws IOException {
        Object stream = fs.open(path);
        if (isGzipped) {
            stream = new GZIPInputStream((InputStream)stream);
        }
        return stream;
    }

    public static CsvReader create(AlluxioURI uri, PartitionInfo pInfo) throws IOException {
        JobPath path = new JobPath(uri.getScheme(), uri.getAuthority().toString(), uri.getPath());
        return new CsvReader(path, pInfo);
    }

    @Override
    public TableSchema getSchema() throws IOException {
        return this.mSchema;
    }

    @Override
    public TableRow read() throws IOException {
        try {
            return this.mReader.hasNext() ? new CsvRow(this.mSchema, (GenericData.Record)this.mReader.next()) : null;
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

