/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.ClientContext;
import alluxio.RuntimeConstants;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.clock.SystemClock;
import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.grpc.BuildVersion;
import alluxio.grpc.GrpcService;
import alluxio.grpc.JobCommand;
import alluxio.grpc.JobMasterHeartbeatPOptions;
import alluxio.grpc.JobMasterMetaCommand;
import alluxio.grpc.JobMasterStatus;
import alluxio.grpc.ListAllPOptions;
import alluxio.grpc.RegisterCommand;
import alluxio.grpc.RegisterJobMasterPOptions;
import alluxio.grpc.ServiceType;
import alluxio.heartbeat.FixedIntervalSupplier;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.job.CmdConfig;
import alluxio.job.JobConfig;
import alluxio.job.JobServerContext;
import alluxio.job.MasterWorkerInfo;
import alluxio.job.meta.JobIdGenerator;
import alluxio.job.plan.PlanConfig;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.JobServiceSummary;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.job.wire.PlanInfo;
import alluxio.job.wire.Status;
import alluxio.job.wire.TaskInfo;
import alluxio.job.wire.WorkflowInfo;
import alluxio.job.workflow.WorkflowConfig;
import alluxio.master.AbstractMaster;
import alluxio.master.MasterContext;
import alluxio.master.audit.AsyncUserAccessAuditLogWriter;
import alluxio.master.job.JobMasterAuditContext;
import alluxio.master.job.JobMasterClientServiceHandler;
import alluxio.master.job.JobMasterWorkerServiceHandler;
import alluxio.master.job.command.CommandManager;
import alluxio.master.job.plan.PlanCoordinator;
import alluxio.master.job.plan.PlanTracker;
import alluxio.master.job.tracker.CmdJobTracker;
import alluxio.master.job.workflow.WorkflowTracker;
import alluxio.master.journal.NoopJournaled;
import alluxio.master.meta.JobMasterInfo;
import alluxio.master.meta.JobMasterMasterServiceHandler;
import alluxio.master.meta.JobMasterSync;
import alluxio.master.meta.RetryHandlingJobMasterMasterClient;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.LockResource;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.ClientContextServerInjector;
import alluxio.underfs.UfsManager;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.IdUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.Address;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClientContext;
import com.codahale.metrics.Gauge;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JobMaster
extends AbstractMaster
implements NoopJournaled {
    private static final Logger LOG = LoggerFactory.getLogger(JobMaster.class);
    private final IndexDefinition<MasterWorkerInfo, Long> mIdIndex = IndexDefinition.ofUnique(MasterWorkerInfo::getId);
    private final IndexDefinition<MasterWorkerInfo, WorkerNetAddress> mAddressIndex = IndexDefinition.ofUnique(MasterWorkerInfo::getWorkerAddress);
    private static final IndexDefinition<JobMasterInfo, Long> ID_INDEX = IndexDefinition.ofUnique(JobMasterInfo::getId);
    private static final IndexDefinition<JobMasterInfo, Address> ADDRESS_INDEX = IndexDefinition.ofUnique(JobMasterInfo::getAddress);
    private final IndexedSet<JobMasterInfo> mJobMasters = new IndexedSet(ID_INDEX, new IndexDefinition[]{ADDRESS_INDEX});
    private final IndexedSet<JobMasterInfo> mLostJobMasters = new IndexedSet(ID_INDEX, new IndexDefinition[]{ADDRESS_INDEX});
    private final InetSocketAddress mRpcConnectAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, (AlluxioConfiguration)Configuration.global());
    private final int mPort;
    private final Address mJobMasterAddress;
    private final JobServerContext mJobServerContext;
    @GuardedBy(value="mWorkerRWLock")
    private final IndexedSet<MasterWorkerInfo> mWorkers = new IndexedSet(this.mIdIndex, new IndexDefinition[]{this.mAddressIndex});
    private final ConcurrentHashMap<Long, JobWorkerHealth> mWorkerHealth;
    private final ReentrantReadWriteLock mWorkerRWLock = new ReentrantReadWriteLock(true);
    private final AtomicLong mNextWorkerId = new AtomicLong(CommonUtils.getCurrentMs());
    private final CommandManager mCommandManager;
    private final PlanTracker mPlanTracker;
    private final WorkflowTracker mWorkflowTracker;
    private final JobIdGenerator mJobIdGenerator;
    private AsyncUserAccessAuditLogWriter mAsyncAuditLogWriter;
    private final CmdJobTracker mCmdJobTracker;

    public JobMaster(MasterContext masterContext, FileSystem filesystem, FileSystemContext fsContext, UfsManager ufsManager) {
        super(masterContext, (Clock)new SystemClock(), ExecutorServiceFactories.cachedThreadPool((String)"JobMaster"));
        this.mJobServerContext = new JobServerContext(filesystem, fsContext, ufsManager);
        this.mCommandManager = new CommandManager();
        this.mJobIdGenerator = new JobIdGenerator();
        this.mWorkflowTracker = new WorkflowTracker(this);
        this.mPort = NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, (AlluxioConfiguration)Configuration.global());
        this.mJobMasterAddress = new Address().setHost(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, (AlluxioConfiguration)Configuration.global())).setRpcPort(this.mPort);
        this.mPlanTracker = new PlanTracker(Configuration.getLong((PropertyKey)PropertyKey.JOB_MASTER_JOB_CAPACITY), Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_FINISHED_JOB_RETENTION_TIME), Configuration.getLong((PropertyKey)PropertyKey.JOB_MASTER_FINISHED_JOB_PURGE_COUNT), this.mWorkflowTracker);
        this.mWorkerHealth = new ConcurrentHashMap();
        this.mCmdJobTracker = new CmdJobTracker(fsContext, this);
        MetricsSystem.registerGaugeIfAbsent((String)MetricKey.MASTER_JOB_COUNT.getName(), () -> MetricsSystem.counter((String)MetricKey.MASTER_JOB_CANCELED.getName()).getCount() + MetricsSystem.counter((String)MetricKey.MASTER_JOB_COMPLETED.getName()).getCount() + MetricsSystem.counter((String)MetricKey.MASTER_JOB_CREATED.getName()).getCount() + MetricsSystem.counter((String)MetricKey.MASTER_JOB_FAILED.getName()).getCount() + MetricsSystem.counter((String)MetricKey.MASTER_JOB_RUNNING.getName()).getCount());
    }

    public long getNewJobId() {
        return this.mJobIdGenerator.getNewJobId();
    }

    public void start(Boolean isLeader) throws IOException {
        LOG.info("Job master starting with state {}", (Object)(isLeader != false ? "primary" : "standby"));
        super.start(isLeader);
        MetricsSystem.startSinks((String)Configuration.getString((PropertyKey)PropertyKey.METRICS_CONF_FILE));
        LOG.info("Updating job statuses");
        for (PlanCoordinator planCoordinator : this.mPlanTracker.coordinators()) {
            if (planCoordinator.isJobFinished()) continue;
            planCoordinator.setJobAsFailed("JobMasterShutdown", "Job failed: Job master shut down during execution");
        }
        if (isLeader.booleanValue()) {
            LOG.info("Starting job master as primary");
            this.getExecutorService().submit((Runnable)new HeartbeatThread("Job Master Lost Worker Detection", (HeartbeatExecutor)new LostWorkerDetectionHeartbeatExecutor(), () -> new FixedIntervalSupplier(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_LOST_WORKER_INTERVAL)), Configuration.global(), this.mMasterContext.getUserState()));
            this.getExecutorService().submit((Runnable)new HeartbeatThread("Job Master Lost Master Detection", (HeartbeatExecutor)new LostMasterDetectionHeartbeatExecutor(), () -> new FixedIntervalSupplier(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_LOST_MASTER_INTERVAL)), Configuration.global(), this.mMasterContext.getUserState()));
            this.mAsyncAuditLogWriter = new AsyncUserAccessAuditLogWriter("JOB_MASTER_AUDIT_LOG");
            this.mAsyncAuditLogWriter.start();
            MetricsSystem.registerGaugeIfAbsent((String)MetricKey.MASTER_AUDIT_LOG_ENTRIES_SIZE.getName(), () -> this.mAsyncAuditLogWriter != null ? this.mAsyncAuditLogWriter.getAuditLogEntriesSize() : -1L);
        } else {
            LOG.info("Starting job master as standby");
            if (ConfigurationUtils.isHaMode((AlluxioConfiguration)Configuration.global())) {
                RetryHandlingJobMasterMasterClient jobMasterClient = new RetryHandlingJobMasterMasterClient(JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
                this.getExecutorService().submit((Runnable)new HeartbeatThread("Job Master Sync", (HeartbeatExecutor)new JobMasterSync(this.mJobMasterAddress, jobMasterClient), () -> new FixedIntervalSupplier(Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_MASTER_HEARTBEAT_INTERVAL)), Configuration.global(), this.mMasterContext.getUserState()));
                LOG.info("Standby job master with address {} starts sending heartbeat to the primary.", (Object)this.mJobMasterAddress);
            }
        }
    }

    public void stop() throws IOException {
        if (this.mAsyncAuditLogWriter != null) {
            this.mAsyncAuditLogWriter.stop();
            this.mAsyncAuditLogWriter = null;
        }
        super.stop();
    }

    public Map<ServiceType, GrpcService> getServices() {
        HashMap services = Maps.newHashMap();
        services.put(ServiceType.JOB_MASTER_CLIENT_SERVICE, new GrpcService(ServerInterceptors.intercept((BindableService)new JobMasterClientServiceHandler(this), (ServerInterceptor[])new ServerInterceptor[]{new ClientContextServerInjector()})));
        services.put(ServiceType.JOB_MASTER_WORKER_SERVICE, new GrpcService((BindableService)new JobMasterWorkerServiceHandler(this)));
        services.put(ServiceType.JOB_MASTER_MASTER_SERVICE, new GrpcService((BindableService)new JobMasterMasterServiceHandler(this)));
        return services;
    }

    public String getName() {
        return "JobMaster";
    }

    public synchronized long run(JobConfig jobConfig) throws JobDoesNotExistException, ResourceExhaustedException {
        long jobId = this.getNewJobId();
        this.run(jobConfig, jobId);
        return jobId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run(JobConfig jobConfig, long jobId) throws JobDoesNotExistException, ResourceExhaustedException {
        Context forkedCtx = Context.current().fork();
        Context prevCtx = forkedCtx.attach();
        try (JobMasterAuditContext auditContext = this.createAuditContext("run");){
            auditContext.setJobId(jobId);
            auditContext.setJobName(jobConfig.getName());
            if (jobConfig instanceof PlanConfig) {
                this.mPlanTracker.run((PlanConfig)jobConfig, this.mCommandManager, this.mJobServerContext, this.getWorkerInfoList(), jobId);
                auditContext.setSucceeded(true);
                return;
            }
            if (jobConfig instanceof WorkflowConfig) {
                this.mWorkflowTracker.run((WorkflowConfig)jobConfig, jobId);
                auditContext.setSucceeded(true);
                return;
            }
            throw new JobDoesNotExistException(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{jobConfig.getName()}));
        }
        finally {
            forkedCtx.detach(prevCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long submit(CmdConfig cmdConfig) throws JobDoesNotExistException, IOException {
        long jobControlId = this.getNewJobId();
        Context forkedCtx = Context.current().fork();
        Context prevCtx = forkedCtx.attach();
        try (JobMasterAuditContext auditContext = this.createAuditContext("run");){
            auditContext.setJobId(jobControlId);
            this.mCmdJobTracker.run(cmdConfig, jobControlId);
        }
        finally {
            forkedCtx.detach(prevCtx);
        }
        return jobControlId;
    }

    public void cancel(long jobId) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("cancel");){
            auditContext.setJobId(jobId);
            PlanCoordinator planCoordinator = this.mPlanTracker.getCoordinator(jobId);
            if (planCoordinator == null) {
                if (!this.mWorkflowTracker.cancel(jobId)) {
                    throw new JobDoesNotExistException(jobId);
                }
                return;
            }
            planCoordinator.cancel();
            auditContext.setSucceeded(true);
        }
    }

    public Status getCmdStatus(long jobControlId) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getCmdStatus");){
            auditContext.setJobId(jobControlId);
            Status status = this.mCmdJobTracker.getCmdStatus(jobControlId);
            return status;
        }
    }

    public List<Long> list(ListAllPOptions options) {
        try (JobMasterAuditContext auditContext = this.createAuditContext("list");){
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.addAll(this.mPlanTracker.findJobs(options.getName(), options.getStatusList().stream().map(status -> Status.valueOf((String)status.name())).collect(Collectors.toList())));
            ids.addAll(this.mWorkflowTracker.findJobs(options.getName(), options.getStatusList().stream().map(status -> Status.valueOf((String)status.name())).collect(Collectors.toList())));
            Collections.sort(ids);
            auditContext.setSucceeded(true);
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    public List<Long> listCmds(ListAllPOptions options) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("listCmds");){
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.addAll(this.mCmdJobTracker.findCmdIds(options.getStatusList().stream().map(status -> Status.valueOf((String)status.name())).collect(Collectors.toList())));
            Collections.sort(ids);
            auditContext.setSucceeded(true);
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    public CmdStatusBlock getCmdStatusDetailed(long jobControlId) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getCmdStatusDetailed");){
            CmdStatusBlock cmdStatusBlock = this.mCmdJobTracker.getCmdStatusBlock(jobControlId);
            return cmdStatusBlock;
        }
    }

    public Set<String> getAllFailedPaths() {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getAllFailedPaths");){
            HashSet<String> ids = new HashSet<String>();
            ids.addAll(this.mCmdJobTracker.findAllFailedPaths());
            auditContext.setSucceeded(true);
            HashSet<String> hashSet = ids;
            return hashSet;
        }
    }

    public Set<String> getFailedPaths(long jobControlId) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getFailedPaths");){
            HashSet<String> ids = new HashSet<String>();
            ids.addAll(this.mCmdJobTracker.findFailedPaths(jobControlId));
            auditContext.setSucceeded(true);
            HashSet<String> hashSet = ids;
            return hashSet;
        }
    }

    public List<JobInfo> listDetailed() {
        try (JobMasterAuditContext auditContext = this.createAuditContext("listDetailed");){
            ArrayList<Object> jobInfos = new ArrayList<Object>();
            for (PlanCoordinator coordinator : this.mPlanTracker.coordinators()) {
                jobInfos.add(coordinator.getPlanInfoWire(false));
            }
            jobInfos.addAll(this.mWorkflowTracker.getAllInfo());
            jobInfos.sort(Comparator.comparingLong(JobInfo::getId));
            auditContext.setSucceeded(true);
            ArrayList<Object> arrayList = jobInfos;
            return arrayList;
        }
    }

    public List<JobInfo> failed(int limit, long before, long after) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        this.mPlanTracker.failed().filter(planInfoMeta -> {
            long lastStatusChangeMs = planInfoMeta.getLastStatusChangeMs();
            if (before >= 0L && before <= lastStatusChangeMs) {
                return false;
            }
            return after < lastStatusChangeMs;
        }).filter(planInfoMeta -> planInfoMeta.getLastStatusChangeMs() > after).limit(limit).forEachOrdered(planInfoMeta -> jobInfos.add((JobInfo)new PlanInfo(planInfoMeta, false)));
        return jobInfos;
    }

    public JobInfo getStatus(long jobId) throws JobDoesNotExistException {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getStatus");){
            auditContext.setJobId(jobId);
            JobInfo jobInfo = this.getStatus(jobId, true);
            if (jobInfo != null) {
                auditContext.setJobName(jobInfo.getName());
                auditContext.setSucceeded(true);
            }
            JobInfo jobInfo2 = jobInfo;
            return jobInfo2;
        }
    }

    public JobInfo getStatus(long jobId, boolean verbose) throws JobDoesNotExistException {
        PlanCoordinator planCoordinator = this.mPlanTracker.getCoordinator(jobId);
        if (planCoordinator == null) {
            WorkflowInfo status = this.mWorkflowTracker.getStatus(jobId, verbose);
            if (status == null) {
                throw new JobDoesNotExistException(jobId);
            }
            return status;
        }
        return planCoordinator.getPlanInfoWire(verbose);
    }

    public JobServiceSummary getSummary() {
        return new JobServiceSummary(this.listDetailed());
    }

    public List<JobWorkerHealth> getAllWorkerHealth() {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getAllWorkerHealth");){
            ArrayList result = Lists.newArrayList(this.mWorkerHealth.values());
            result.sort(Comparator.comparingLong(JobWorkerHealth::getWorkerId));
            auditContext.setSucceeded(true);
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    public List<JobMasterStatus> getAllJobMasterStatus() {
        try (JobMasterAuditContext auditContext = this.createAuditContext("getAllMasterStatus");){
            JobMasterStatus status;
            ArrayList<JobMasterStatus> result = new ArrayList<JobMasterStatus>();
            SortedMap gauges = MetricsSystem.METRIC_REGISTRY.getGauges();
            Gauge startTimeGauge = (Gauge)gauges.get(MetricKey.MASTER_START_TIME.getName());
            JobMasterStatus primaryStatus = JobMasterStatus.newBuilder().setMasterAddress(this.mJobMasterAddress.toProto()).setState("PRIMARY").setStartTime(((Long)startTimeGauge.getValue()).longValue()).setVersion(RuntimeConstants.CURRENT_VERSION_INFO).build();
            result.add(primaryStatus);
            for (JobMasterInfo standbyJobMaster : this.mJobMasters) {
                status = JobMasterStatus.newBuilder().setMasterAddress(standbyJobMaster.getAddress().toProto()).setState("STANDBY").setStartTime(standbyJobMaster.getStartTimeMs()).setVersion(standbyJobMaster.getVersion()).build();
                result.add(status);
            }
            for (JobMasterInfo standbyJobMaster : this.mLostJobMasters) {
                status = JobMasterStatus.newBuilder().setMasterAddress(standbyJobMaster.getAddress().toProto()).setState("LOST").setStartTime(standbyJobMaster.getStartTimeMs()).setVersion(standbyJobMaster.getVersion()).build();
                result.add(status);
            }
            auditContext.setSucceeded(true);
            ArrayList<JobMasterStatus> arrayList = result;
            return arrayList;
        }
    }

    public long registerWorker(WorkerNetAddress workerNetAddress, BuildVersion version) {
        try (LockResource workersLockExclusive = new LockResource((Lock)this.mWorkerRWLock.writeLock());){
            if (this.mWorkers.contains(this.mAddressIndex, (Object)workerNetAddress)) {
                LOG.info("Worker at address {} is re-registering. Failing tasks for previous worker at that address", (Object)workerNetAddress);
                MasterWorkerInfo deadWorker = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mAddressIndex, (Object)workerNetAddress);
                for (PlanCoordinator planCoordinator : this.mPlanTracker.coordinators()) {
                    planCoordinator.failTasksForWorker(deadWorker.getId());
                }
                this.mWorkerHealth.remove(deadWorker.getId());
                this.mWorkers.remove((Object)deadWorker);
            }
            long workerId = this.mNextWorkerId.getAndIncrement();
            this.mWorkers.add((Object)new MasterWorkerInfo(workerId, workerNetAddress, version));
            LOG.info("registerWorker(): WorkerNetAddress: {} id: {} version-revision: {}-{}", new Object[]{workerNetAddress, workerId, version.getVersion(), version.getRevision()});
            long l = workerId;
            return l;
        }
    }

    public List<WorkerInfo> getWorkerInfoList() {
        ArrayList<WorkerInfo> workerInfoList = new ArrayList<WorkerInfo>(this.mWorkers.size());
        try (LockResource workersLockShared = new LockResource((Lock)this.mWorkerRWLock.readLock());){
            for (MasterWorkerInfo masterWorkerInfo : this.mWorkers) {
                workerInfoList.add(masterWorkerInfo.generateClientWorkerInfo());
            }
        }
        return workerInfoList;
    }

    public void setTaskPoolSize(int taskPoolSize) {
        try (LockResource workersLockShared = new LockResource((Lock)this.mWorkerRWLock.readLock());){
            for (MasterWorkerInfo worker : this.mWorkers) {
                this.mCommandManager.submitSetTaskPoolSizeCommand(worker.getId(), taskPoolSize);
            }
        }
    }

    public List<JobCommand> workerHeartbeat(JobWorkerHealth jobWorkerHealth, List<TaskInfo> taskInfoList) {
        String hostname;
        long workerId = jobWorkerHealth.getWorkerId();
        LockResource workersLockShared = new LockResource((Lock)this.mWorkerRWLock.readLock());
        Iterator iterator = null;
        try {
            MasterWorkerInfo worker = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)workerId);
            if (worker == null) {
                List<JobCommand> list = Collections.singletonList(JobCommand.newBuilder().setRegisterCommand(RegisterCommand.getDefaultInstance()).build());
                return list;
            }
            hostname = worker.getWorkerAddress().getHost();
            worker.updateLastUpdatedTimeMs();
        }
        catch (Throwable worker) {
            iterator = worker;
            throw worker;
        }
        finally {
            if (workersLockShared != null) {
                if (iterator != null) {
                    try {
                        workersLockShared.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    workersLockShared.close();
                }
            }
        }
        this.mWorkerHealth.put(workerId, jobWorkerHealth);
        HashMap taskInfosPerJob = new HashMap();
        for (TaskInfo taskInfo : taskInfoList) {
            taskInfo.setWorkerHost(hostname);
            if (!taskInfosPerJob.containsKey(taskInfo.getJobId())) {
                taskInfosPerJob.put(taskInfo.getJobId(), new ArrayList());
            }
            ((List)taskInfosPerJob.get(taskInfo.getJobId())).add(taskInfo);
        }
        for (Map.Entry taskInfosPair : taskInfosPerJob.entrySet()) {
            PlanCoordinator planCoordinator = this.mPlanTracker.getCoordinator((Long)taskInfosPair.getKey());
            if (planCoordinator == null) continue;
            planCoordinator.updateTasks((List)taskInfosPair.getValue());
        }
        return this.mCommandManager.pollAllPendingCommands(workerId);
    }

    public JobMasterMetaCommand jobMasterHeartbeat(long masterId, JobMasterHeartbeatPOptions options) {
        JobMasterInfo master = (JobMasterInfo)this.mJobMasters.getFirstByField(ID_INDEX, (Object)masterId);
        if (master == null) {
            LOG.warn("Could not find master id: {} for heartbeat. Instructed to register", (Object)masterId);
            return JobMasterMetaCommand.MetaCommand_Register;
        }
        master.updateLastUpdatedTimeMs();
        return JobMasterMetaCommand.MetaCommand_Nothing;
    }

    public void jobMasterRegister(long masterId, RegisterJobMasterPOptions options) throws NotFoundException {
        LOG.info("Job master {} attempts to register", (Object)masterId);
        JobMasterInfo master = (JobMasterInfo)this.mJobMasters.getFirstByField(ID_INDEX, (Object)masterId);
        if (master == null) {
            throw new NotFoundException(MessageFormat.format("No master with masterId {0,number,#} is found", masterId));
        }
        master.updateLastUpdatedTimeMs();
        if (options.hasStartTimeMs()) {
            master.setStartTimeMs(options.getStartTimeMs());
        }
        if (options.hasLosePrimacyTimeMs()) {
            master.setLosePrimacyTimeMs(options.getLosePrimacyTimeMs());
        }
        if (options.hasVersion()) {
            master.setVersion(options.getVersion());
        } else {
            master.setVersion(RuntimeConstants.UNKNOWN_VERSION_INFO);
        }
        LOG.info("registerMaster(): master: {}", (Object)master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMasterId(Address address) {
        JobMasterInfo existingMaster = (JobMasterInfo)this.mJobMasters.getFirstByField(ADDRESS_INDEX, (Object)address);
        if (existingMaster != null) {
            long oldMasterId = existingMaster.getId();
            LOG.warn("The master {} already exists as id {}.", (Object)address, (Object)oldMasterId);
            return oldMasterId;
        }
        JobMasterInfo lostMaster = (JobMasterInfo)this.mLostJobMasters.getFirstByField(ADDRESS_INDEX, (Object)address);
        if (lostMaster != null) {
            JobMasterInfo jobMasterInfo = lostMaster;
            synchronized (jobMasterInfo) {
                long lostMasterId = lostMaster.getId();
                LOG.warn("A lost master {} has requested its old id {}.", (Object)address, (Object)lostMasterId);
                lostMaster.updateLastUpdatedTimeMs();
                this.mJobMasters.add((Object)lostMaster);
                this.mLostJobMasters.remove((Object)lostMaster);
                return lostMasterId;
            }
        }
        long masterId = IdUtils.getRandomNonNegativeLong();
        while (!this.mJobMasters.add((Object)new JobMasterInfo(masterId, address))) {
            masterId = IdUtils.getRandomNonNegativeLong();
        }
        LOG.info("getMasterId(): MasterAddress: {} id: {}", (Object)address, (Object)masterId);
        return masterId;
    }

    private JobMasterAuditContext createAuditContext(String command) {
        AsyncUserAccessAuditLogWriter auditLogWriter = null;
        if (Configuration.getBoolean((PropertyKey)PropertyKey.MASTER_AUDIT_LOGGING_ENABLED)) {
            auditLogWriter = this.mAsyncAuditLogWriter;
        }
        JobMasterAuditContext auditContext = new JobMasterAuditContext(auditLogWriter);
        if (auditLogWriter != null) {
            String user = null;
            String ugi = "";
            try {
                user = AuthenticatedClientUser.getClientUser((AlluxioConfiguration)Configuration.global());
            }
            catch (AccessControlException e) {
                ugi = "N/A";
            }
            if (user != null) {
                try {
                    String primaryGroup = CommonUtils.getPrimaryGroupName((String)user, (AlluxioConfiguration)Configuration.global());
                    ugi = user + "," + primaryGroup;
                }
                catch (IOException e) {
                    LOG.debug("Failed to get primary group for user {}.", (Object)user);
                    ugi = user + ",N/A";
                }
            }
            AuthType authType = (AuthType)Configuration.getEnum((PropertyKey)PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            auditContext.setUgi(ugi).setAuthType(authType).setIp(ClientContextServerInjector.getIpAddress()).setClientVersion(ClientContextServerInjector.getClientVersion()).setCommand(command).setAllowed(true).setCreationTimeNs(System.nanoTime());
        }
        return auditContext;
    }

    private final class LostWorkerDetectionHeartbeatExecutor
    implements HeartbeatExecutor {
        public void heartbeat(long timeLimitMs) {
            long lastUpdate;
            int masterWorkerTimeoutMs = (int)Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_WORKER_TIMEOUT);
            ArrayList<MasterWorkerInfo> lostWorkers = new ArrayList<MasterWorkerInfo>();
            try (LockResource workersLockShared = new LockResource((Lock)JobMaster.this.mWorkerRWLock.readLock());){
                for (MasterWorkerInfo worker : JobMaster.this.mWorkers) {
                    lastUpdate = JobMaster.this.mClock.millis() - worker.getLastUpdatedTimeMs();
                    if (lastUpdate <= (long)masterWorkerTimeoutMs) continue;
                    LOG.warn("The worker {} timed out after {}ms without a heartbeat!", (Object)worker, (Object)lastUpdate);
                    lostWorkers.add(worker);
                    for (PlanCoordinator planCoordinator : JobMaster.this.mPlanTracker.coordinators()) {
                        planCoordinator.failTasksForWorker(worker.getId());
                    }
                }
            }
            if (!lostWorkers.isEmpty()) {
                var6_5 = null;
                try (LockResource workersLockExclusive = new LockResource((Lock)JobMaster.this.mWorkerRWLock.writeLock());){
                    for (MasterWorkerInfo lostWorker : lostWorkers) {
                        lastUpdate = JobMaster.this.mClock.millis() - lostWorker.getLastUpdatedTimeMs();
                        if (lastUpdate <= (long)masterWorkerTimeoutMs) continue;
                        JobMaster.this.mWorkerHealth.remove(lostWorker.getId());
                        JobMaster.this.mWorkers.remove((Object)lostWorker);
                    }
                }
                catch (Throwable throwable) {
                    var6_5 = throwable;
                    throw throwable;
                }
            }
        }

        public void close() {
        }
    }

    private final class LostMasterDetectionHeartbeatExecutor
    implements HeartbeatExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void heartbeat(long timeout) {
            long masterTimeoutMs = Configuration.getMs((PropertyKey)PropertyKey.JOB_MASTER_MASTER_TIMEOUT);
            Iterator iterator = JobMaster.this.mJobMasters.iterator();
            while (iterator.hasNext()) {
                JobMasterInfo master;
                JobMasterInfo jobMasterInfo = master = (JobMasterInfo)iterator.next();
                synchronized (jobMasterInfo) {
                    long lastUpdate = JobMaster.this.mClock.millis() - master.getLastUpdatedTimeMs();
                    if (lastUpdate > masterTimeoutMs) {
                        LOG.error("A standby job master {}({}) timed out after {}ms without a heartbeat!", new Object[]{master.getId(), master.getAddress(), lastUpdate});
                        JobMaster.this.mLostJobMasters.add((Object)master);
                        JobMaster.this.mJobMasters.remove((Object)master);
                    }
                }
            }
        }

        public void close() {
        }
    }
}

