/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.RestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.grpc.ListAllPOptions;
import alluxio.job.JobConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.AlluxioJobMasterProcess;
import alluxio.master.job.JobMaster;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="master/job")
@Produces(value={"application/json"})
@Api(value="/master")
public final class JobMasterClientRestServiceHandler {
    private final JobMaster mJobMaster;

    public JobMasterClientRestServiceHandler(@Context ServletContext context) {
        this.mJobMaster = ((AlluxioJobMasterProcess)((Object)context.getAttribute("Alluxio Job Master"))).getJobMaster();
    }

    @GET
    @Path(value="service_name")
    public Response getServiceName() {
        return RestUtils.call(() -> "JobMasterClient", (AlluxioConfiguration)Configuration.global());
    }

    @GET
    @Path(value="service_version")
    public Response getServiceVersion() {
        return RestUtils.call(() -> 1, (AlluxioConfiguration)Configuration.global());
    }

    @POST
    @Path(value="cancel")
    public Response cancel(@QueryParam(value="jobId") long jobId) {
        return RestUtils.call(() -> {
            this.mJobMaster.cancel(jobId);
            return null;
        }, (AlluxioConfiguration)Configuration.global());
    }

    @GET
    @Path(value="get_status")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @ApiOperation(value="Gets the status of a job", response=JobInfo.class)
    public Response getStatus(@QueryParam(value="jobId") long jobId) {
        return RestUtils.call(() -> this.mJobMaster.getStatus(jobId), (AlluxioConfiguration)Configuration.global());
    }

    @GET
    @Path(value="list")
    public Response list(@QueryParam(value="status") List<String> statusList, @QueryParam(value="name") String name) {
        return RestUtils.call(() -> {
            if (statusList != null) {
                return this.mJobMaster.list(ListAllPOptions.newBuilder().addAllStatus((Iterable)statusList.stream().map(Status::valueOf).map(Status::toProto).collect(Collectors.toList())).setName(Objects.toString(name, "")).build());
            }
            return this.mJobMaster.list(ListAllPOptions.getDefaultInstance());
        }, (AlluxioConfiguration)Configuration.global());
    }

    @POST
    @Path(value="run")
    @Consumes(value={"application/json"})
    public Response run(JobConfig jobConfig) {
        return RestUtils.call(() -> this.mJobMaster.run(jobConfig), (AlluxioConfiguration)Configuration.global());
    }
}

