/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.RpcUtils;
import alluxio.RuntimeConstants;
import alluxio.grpc.BuildVersion;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.JobHeartbeatPRequest;
import alluxio.grpc.JobHeartbeatPResponse;
import alluxio.grpc.JobInfo;
import alluxio.grpc.JobMasterWorkerServiceGrpc;
import alluxio.grpc.RegisterJobWorkerPRequest;
import alluxio.grpc.RegisterJobWorkerPResponse;
import alluxio.grpc.WorkerNetAddress;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.job.wire.TaskInfo;
import alluxio.master.job.JobMaster;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JobMasterWorkerServiceHandler
extends JobMasterWorkerServiceGrpc.JobMasterWorkerServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(JobMasterWorkerServiceHandler.class);
    private final JobMaster mJobMaster;

    public JobMasterWorkerServiceHandler(JobMaster JobMaster2) {
        this.mJobMaster = (JobMaster)((Object)Preconditions.checkNotNull((Object)((Object)JobMaster2)));
    }

    public void heartbeat(JobHeartbeatPRequest request, StreamObserver<JobHeartbeatPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            ArrayList wireTaskInfoList = Lists.newArrayList();
            for (JobInfo taskInfo : request.getTaskInfosList()) {
                try {
                    wireTaskInfoList.add(new TaskInfo(taskInfo));
                }
                catch (IOException e) {
                    LOG.error("task info deserialization failed " + e);
                }
            }
            JobWorkerHealth jobWorkerHealth = new JobWorkerHealth(request.getJobWorkerHealth());
            return JobHeartbeatPResponse.newBuilder().addAllCommands(this.mJobMaster.workerHeartbeat(jobWorkerHealth, wireTaskInfoList)).build();
        }, (String)"heartbeat", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void registerJobWorker(RegisterJobWorkerPRequest request, StreamObserver<RegisterJobWorkerPResponse> responseObserver) {
        LOG.info("Received job worker {}", (Object)request);
        BuildVersion version = request.hasVersion() ? request.getVersion() : RuntimeConstants.UNKNOWN_VERSION_INFO;
        RpcUtils.call((Logger)LOG, () -> RegisterJobWorkerPResponse.newBuilder().setId(this.mJobMaster.registerWorker(GrpcUtils.fromProto((WorkerNetAddress)request.getWorkerNetAddress()), version)).build(), (String)"registerJobWorker", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }
}

