/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.metrics;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.job.JobConfig;
import alluxio.job.plan.BatchedJobConfig;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.retry.RetryPolicy;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCmdMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedCmdMetrics.class);
    private static final Counter JOB_DISTRIBUTED_LOAD_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_SUCCESS.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FAIL.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_CANCEL.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FILE_COUNT.getName());
    private static final Counter JOB_DISTRIBUTED_LOAD_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_FILE_SIZE.getName());
    private static final Meter JOB_DISTRIBUTED_LOAD_RATE = MetricsSystem.meter((String)MetricKey.MASTER_JOB_DISTRIBUTED_LOAD_RATE.getName());
    private static final Counter MIGRATE_JOB_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_SUCCESS.getName());
    private static final Counter MIGRATE_JOB_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FAIL.getName());
    private static final Counter MIGRATE_JOB_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_CANCEL.getName());
    private static final Counter MIGRATE_JOB_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FILE_COUNT.getName());
    private static final Counter MIGRATE_JOB_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_MIGRATE_JOB_FILE_SIZE.getName());
    private static final Counter ASYNC_PERSIST_SUCCESS = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_SUCCESS.getName());
    private static final Counter ASYNC_PERSIST_FAIL = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FAIL.getName());
    private static final Counter ASYNC_PERSIST_CANCEL = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_CANCEL.getName());
    private static final Counter ASYNC_PERSIST_FILE_COUNT = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_COUNT.getName());
    private static final Counter ASYNC_PERSIST_FILE_SIZE = MetricsSystem.counter((String)MetricKey.MASTER_ASYNC_PERSIST_FILE_SIZE.getName());
    private static final long DEFAULT_INCREMENT_VALUE = 1L;

    public static void incrementForFailStatus(String jobType, long count) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_FAIL.inc(count);
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_FAIL.inc(count);
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_FAIL.inc(count);
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static void incrementForCancelStatus(String jobType, long count) {
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_CANCEL.inc(count);
                break;
            }
            case "Migrate": {
                MIGRATE_JOB_CANCEL.inc(count);
                break;
            }
            case "Persist": {
                ASYNC_PERSIST_CANCEL.inc(count);
                break;
            }
            default: {
                LOG.warn("JobType does not belong to Load, Migrate and Persist");
            }
        }
    }

    public static long getFileSize(String filePath, FileSystem fileSystem, RetryPolicy retryPolicy) {
        while (retryPolicy.attempt()) {
            try {
                return fileSystem.getStatus(new AlluxioURI(filePath)).getLength();
            }
            catch (AlluxioException | IOException | RuntimeException e) {
                LOG.warn("Retry getStatus for URI {} for {}-th time, {}", new Object[]{filePath, retryPolicy.getAttemptCount(), Arrays.toString(e.getStackTrace())});
            }
        }
        return 0L;
    }

    public static void incrementForCompleteStatusWithRetry(JobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        if (config instanceof LoadConfig) {
            String filePath = ((LoadConfig)config).getFilePath();
            JOB_DISTRIBUTED_LOAD_SUCCESS.inc(1L);
            JOB_DISTRIBUTED_LOAD_FILE_COUNT.inc(1L);
            long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
            JOB_DISTRIBUTED_LOAD_FILE_SIZE.inc(fileSize);
            JOB_DISTRIBUTED_LOAD_RATE.mark(fileSize);
        } else if (config instanceof MigrateConfig) {
            String filePath = ((MigrateConfig)config).getSource();
            MIGRATE_JOB_SUCCESS.inc(1L);
            MIGRATE_JOB_FILE_COUNT.inc(1L);
            long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
            MIGRATE_JOB_FILE_SIZE.inc(fileSize);
        } else if (config instanceof PersistConfig) {
            String filePath = ((PersistConfig)config).getFilePath();
            ASYNC_PERSIST_SUCCESS.inc(1L);
            ASYNC_PERSIST_FILE_COUNT.inc(1L);
            long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
            ASYNC_PERSIST_FILE_SIZE.inc(fileSize);
        } else {
            LOG.warn("JobType does not belong to Load, Migrate and Persist");
        }
    }

    public static void batchIncrementForCompleteStatusWithRetry(BatchedJobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        String jobType = config.getJobType();
        long count = config.getJobConfigs().size();
        switch (jobType) {
            case "Load": {
                JOB_DISTRIBUTED_LOAD_SUCCESS.inc(count);
                JOB_DISTRIBUTED_LOAD_FILE_COUNT.inc(count);
                for (Map jobConfig : config.getJobConfigs()) {
                    String filePath = (String)jobConfig.get("filePath");
                    long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
                    JOB_DISTRIBUTED_LOAD_FILE_SIZE.inc(fileSize);
                    JOB_DISTRIBUTED_LOAD_RATE.mark(fileSize);
                }
                return;
            }
            case "Migrate": {
                MIGRATE_JOB_SUCCESS.inc(count);
                MIGRATE_JOB_FILE_COUNT.inc(count);
                for (Map jobConfig : config.getJobConfigs()) {
                    String filePath = (String)jobConfig.get("source");
                    long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
                    MIGRATE_JOB_FILE_SIZE.inc(fileSize);
                }
                return;
            }
            case "Persist": {
                ASYNC_PERSIST_SUCCESS.inc(count);
                ASYNC_PERSIST_FILE_COUNT.inc(count);
                for (Map jobConfig : config.getJobConfigs()) {
                    String filePath = (String)jobConfig.get("filePath");
                    long fileSize = DistributedCmdMetrics.getFileSize(filePath, fileSystem, retryPolicy);
                    ASYNC_PERSIST_FILE_SIZE.inc(fileSize);
                }
                return;
            }
        }
        LOG.warn("JobType does not belong to Load, Migrate and Persist");
    }

    public static void batchIncrementForFailStatus(BatchedJobConfig config) {
        String jobType = config.getJobType();
        long count = config.getJobConfigs().size();
        DistributedCmdMetrics.incrementForFailStatus(jobType, count);
    }

    public static void batchIncrementForCancelStatus(BatchedJobConfig config) {
        String jobType = config.getJobType();
        long count = config.getJobConfigs().size();
        DistributedCmdMetrics.incrementForCancelStatus(jobType, count);
    }

    public static void incrementForAllConfigsCompleteStatus(JobConfig config, FileSystem fileSystem, RetryPolicy retryPolicy) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForCompleteStatusWithRetry((BatchedJobConfig)config, fileSystem, retryPolicy);
        } else {
            DistributedCmdMetrics.incrementForCompleteStatusWithRetry(config, fileSystem, retryPolicy);
        }
    }

    public static void incrementForAllConfigsCancelStatus(JobConfig config) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForCancelStatus((BatchedJobConfig)config);
        } else {
            DistributedCmdMetrics.incrementForCancelStatus(config.getName(), 1L);
        }
    }

    public static void incrementForAllConfigsFailStatus(JobConfig config) {
        if (config instanceof BatchedJobConfig) {
            DistributedCmdMetrics.batchIncrementForFailStatus((BatchedJobConfig)config);
        } else {
            DistributedCmdMetrics.incrementForFailStatus(config.getName(), 1L);
        }
    }
}

