/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.meta;

import alluxio.RuntimeConstants;
import alluxio.grpc.BuildVersion;
import alluxio.wire.Address;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JobMasterInfo {
    private final Address mAddress;
    private final long mId;
    private long mLastUpdatedTimeMs;
    private long mStartTimeMs = 0L;
    private long mLosePrimacyTimeMs = 0L;
    private BuildVersion mVersion = RuntimeConstants.UNKNOWN_VERSION_INFO;

    public JobMasterInfo(long id, Address address) {
        this.mAddress = (Address)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.mId = id;
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public Address getAddress() {
        return this.mAddress;
    }

    public long getId() {
        return this.mId;
    }

    public long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    public long getLosePrimacyTimeMs() {
        return this.mLosePrimacyTimeMs;
    }

    public BuildVersion getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add("address", (Object)this.mAddress).add("lastUpdatedTimeMs", this.mLastUpdatedTimeMs).add("startTimeMs", this.mStartTimeMs).add("losePrimacyTimeMs", this.mLosePrimacyTimeMs).add("version", (Object)this.mVersion.getVersion()).add("revision", (Object)this.mVersion.getRevision()).toString();
    }

    public void setStartTimeMs(long startTimeMs) {
        this.mStartTimeMs = startTimeMs;
    }

    public void setLosePrimacyTimeMs(long losePrimacyTimeMs) {
        this.mLosePrimacyTimeMs = losePrimacyTimeMs;
    }

    public void setVersion(BuildVersion version) {
        this.mVersion = version;
    }

    public void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }
}

