/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.meta;

import alluxio.RpcUtils;
import alluxio.grpc.GetJobMasterIdPRequest;
import alluxio.grpc.GetJobMasterIdPResponse;
import alluxio.grpc.JobMasterHeartbeatPRequest;
import alluxio.grpc.JobMasterHeartbeatPResponse;
import alluxio.grpc.JobMasterMasterServiceGrpc;
import alluxio.grpc.NetAddress;
import alluxio.grpc.RegisterJobMasterPRequest;
import alluxio.grpc.RegisterJobMasterPResponse;
import alluxio.master.job.JobMaster;
import alluxio.wire.Address;
import io.grpc.stub.StreamObserver;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JobMasterMasterServiceHandler
extends JobMasterMasterServiceGrpc.JobMasterMasterServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(JobMasterMasterServiceHandler.class);
    private final JobMaster mJobMaster;

    public JobMasterMasterServiceHandler(JobMaster jobMaster) {
        LOG.info("Started to serve standby job master requests");
        this.mJobMaster = jobMaster;
    }

    public void getMasterId(GetJobMasterIdPRequest request, StreamObserver<GetJobMasterIdPResponse> responseObserver) {
        NetAddress masterAddress = request.getMasterAddress();
        RpcUtils.call((Logger)LOG, () -> GetJobMasterIdPResponse.newBuilder().setMasterId(this.mJobMaster.getMasterId(Address.fromProto((NetAddress)masterAddress))).build(), (String)"GetJobMasterId", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void registerMaster(RegisterJobMasterPRequest request, StreamObserver<RegisterJobMasterPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            this.mJobMaster.jobMasterRegister(request.getJobMasterId(), request.getOptions());
            return RegisterJobMasterPResponse.getDefaultInstance();
        }, (String)"RegisterJobMaster", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }

    public void masterHeartbeat(JobMasterHeartbeatPRequest request, StreamObserver<JobMasterHeartbeatPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> JobMasterHeartbeatPResponse.newBuilder().setCommand(this.mJobMaster.jobMasterHeartbeat(request.getMasterId(), request.getOptions())).build(), (String)"JobMasterHeartbeat", (String)"request=%s", responseObserver, (Object[])new Object[]{request});
    }
}

