/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.meta;

import alluxio.grpc.JobMasterMetaCommand;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.master.meta.RetryHandlingJobMasterMasterClient;
import alluxio.wire.Address;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JobMasterSync
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(JobMasterSync.class);
    private static final long UNINITIALIZED_MASTER_ID = -1L;
    private final Address mMasterAddress;
    private final RetryHandlingJobMasterMasterClient mMasterClient;
    private final AtomicReference<Long> mMasterId = new AtomicReference<Long>(-1L);

    public JobMasterSync(Address masterAddress, RetryHandlingJobMasterMasterClient masterClient) {
        this.mMasterAddress = masterAddress;
        this.mMasterClient = masterClient;
    }

    public void heartbeat(long timeout) {
        JobMasterMetaCommand command = null;
        try {
            if (this.mMasterId.get() == -1L) {
                this.setIdAndRegister();
            }
            command = this.mMasterClient.heartbeat(this.mMasterId.get());
            this.handleCommand(command);
        }
        catch (IOException e) {
            if (command == null) {
                LOG.error("Failed to receive primary master heartbeat command.", (Throwable)e);
            } else {
                LOG.error("Failed to execute primary master heartbeat command: {}", command, (Object)e);
            }
            this.mMasterClient.disconnect();
        }
    }

    private void handleCommand(JobMasterMetaCommand cmd) throws IOException {
        if (cmd == null) {
            return;
        }
        switch (cmd) {
            case MetaCommand_Nothing: {
                break;
            }
            case MetaCommand_Register: {
                this.setIdAndRegister();
                break;
            }
            case MetaCommand_Unknown: {
                LOG.error("Master heartbeat sends unknown command {}", (Object)cmd);
                break;
            }
            default: {
                throw new RuntimeException("Un-recognized command from primary master " + cmd);
            }
        }
    }

    private void setIdAndRegister() throws IOException {
        LOG.info("Prepare to register to primary job master");
        this.mMasterId.set(this.mMasterClient.getId(this.mMasterAddress));
        LOG.info("Received job master ID {}", (Object)this.mMasterId.get());
        this.mMasterClient.register(this.mMasterId.get());
        LOG.info("Registered with primary job master");
    }

    public void close() {
    }
}

