/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.meta;

import alluxio.AbstractJobMasterClient;
import alluxio.RuntimeConstants;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.BuildVersion;
import alluxio.grpc.GetJobMasterIdPRequest;
import alluxio.grpc.JobMasterHeartbeatPOptions;
import alluxio.grpc.JobMasterHeartbeatPRequest;
import alluxio.grpc.JobMasterMasterServiceGrpc;
import alluxio.grpc.JobMasterMetaCommand;
import alluxio.grpc.RegisterJobMasterPOptions;
import alluxio.grpc.RegisterJobMasterPRequest;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.wire.Address;
import alluxio.worker.job.JobMasterClientContext;
import com.codahale.metrics.Gauge;
import io.grpc.Channel;
import java.io.IOException;
import java.util.SortedMap;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingJobMasterMasterClient
extends AbstractJobMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHandlingJobMasterMasterClient.class);
    private JobMasterMasterServiceGrpc.JobMasterMasterServiceBlockingStub mClient = null;

    public RetryHandlingJobMasterMasterClient(JobMasterClientContext conf) {
        super((MasterClientContext)conf);
    }

    public void connect() throws AlluxioStatusException {
        super.connect();
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOB_MASTER_MASTER_SERVICE;
    }

    protected String getServiceName() {
        return "JobMasterMaster";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() {
        this.mClient = JobMasterMasterServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    public long getId(Address address) throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.getMasterId(GetJobMasterIdPRequest.newBuilder().setMasterAddress(address.toProto()).build()).getMasterId(), LOG, "GetId", "address=%s", new Object[]{address});
    }

    public JobMasterMetaCommand heartbeat(long masterId) throws IOException {
        return (JobMasterMetaCommand)this.retryRPC(() -> this.mClient.masterHeartbeat(JobMasterHeartbeatPRequest.newBuilder().setMasterId(masterId).setOptions(JobMasterHeartbeatPOptions.getDefaultInstance()).build()).getCommand(), LOG, "JobMasterHeartbeat", "masterId=%d", new Object[]{masterId});
    }

    public void register(long masterId) throws IOException {
        Gauge lastLosePrimacyGuage;
        SortedMap gauges = MetricsSystem.METRIC_REGISTRY.getGauges();
        RegisterJobMasterPOptions.Builder optionsBuilder = RegisterJobMasterPOptions.newBuilder().setVersion(BuildVersion.newBuilder().setVersion("2.9.4").setRevision(RuntimeConstants.REVISION_SHORT).build());
        Gauge startTimeGauge = (Gauge)gauges.get(MetricKey.MASTER_START_TIME.getName());
        if (startTimeGauge != null) {
            optionsBuilder.setStartTimeMs(((Long)startTimeGauge.getValue()).longValue());
        }
        if ((lastLosePrimacyGuage = (Gauge)gauges.get(MetricKey.MASTER_LAST_LOSE_PRIMACY_TIME.getName())) != null) {
            optionsBuilder.setLosePrimacyTimeMs(((Long)lastLosePrimacyGuage.getValue()).longValue());
        }
        this.retryRPC(() -> {
            this.mClient.registerMaster(RegisterJobMasterPRequest.newBuilder().setJobMasterId(masterId).setOptions(optionsBuilder).build());
            return null;
        }, LOG, "Register", "jobMasterId=%d", new Object[]{masterId});
    }
}

