/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.RestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.LogUtils;
import alluxio.wire.AlluxioJobWorkerInfo;
import alluxio.worker.JobWorkerProcess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Api(value="/job_worker", description="Job Worker Rest Service")
@Path(value="job_worker")
@Produces(value={"application/json"})
@NotThreadSafe
public final class AlluxioJobWorkerRestServiceHandler {
    public static final String SERVICE_PREFIX = "job_worker";
    public static final String LOG_LEVEL = "logLevel";
    public static final String LOG_ARGUMENT_NAME = "logName";
    public static final String LOG_ARGUMENT_LEVEL = "level";
    public static final String GET_INFO = "info";
    public static final String QUERY_RAW_CONFIGURATION = "raw_configuration";
    private final JobWorkerProcess mJobWorker;

    public AlluxioJobWorkerRestServiceHandler(@Context ServletContext context) {
        this.mJobWorker = (JobWorkerProcess)context.getAttribute("Alluxio Job Worker");
    }

    @GET
    @Path(value="info")
    @ApiOperation(value="Get general job worker service information", response=AlluxioJobWorkerInfo.class)
    public Response getInfo(@ApiParam(value="Returns raw configuration values if true, false be default") @QueryParam(value="raw_configuration") Boolean rawConfiguration) {
        return RestUtils.call(() -> {
            boolean rawConfig = false;
            if (rawConfiguration != null) {
                rawConfig = rawConfiguration;
            }
            AlluxioJobWorkerInfo result = new AlluxioJobWorkerInfo().setConfiguration(this.getConfigurationInternal(rawConfig)).setStartTimeMs(this.mJobWorker.getStartTimeMs()).setUptimeMs(this.mJobWorker.getUptimeMs()).setVersion("2.9.4");
            return result;
        }, (AlluxioConfiguration)Configuration.global());
    }

    @POST
    @Path(value="logLevel")
    public Response logLevel(@QueryParam(value="logName") String logName, @QueryParam(value="level") String level) {
        return RestUtils.call(() -> LogUtils.setLogLevel((String)logName, (String)level), (AlluxioConfiguration)Configuration.global());
    }

    private Map<String, Object> getConfigurationInternal(boolean raw) {
        Set properties = Configuration.toMap().entrySet();
        TreeMap<String, Object> configuration = new TreeMap<String, Object>();
        for (Map.Entry entry : properties) {
            String key = (String)entry.getKey();
            if (!PropertyKey.isValid((String)key)) continue;
            if (raw) {
                configuration.put(key, entry.getValue());
                continue;
            }
            configuration.put(key, Configuration.get((PropertyKey)PropertyKey.fromString((String)key)));
        }
        return configuration;
    }
}

