/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.command;

import alluxio.wire.WorkerNetAddress;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class JobWorkerHealthReporter {
    private static final Logger LOG = LoggerFactory.getLogger(JobWorkerHealthReporter.class);
    private final HardwareAbstractionLayer mHardware;
    private final WorkerNetAddress mWorkerNetAddress;

    public JobWorkerHealthReporter(WorkerNetAddress workerNetAddress) {
        this.mWorkerNetAddress = workerNetAddress;
        this.mHardware = new SystemInfo().getHardware();
    }

    public JobWorkerHealthReport getJobWorkerHealthReport() {
        return new JobWorkerHealthReport(this.mHardware, this.mWorkerNetAddress);
    }

    public static class JobWorkerHealthReport {
        private static final double CPU_LOAD_AVERAGE_HEALTHY_FACTOR = 1.0;
        private final WorkerNetAddress mWorkerNetAddress;
        private final List<Double> mCpuLoadAverage;
        private final int mLogicalProcessorCount;
        private final long mLastComputed;

        public JobWorkerHealthReport(HardwareAbstractionLayer hardware, WorkerNetAddress workerNetAddress) {
            this.mWorkerNetAddress = workerNetAddress;
            this.mCpuLoadAverage = DoubleStream.of(hardware.getProcessor().getSystemLoadAverage(3)).boxed().collect(Collectors.toList());
            this.mLogicalProcessorCount = hardware.getProcessor().getLogicalProcessorCount();
            this.mLastComputed = System.currentTimeMillis();
        }

        public List<Double> getCpuLoadAverage() {
            return this.mCpuLoadAverage;
        }

        public int getLogicalProcessorCount() {
            return this.mLogicalProcessorCount;
        }

        public long getLastComputed() {
            return this.mLastComputed;
        }

        public boolean isHealthy() {
            boolean isWorkerHealthy;
            if (this.mCpuLoadAverage.isEmpty()) {
                return true;
            }
            boolean bl = isWorkerHealthy = (double)this.mLogicalProcessorCount * 1.0 > this.mCpuLoadAverage.get(0);
            if (!isWorkerHealthy) {
                LOG.warn("Worker,{}, is not healthy.Process count:{}, Average cpu load:{}", new Object[]{this.mWorkerNetAddress.getHost(), this.mLogicalProcessorCount, this.mCpuLoadAverage});
            }
            return isWorkerHealthy;
        }
    }
}

