/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.load;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.load.LoadDefinition;
import alluxio.underfs.UfsManager;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.TieredIdentity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LoadDefinitionTest {
    private static final String TEST_URI = "/test";
    private static final WorkerNetAddress WORKER_ADDR_0 = new WorkerNetAddress().setHost("host0").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack1"))));
    private static final WorkerNetAddress WORKER_ADDR_1 = new WorkerNetAddress().setHost("host1").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack1"))));
    private static final WorkerNetAddress WORKER_ADDR_2 = new WorkerNetAddress().setHost("host2").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack2"))));
    private static final WorkerNetAddress WORKER_ADDR_3 = new WorkerNetAddress().setHost("host3").setTieredIdentity(new TieredIdentity(Collections.singletonList(new TieredIdentity.LocalityTier("rack", "rack2"))));
    private static final List<WorkerInfo> JOB_WORKERS = new ImmutableList.Builder().add((Object)new WorkerInfo().setId(0L).setAddress(WORKER_ADDR_0)).add((Object)new WorkerInfo().setId(1L).setAddress(WORKER_ADDR_1)).add((Object)new WorkerInfo().setId(2L).setAddress(WORKER_ADDR_2)).add((Object)new WorkerInfo().setId(3L).setAddress(WORKER_ADDR_3)).build();
    private static final List<BlockWorkerInfo> BLOCK_WORKERS = new ImmutableList.Builder().add((Object)new BlockWorkerInfo(WORKER_ADDR_0, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_1, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_2, 0L, 0L)).add((Object)new BlockWorkerInfo(WORKER_ADDR_3, 0L, 0L)).build();
    private JobServerContext mJobServerContext;
    private FileSystem mMockFileSystem;
    private FileSystemContext mMockFsContext;

    @Before
    public void before() throws Exception {
        this.mMockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.mMockFsContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        Mockito.when((Object)this.mMockFsContext.getCachedWorkers()).thenReturn(BLOCK_WORKERS);
        Mockito.when((Object)this.mMockFsContext.getClientContext()).thenReturn((Object)ClientContext.create((AlluxioConfiguration)Configuration.global()));
        Mockito.when((Object)this.mMockFsContext.getClusterConf()).thenReturn((Object)Configuration.global());
        Mockito.when((Object)this.mMockFsContext.getPathConf((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class))).thenReturn((Object)Configuration.global());
        this.mJobServerContext = new JobServerContext(this.mMockFileSystem, this.mMockFsContext, (UfsManager)Mockito.mock(UfsManager.class));
    }

    @Test
    public void replicationSatisfied() throws Exception {
        int numBlocks = 7;
        int replication = 3;
        this.createFileWithNoLocations(TEST_URI, numBlocks);
        LoadConfig config = new LoadConfig(TEST_URI, Integer.valueOf(replication), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(false));
        Set assignments = new LoadDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext));
        int totalBlockLoads = 0;
        for (Pair assignment : assignments) {
            totalBlockLoads += ((ArrayList)assignment.getSecond()).size();
        }
        Assert.assertEquals((long)(numBlocks * replication), (long)totalBlockLoads);
    }

    @Test
    public void skipJobWorkersWithoutLocalBlockWorkers() throws Exception {
        List<BlockWorkerInfo> blockWorkers = Arrays.asList(new BlockWorkerInfo(new WorkerNetAddress().setHost("host0"), 0L, 0L));
        Mockito.when((Object)this.mMockFsContext.getCachedWorkers()).thenReturn(blockWorkers);
        this.createFileWithNoLocations(TEST_URI, 10);
        LoadConfig config = new LoadConfig(TEST_URI, Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(false));
        Set assignments = new LoadDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext));
        Assert.assertEquals((long)10L, (long)assignments.size());
        Assert.assertEquals((long)1L, (long)((ArrayList)((Pair)assignments.iterator().next()).getSecond()).size());
    }

    @Test
    public void notEnoughWorkersForReplication() throws Exception {
        this.createFileWithNoLocations(TEST_URI, 1);
        LoadConfig config = new LoadConfig(TEST_URI, Integer.valueOf(5), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(false));
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> new LoadDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext)));
        Assert.assertTrue((boolean)exception.getMessage().contains("Failed to find enough block workers to replicate to. Needed 5 but only found 4."));
    }

    @Test
    public void notEnoughJobWorkersWithLocalBlockWorkers() throws Exception {
        List<BlockWorkerInfo> blockWorkers = Arrays.asList(new BlockWorkerInfo(new WorkerNetAddress().setHost("host0"), 0L, 0L), new BlockWorkerInfo(new WorkerNetAddress().setHost("otherhost"), 0L, 0L));
        Mockito.when((Object)this.mMockFsContext.getCachedWorkers()).thenReturn(blockWorkers);
        this.createFileWithNoLocations(TEST_URI, 1);
        LoadConfig config = new LoadConfig(TEST_URI, Integer.valueOf(2), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Boolean.valueOf(false));
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> new LoadDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext)));
        Assert.assertTrue((boolean)exception.getMessage().contains("Available workers without the block"));
        Assert.assertTrue((boolean)exception.getMessage().contains("The following workers could not be used because they have no local job workers: [otherhost]"));
    }

    @Test
    public void loadedBySpecifiedLocalityIdentity() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(0L);
        workerIds.add(1L);
        this.loadedBySpecifiedHost(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.singleton("RACK1"), Collections.EMPTY_SET, workerIds);
    }

    @Test
    public void loadedBySpecifiedLocalityIdentity2() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(2L);
        workerIds.add(3L);
        this.loadedBySpecifiedHost(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.singleton("RACK2"), Collections.EMPTY_SET, workerIds);
    }

    @Test
    public void loadedByNotExcludedLocalityIdentity() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(2L);
        workerIds.add(3L);
        HashSet<String> localityIdentities = new HashSet<String>();
        localityIdentities.add("RACK2");
        localityIdentities.add("RACK3");
        this.loadedBySpecifiedHost(Collections.EMPTY_SET, Collections.EMPTY_SET, localityIdentities, Collections.singleton("RACK3"), workerIds);
    }

    @Test
    public void loadedBySpecifiedWorker() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(2L);
        this.loadedBySpecifiedHost(Collections.singleton("HOST2"), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, workerIds);
    }

    @Test
    public void loadedBySpecifiedWorker2() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(3L);
        this.loadedBySpecifiedHost(Collections.singleton("HOST3"), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, workerIds);
    }

    @Test
    public void loadedByNotExcludedWorker() throws Exception {
        HashSet<Long> workerIds = new HashSet<Long>();
        workerIds.add(2L);
        workerIds.add(3L);
        HashSet<String> workerSet = new HashSet<String>();
        workerSet.add("HOST2");
        workerSet.add("HOST3");
        this.loadedBySpecifiedHost(workerSet, Collections.singleton("HOST3"), Collections.EMPTY_SET, Collections.EMPTY_SET, workerIds);
    }

    private void loadedBySpecifiedHost(Set<String> workerSet, Set<String> excludedWorkerSet, Set<String> localityIds, Set<String> excludedLocalityIds, Set<Long> workerIds) throws Exception {
        int numBlocks = 10;
        this.createFileWithNoLocations(TEST_URI, numBlocks);
        LoadConfig config = new LoadConfig(TEST_URI, Integer.valueOf(1), workerSet, excludedWorkerSet, localityIds, excludedLocalityIds, Boolean.valueOf(false));
        Set assignments = new LoadDefinition().selectExecutors(config, JOB_WORKERS, new SelectExecutorsContext(1L, this.mJobServerContext));
        int totalBlockLoads = 0;
        for (Pair assignment : assignments) {
            totalBlockLoads += ((ArrayList)assignment.getSecond()).size();
            Assert.assertTrue((boolean)workerIds.contains(((WorkerInfo)assignment.getFirst()).getId()));
        }
        Assert.assertEquals((long)numBlocks, (long)totalBlockLoads);
    }

    private FileInfo createFileWithNoLocations(String testFile, int numOfBlocks) throws Exception {
        FileInfo testFileInfo = new FileInfo();
        AlluxioURI uri = new AlluxioURI(testFile);
        ArrayList blockInfos = Lists.newArrayList();
        for (int i = 0; i < numOfBlocks; ++i) {
            blockInfos.add(new FileBlockInfo().setBlockInfo(new BlockInfo().setLocations((List)Lists.newArrayList())));
        }
        testFileInfo.setFolder(false).setPath(testFile).setFileBlockInfos((List)blockInfos);
        Mockito.when((Object)this.mMockFileSystem.listStatus(uri)).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(testFileInfo)}));
        Mockito.when((Object)this.mMockFileSystem.getStatus(uri)).thenReturn((Object)new URIStatus(testFileInfo));
        return testFileInfo;
    }
}

