/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.job.JobServerContext;
import alluxio.job.SelectExecutorsContext;
import alluxio.job.plan.SelectExecutorsTest;
import alluxio.job.plan.transform.CompactConfig;
import alluxio.job.plan.transform.CompactDefinition;
import alluxio.job.plan.transform.Format;
import alluxio.job.plan.transform.PartitionInfo;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CompactDefinitionSelectExecutorsTest
extends SelectExecutorsTest {
    private static final String INPUT_DIR = "/input";
    private static final String OUTPUT_DIR = "/output";
    private static final PrimitiveIterator.OfLong LONG_STREAM = new Random().longs(0x80000000L, 0x280000000L).iterator();

    @Test
    public void testExecutorsParallel() throws Exception {
        int tasksPerWorker = 10;
        int numCompactedFiles = 100;
        int totalFiles = 5000;
        PartitionInfo mockPartitionInfo = (PartitionInfo)Mockito.mock(PartitionInfo.class);
        Mockito.when((Object)mockPartitionInfo.getFormat((String)ArgumentMatchers.any())).thenReturn((Object)Format.CSV);
        CompactConfig config = new CompactConfig(mockPartitionInfo, INPUT_DIR, mockPartitionInfo, OUTPUT_DIR, Integer.valueOf(numCompactedFiles), Long.valueOf(0x80000000L));
        ArrayList<URIStatus> inputFiles = new ArrayList<URIStatus>();
        for (int i = 0; i < totalFiles; ++i) {
            inputFiles.add(this.newFile(Integer.toString(i)));
        }
        Mockito.when((Object)this.mMockFileSystem.listStatus(new AlluxioURI(INPUT_DIR))).thenReturn(inputFiles);
        Set result = new CompactDefinition().selectExecutors(config, SelectExecutorsTest.JOB_WORKERS, new SelectExecutorsContext(1L, new JobServerContext(this.mMockFileSystem, this.mMockFileSystemContext, this.mMockUfsManager)));
        Assert.assertEquals((long)(JOB_WORKERS.size() * tasksPerWorker), (long)result.size());
        int allCompactTasks = 0;
        for (Pair tasks : result) {
            allCompactTasks += ((ArrayList)tasks.getSecond()).size();
        }
        Assert.assertEquals((long)numCompactedFiles, (long)allCompactTasks);
    }

    private URIStatus newFile(String name) {
        URIStatus mockFileStatus = (URIStatus)Mockito.mock(URIStatus.class);
        Mockito.when((Object)mockFileStatus.isFolder()).thenReturn((Object)false);
        Mockito.when((Object)mockFileStatus.getName()).thenReturn((Object)name);
        Mockito.when((Object)mockFileStatus.getLength()).thenReturn((Object)LONG_STREAM.next());
        return mockFileStatus;
    }
}

