/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format;

import alluxio.AlluxioURI;
import alluxio.job.plan.transform.BaseTransformTest;
import alluxio.job.plan.transform.PartitionInfo;
import alluxio.job.plan.transform.format.TableReader;
import alluxio.job.plan.transform.format.TableRow;
import alluxio.job.plan.transform.format.TableSchema;
import alluxio.job.plan.transform.format.TableWriter;
import alluxio.job.plan.transform.format.parquet.ParquetRow;
import alluxio.job.plan.transform.format.parquet.ParquetSchema;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class ReadWriteTest
extends BaseTransformTest {
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    private PartitionInfo mPartitionInfo = new PartitionInfo("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", new HashMap(), new HashMap(), new ArrayList());

    @Test
    public void readWrite() throws Exception {
        File file = this.mTempFolder.newFile("test.parquet");
        Files.delete(file.toPath());
        int numRows = 10;
        ParquetSchema schema = new ParquetSchema(SCHEMA);
        ParquetRow row = new ParquetRow(RECORD);
        AlluxioURI uri = new AlluxioURI("file:///" + file.getPath());
        TableWriter writer = TableWriter.create((TableSchema)schema, (AlluxioURI)uri, (PartitionInfo)this.mPartitionInfo);
        Object object = null;
        try {
            for (int r = 0; r < 10; ++r) {
                writer.write((TableRow)row);
            }
        }
        catch (Throwable r) {
            object = r;
            throw r;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable r) {
                        ((Throwable)object).addSuppressed(r);
                    }
                } else {
                    writer.close();
                }
            }
        }
        ArrayList rows = Lists.newArrayList();
        uri = new AlluxioURI("file:///" + file.getPath());
        try (TableReader reader = TableReader.create((AlluxioURI)uri, (PartitionInfo)this.mPartitionInfo);){
            Assert.assertEquals((Object)schema, (Object)reader.getSchema());
            TableRow r = reader.read();
            while (r != null) {
                rows.add(r);
                r = reader.read();
            }
        }
        Assert.assertEquals((long)10L, (long)rows.size());
        for (Throwable r : rows) {
            Assert.assertEquals((Object)row, (Object)r);
            for (int i = 0; i < COLUMNS.length; ++i) {
                Assert.assertEquals((Object)VALUES[i], (Object)r.getColumn(COLUMNS[i]));
            }
        }
    }
}

