/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.transform.format.csv;

import alluxio.collections.Pair;
import alluxio.job.plan.transform.format.csv.Decimal;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class DecimalTest {
    @Test
    public void testBigDecimal() {
        Decimal decimal = new Decimal("decimal(10,1)");
        double v = decimal.toBigDecimal("10.555").doubleValue();
        Assert.assertEquals((double)10.5, (double)v, (double)1.0E-7);
    }

    @Test
    public void testParquetBytes() {
        Decimal decimal = new Decimal("decimal(10,1)");
        byte[] bytes = decimal.toParquetBytes("10.555");
        BigInteger bigInteger = new BigInteger(bytes);
        Assert.assertEquals((long)105L, (long)bigInteger.intValue());
    }

    @Test
    public void testPrecisionAndScale() {
        Pair precisionAndScale = Decimal.getPrecisionAndScale((String)"decimal(10   ,  2)  ");
        Assert.assertEquals((Object)10, (Object)precisionAndScale.getFirst());
        Assert.assertEquals((Object)2, (Object)precisionAndScale.getSecond());
    }
}

