/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.job.workflow.WorkflowConfig;
import alluxio.job.workflow.WorkflowExecution;
import alluxio.job.workflow.WorkflowExecutionRegistry;
import alluxio.job.workflow.composite.CompositeConfig;
import alluxio.job.workflow.composite.CompositeExecution;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WorkflowExecutionRegistryTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void getExecutionFactoryTest() throws Exception {
        WorkflowExecution execution = WorkflowExecutionRegistry.INSTANCE.getExecution((WorkflowConfig)new CompositeConfig(Lists.newArrayList(), Boolean.valueOf(true)));
        Assert.assertTrue((boolean)(execution instanceof CompositeExecution));
    }

    @Test
    public void getNonexistingExecution() throws Exception {
        DummyWorkflowConfig config = new DummyWorkflowConfig();
        this.mThrown.expect(JobDoesNotExistException.class);
        this.mThrown.expectMessage(ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{config.getName()}));
        WorkflowExecutionRegistry.INSTANCE.getExecution((WorkflowConfig)config);
    }

    class DummyWorkflowConfig
    implements WorkflowConfig {
        DummyWorkflowConfig() {
        }

        public String getName() {
            return "dummy";
        }

        public Collection<String> affectedPaths() {
            return Collections.EMPTY_LIST;
        }
    }
}

