/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.JobDoesNotExistException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.grpc.ListAllPOptions;
import alluxio.job.CmdConfig;
import alluxio.job.JobConfig;
import alluxio.job.JobServerContext;
import alluxio.job.SleepJobConfig;
import alluxio.job.TestPlanConfig;
import alluxio.job.cmd.load.LoadCliConfig;
import alluxio.job.plan.PlanConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.workflow.composite.CompositeConfig;
import alluxio.master.AlwaysStandbyPrimarySelector;
import alluxio.master.MasterContext;
import alluxio.master.NoopUfsManager;
import alluxio.master.PrimarySelector;
import alluxio.master.job.JobMaster;
import alluxio.master.job.command.CommandManager;
import alluxio.master.job.plan.PlanCoordinator;
import alluxio.master.journal.JournalSystem;
import alluxio.master.journal.noop.NoopJournalSystem;
import alluxio.underfs.UfsManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public final class JobMasterTest {
    private static final int TEST_JOB_MASTER_JOB_CAPACITY = 100;
    private JobMaster mJobMaster;
    private PlanCoordinator mMockPlanCoordinator;
    private MockedStatic<FileSystem.Factory> mMockStaticFactory;
    @Rule
    public TemporaryFolder mTestFolder = new TemporaryFolder();

    @Before
    public void before() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.JOB_MASTER_JOB_CAPACITY, (Object)100);
        this.mMockStaticFactory = Mockito.mockStatic(FileSystem.Factory.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)FileSystem.Factory.create((FileSystemContext)((FileSystemContext)ArgumentMatchers.any(FileSystemContext.class)))).thenReturn((Object)fs);
        this.mJobMaster = new JobMaster(new MasterContext((JournalSystem)new NoopJournalSystem(), (PrimarySelector)new AlwaysStandbyPrimarySelector(), (UfsManager)new NoopUfsManager()), (FileSystem)Mockito.mock(FileSystem.class), (FileSystemContext)Mockito.mock(FileSystemContext.class), (UfsManager)Mockito.mock(UfsManager.class));
        this.mJobMaster.start(Boolean.valueOf(true));
    }

    @After
    public void after() throws Exception {
        this.mJobMaster.stop();
        Configuration.reloadProperties();
        this.mMockStaticFactory.close();
    }

    @Test
    public void runNonExistingJobConfig() throws Exception {
        try {
            this.mJobMaster.run((JobConfig)new DummyPlanConfig());
            Assert.fail((String)"cannot run non-existing job");
        }
        catch (JobDoesNotExistException e) {
            Assert.assertEquals((Object)ExceptionMessage.JOB_DEFINITION_DOES_NOT_EXIST.getMessage(new Object[]{"dummy"}), (Object)e.getMessage());
        }
    }

    @Test
    public void runNestedNonExistingJobConfig() throws Exception {
        CompositeConfig innerJobConfig = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new DummyPlanConfig()}), Boolean.valueOf(true));
        CompositeConfig jobConfig = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{innerJobConfig}), Boolean.valueOf(true));
        long jobId = this.mJobMaster.run((JobConfig)jobConfig);
        JobInfo status = this.mJobMaster.getStatus(jobId);
        Assert.assertEquals((Object)Status.FAILED, (Object)status.getStatus());
        List children = status.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        JobInfo child = (JobInfo)children.get(0);
        Assert.assertEquals((Object)Status.FAILED, (Object)child.getStatus());
        Assert.assertEquals((long)0L, (long)child.getChildren().size());
    }

    @Test
    public void run() throws Exception {
        try (MockedStatic<PlanCoordinator> mockStaticPlanCoordinator = this.mockPlanCoordinator();){
            TestPlanConfig jobConfig = new TestPlanConfig("/test");
            ArrayList<Long> jobIdList = new ArrayList<Long>();
            for (long i = 0L; i < 100L; ++i) {
                jobIdList.add(this.mJobMaster.run((JobConfig)jobConfig));
            }
            List list = this.mJobMaster.list(ListAllPOptions.getDefaultInstance());
            Assert.assertEquals(jobIdList, (Object)list);
            Assert.assertEquals((long)100L, (long)this.mJobMaster.list(ListAllPOptions.getDefaultInstance()).size());
        }
    }

    @Test
    public void list() throws Exception {
        try (MockedStatic<PlanCoordinator> mockStaticPlanCoordinator = this.mockPlanCoordinator();){
            TestPlanConfig jobConfig = new TestPlanConfig("/test");
            ArrayList<Long> jobIdList = new ArrayList<Long>();
            for (long i = 0L; i < 100L; ++i) {
                jobIdList.add(this.mJobMaster.run((JobConfig)jobConfig));
            }
            List list = this.mJobMaster.list(ListAllPOptions.getDefaultInstance());
            Assert.assertEquals(jobIdList, (Object)list);
            Assert.assertEquals((long)100L, (long)this.mJobMaster.list(ListAllPOptions.getDefaultInstance()).size());
        }
    }

    @Test
    public void flowControl() throws Exception {
        try (MockedStatic<PlanCoordinator> mockStaticPlanCoordinator = this.mockPlanCoordinator();){
            TestPlanConfig jobConfig = new TestPlanConfig("/test");
            for (long i = 0L; i < 100L; ++i) {
                this.mJobMaster.run((JobConfig)jobConfig);
            }
            try {
                this.mJobMaster.run((JobConfig)jobConfig);
                Assert.fail((String)"should not be able to run more jobs than job master capacity");
            }
            catch (ResourceExhaustedException e) {
                Assert.assertEquals((Object)ExceptionMessage.JOB_MASTER_FULL_CAPACITY.getMessage(new Object[]{Configuration.get((PropertyKey)PropertyKey.JOB_MASTER_JOB_CAPACITY)}), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void cancelNonExistingJob() {
        try {
            this.mJobMaster.cancel(1L);
            Assert.fail((String)"cannot cancel non-existing job");
        }
        catch (JobDoesNotExistException e) {
            Assert.assertEquals((Object)ExceptionMessage.JOB_DOES_NOT_EXIST.getMessage(new Object[]{1}), (Object)e.getMessage());
        }
    }

    @Test
    public void cancel() throws Exception {
        try (MockedStatic<PlanCoordinator> mockStaticPlanCoordinator = this.mockPlanCoordinator();){
            SleepJobConfig config = new SleepJobConfig(10000L);
            long jobId = this.mJobMaster.run((JobConfig)config);
            this.mJobMaster.cancel(jobId);
            ((PlanCoordinator)Mockito.verify((Object)this.mMockPlanCoordinator)).cancel();
        }
    }

    @Test
    public void submitAndList() throws Exception {
        LoadCliConfig config = new LoadCliConfig("/path/to/load", Integer.valueOf(3), Integer.valueOf(1), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, true);
        ArrayList<Long> jobIdList = new ArrayList<Long>();
        for (long i = 0L; i < 100L; ++i) {
            long jobControlId = this.mJobMaster.submit((CmdConfig)config);
            jobIdList.add(jobControlId);
        }
        List list = this.mJobMaster.listCmds(ListAllPOptions.getDefaultInstance());
        Assert.assertEquals(jobIdList, (Object)list);
        Assert.assertEquals((long)100L, (long)this.mJobMaster.listCmds(ListAllPOptions.getDefaultInstance()).size());
    }

    private MockedStatic<PlanCoordinator> mockPlanCoordinator() {
        this.mMockPlanCoordinator = (PlanCoordinator)Mockito.mock(PlanCoordinator.class);
        MockedStatic mockedStaticPlanCoordinator = Mockito.mockStatic(PlanCoordinator.class);
        mockedStaticPlanCoordinator.when(() -> PlanCoordinator.create((CommandManager)((CommandManager)ArgumentMatchers.any(CommandManager.class)), (JobServerContext)((JobServerContext)ArgumentMatchers.any(JobServerContext.class)), (List)ArgumentMatchers.anyList(), (Long)ArgumentMatchers.anyLong(), (JobConfig)((JobConfig)ArgumentMatchers.any(JobConfig.class)), (Consumer)((Consumer)ArgumentMatchers.any(Consumer.class)))).thenReturn((Object)this.mMockPlanCoordinator);
        return mockedStaticPlanCoordinator;
    }

    private static class DummyPlanConfig
    implements PlanConfig {
        private static final long serialVersionUID = 1L;

        private DummyPlanConfig() {
        }

        public String getName() {
            return "dummy";
        }

        public Collection<String> affectedPaths() {
            return Collections.EMPTY_LIST;
        }
    }
}

