/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.plan;

import alluxio.AlluxioMockUtil;
import alluxio.exception.JobDoesNotExistException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.job.JobServerContext;
import alluxio.job.SleepJobConfig;
import alluxio.job.meta.JobIdGenerator;
import alluxio.job.plan.PlanConfig;
import alluxio.job.plan.replicate.SetReplicaConfig;
import alluxio.job.wire.Status;
import alluxio.master.job.command.CommandManager;
import alluxio.master.job.plan.PlanTracker;
import alluxio.master.job.workflow.WorkflowTracker;
import alluxio.util.FormatUtils;
import alluxio.wire.WorkerInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class PlanTrackerTest {
    private static final long CAPACITY = 25L;
    private static final long RETENTION_TIME = 0L;
    private static final long PURGE_CONUT = -1L;
    private List<WorkerInfo> mWorkers;
    private PlanTracker mTracker;
    private WorkflowTracker mMockWorkflowTracker;
    private CommandManager mCommandManager;
    private JobServerContext mMockJobServerContext;
    private JobIdGenerator mJobIdGenerator;
    @Rule
    public ExpectedException mException = ExpectedException.none();

    @Before
    public void before() {
        this.mMockWorkflowTracker = (WorkflowTracker)Mockito.mock(WorkflowTracker.class);
        this.mTracker = new PlanTracker(25L, 0L, -1L, this.mMockWorkflowTracker);
        this.mCommandManager = new CommandManager();
        this.mMockJobServerContext = (JobServerContext)Mockito.mock(JobServerContext.class);
        this.mWorkers = Lists.newArrayList((Object[])new WorkerInfo[]{new WorkerInfo()});
        this.mJobIdGenerator = new JobIdGenerator();
    }

    @Test
    public void testAddJobIncreasesCount() throws Exception {
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)this.mTracker.coordinators().size());
        this.addJob(100);
        Assert.assertEquals((String)"tracker should have one job", (long)1L, (long)this.mTracker.coordinators().size());
    }

    @Test
    public void testAddJobUpToCapacity() throws Exception {
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)this.mTracker.coordinators().size());
        this.fillJobTracker(25L);
        this.mException.expect(ResourceExhaustedException.class);
        this.addJob(100);
    }

    @Test
    public void testJobListing() throws Exception {
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)this.mTracker.coordinators().size());
        Assert.assertEquals((long)0L, (long)this.mTracker.findJobs("Sleep", (List)ImmutableList.of((Object)Status.CREATED)).size());
        this.addJob(500);
        Assert.assertEquals((long)1L, (long)this.mTracker.findJobs("Sleep", (List)ImmutableList.of((Object)Status.CREATED)).size());
        this.finishAllJobs();
        Assert.assertEquals((long)0L, (long)this.mTracker.findJobs("Sleep", (List)ImmutableList.of((Object)Status.CREATED)).size());
        Assert.assertEquals((long)1L, (long)this.mTracker.findJobs("Sleep", (List)ImmutableList.of((Object)Status.FAILED)).size());
    }

    @Test
    public void testAddAndPurge() throws Exception {
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)this.mTracker.coordinators().size());
        this.fillJobTracker(25L);
        try {
            this.addJob(100);
            Assert.fail((String)"Should have failed to add a job over capacity");
        }
        catch (ResourceExhaustedException resourceExhaustedException) {
            // empty catch block
        }
        this.finishAllJobs();
        try {
            this.addJob(100);
        }
        catch (ResourceExhaustedException e) {
            Assert.fail((String)"Should not have failed to add a job over capacity when all are finished");
        }
    }

    @Test
    public void testPurgeCount() throws Exception {
        PlanTracker tracker = new PlanTracker(10L, 0L, 5L, this.mMockWorkflowTracker);
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)tracker.coordinators().size());
        this.fillJobTracker(tracker, 10L);
        this.finishAllJobs(tracker);
        this.addJob(tracker, 100);
        Assert.assertEquals((long)6L, (long)tracker.coordinators().size());
    }

    @Test
    public void testRetentionTime() throws Exception {
        long retentionMs = FormatUtils.parseTimeSize((String)"24h");
        PlanTracker tracker = new PlanTracker(10L, retentionMs, -1L, this.mMockWorkflowTracker);
        Assert.assertEquals((String)"tracker should be empty", (long)0L, (long)tracker.coordinators().size());
        this.fillJobTracker(tracker, 10L);
        this.finishAllJobs(tracker);
        this.mException.expect(ResourceExhaustedException.class);
        this.addJob(tracker, 100);
    }

    @Test
    public void testGetCoordinator() throws Exception {
        long jobId = this.addJob(100);
        Assert.assertNull((String)"job id should not exist", (Object)this.mTracker.getCoordinator(-1L));
        Assert.assertNotNull((String)"job should exist", (Object)this.mTracker.getCoordinator(jobId));
        Assert.assertFalse((String)"job should not be finished", (boolean)this.mTracker.getCoordinator(jobId).isJobFinished());
        this.finishAllJobs();
        Assert.assertTrue((String)"job should be finished", (boolean)this.mTracker.getCoordinator(jobId).isJobFinished());
        Assert.assertEquals((String)"finished should be of size 1", (long)1L, (long)((Queue)AlluxioMockUtil.getInternalState((Object)this.mTracker, (String)"mFinished")).size());
    }

    @Test
    public void testDuplicateSetReplicaJobs() throws Exception {
        long jobId = this.mJobIdGenerator.getNewJobId();
        this.mTracker.run((PlanConfig)new SetReplicaConfig("test", 0L, 2), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, jobId);
        long jobId2 = this.mJobIdGenerator.getNewJobId();
        try {
            this.mTracker.run((PlanConfig)new SetReplicaConfig("test", 0L, 3), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, jobId2);
            Assert.fail((String)"There's SetReplica job running for path:test blockId:0, try later");
        }
        catch (JobDoesNotExistException jobDoesNotExistException) {
            // empty catch block
        }
    }

    private long addJob(int sleepTimeMs) throws Exception {
        return this.addJob(this.mTracker, sleepTimeMs);
    }

    private long addJob(PlanTracker tracker, int sleepTimeMs) throws Exception {
        long jobId = this.mJobIdGenerator.getNewJobId();
        tracker.run((PlanConfig)new SleepJobConfig((long)sleepTimeMs), this.mCommandManager, this.mMockJobServerContext, this.mWorkers, jobId);
        return jobId;
    }

    private void fillJobTracker(long nJobs) throws Exception {
        this.fillJobTracker(this.mTracker, nJobs);
    }

    private void fillJobTracker(PlanTracker tracker, long nJobs) throws Exception {
        int initial = tracker.coordinators().size();
        int i = 1;
        while ((long)i <= nJobs) {
            this.addJob(tracker, 100);
            int expectedCount = initial + i;
            Assert.assertEquals((String)String.format("tracker should have %d job(s)", expectedCount), (long)expectedCount, (long)tracker.coordinators().size());
            Assert.assertEquals((String)String.format("tracker should have %d job ids", expectedCount), (long)expectedCount, (long)tracker.list().size());
            ++i;
        }
    }

    private void finishAllJobs() {
        this.finishAllJobs(this.mTracker);
    }

    private void finishAllJobs(PlanTracker tracker) {
        tracker.coordinators().forEach(c -> c.setJobAsFailed("TestError", "failed for test"));
    }
}

