/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.job.tracker;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.OperationType;
import alluxio.job.JobConfig;
import alluxio.job.plan.load.LoadConfig;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.wire.JobSource;
import alluxio.master.job.JobMaster;
import alluxio.master.job.common.CmdInfo;
import alluxio.master.job.metrics.DistributedCmdMetrics;
import alluxio.master.job.tracker.CmdRunAttempt;
import alluxio.master.job.tracker.DistLoadCliRunner;
import alluxio.master.job.tracker.MigrateCliRunner;
import alluxio.retry.CountingRetry;
import alluxio.retry.RetryPolicy;
import alluxio.util.CommonUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public final class CliRunnerTest {
    private static final long DEFAULT_FILE_SIZE = 100L;
    private DistLoadCliRunner mLoadRunner;
    private MigrateCliRunner mMigrateRunner;
    private JobMaster mJobMaster;
    private FileSystem mFs;
    private MockedStatic<FileSystem.Factory> mMockStaticFactory;
    @Rule
    public ExpectedException mException = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystemContext fsCtx = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        this.mMockStaticFactory = Mockito.mockStatic(FileSystem.Factory.class);
        this.mMockStaticFactory.when(() -> FileSystem.Factory.create((FileSystemContext)((FileSystemContext)ArgumentMatchers.any(FileSystemContext.class)))).thenReturn((Object)this.mFs);
        AlluxioConfiguration conf = (AlluxioConfiguration)Mockito.mock(AlluxioConfiguration.class);
        Mockito.when((Object)fsCtx.getPathConf((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class))).thenReturn((Object)conf);
        Mockito.when((Object)conf.getEnum((PropertyKey)ArgumentMatchers.any(PropertyKey.class), (Class)ArgumentMatchers.any())).thenReturn((Object)WriteType.THROUGH);
        this.mJobMaster = (JobMaster)Mockito.mock(JobMaster.class);
        this.mLoadRunner = new DistLoadCliRunner(fsCtx, this.mJobMaster);
        this.mMigrateRunner = new MigrateCliRunner(fsCtx, this.mJobMaster);
    }

    @After
    public void after() {
        this.mMockStaticFactory.close();
    }

    @Test
    public void testRunDistLoad() throws Exception {
        long fileLength = 10L;
        int fileCount = 1;
        String srcString = "/src";
        AlluxioURI src = new AlluxioURI(srcString);
        URIStatus srcStatus = (URIStatus)Mockito.mock(URIStatus.class);
        ArrayList listedUri = Lists.newArrayList();
        listedUri.add(srcStatus);
        ArrayList listedPath = Lists.newArrayList();
        listedPath.add(srcString);
        int batchSize = 1;
        int replication = 1;
        Set workerSet = Collections.EMPTY_SET;
        Set excludedWorkerSet = Collections.EMPTY_SET;
        Set localityIds = Collections.EMPTY_SET;
        Set excludedLocalityIds = Collections.EMPTY_SET;
        boolean directCache = false;
        long jobControlId = 100L;
        Mockito.when((Object)this.mFs.getStatus(src)).thenReturn((Object)srcStatus);
        Mockito.when((Object)srcStatus.getLength()).thenReturn((Object)fileLength);
        Mockito.when((Object)srcStatus.isFolder()).thenReturn((Object)false);
        Mockito.when((Object)srcStatus.isCompleted()).thenReturn((Object)true);
        Mockito.when((Object)srcStatus.getPath()).thenReturn((Object)srcString);
        Mockito.when((Object)srcStatus.getInAlluxioPercentage()).thenReturn((Object)0);
        ((FileSystem)Mockito.doAnswer(ans -> {
            Consumer callback = (Consumer)ans.getArgument(2);
            callback.accept(srcStatus);
            return null;
        }).when((Object)this.mFs)).iterateStatus((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class), (ListStatusPOptions)ArgumentMatchers.any(ListStatusPOptions.class), (Consumer)ArgumentMatchers.any(Consumer.class));
        CmdInfo cmdInfo = this.mLoadRunner.runDistLoad(batchSize, src, replication, workerSet, excludedWorkerSet, localityIds, excludedLocalityIds, directCache, jobControlId);
        CmdRunAttempt actualSingleAttempt = (CmdRunAttempt)cmdInfo.getCmdRunAttempt().get(0);
        CmdRunAttempt expectedAttempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        expectedAttempt.setFileCount((long)fileCount);
        expectedAttempt.setFileSize(fileLength);
        LoadConfig config = new LoadConfig(srcString, Integer.valueOf(replication), workerSet, excludedWorkerSet, localityIds, excludedLocalityIds, Boolean.valueOf(directCache));
        expectedAttempt.setConfig((JobConfig)config);
        CmdInfo expected = new CmdInfo(jobControlId, OperationType.DIST_LOAD, JobSource.CLI, 0L, (List)listedPath);
        expected.addCmdRunAttempt(expectedAttempt);
        boolean attemptComparison = this.compareCmdRunAttempt(expectedAttempt, actualSingleAttempt);
        boolean compareCmdMetaInfo = this.compareCmdMetaInfo(cmdInfo, expected);
        Assert.assertTrue((boolean)attemptComparison);
        Assert.assertTrue((boolean)compareCmdMetaInfo);
    }

    @Test
    public void testDistLoadSetJobConfigAndFileMetrics() throws Exception {
        int fileCountLimit = 10;
        int fileNameLength = 5;
        List<URIStatus> filePath = this.createURIStatuses(fileCountLimit, fileNameLength);
        long expectedFileSize = (long)filePath.size() * 100L;
        String expectedFilePath = filePath.stream().map(URIStatus::getPath).collect(Collectors.joining(","));
        CmdRunAttempt attempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        try (MockedStatic mockedDistributedCmdMetrics = Mockito.mockStatic(DistributedCmdMetrics.class);){
            mockedDistributedCmdMetrics.when(() -> DistributedCmdMetrics.getFileSize((String)ArgumentMatchers.anyString(), (FileSystem)((FileSystem)ArgumentMatchers.any(FileSystem.class)), (RetryPolicy)((RetryPolicy)ArgumentMatchers.any(CountingRetry.class)))).thenReturn((Object)100L);
            this.mLoadRunner.setJobConfigAndFileMetrics(filePath, 1, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, false, attempt);
            Assert.assertEquals((long)attempt.getFileSize(), (long)expectedFileSize);
            Assert.assertEquals((Object)attempt.getFilePath(), (Object)expectedFilePath);
        }
    }

    @Test
    public void testRunDistCp() throws Exception {
        long fileLength = 10L;
        int fileCount = 1;
        String srcString = "/src";
        String dstString = "/dst";
        AlluxioURI src = new AlluxioURI(srcString);
        AlluxioURI dst = new AlluxioURI(dstString);
        URIStatus srcStatus = (URIStatus)Mockito.mock(URIStatus.class);
        ArrayList listedUri = Lists.newArrayList();
        listedUri.add(srcStatus);
        ArrayList listedPath = Lists.newArrayList();
        listedPath.add(srcString);
        boolean overwrite = false;
        int batchSize = 1;
        long jobControlId = 100L;
        Mockito.when((Object)this.mFs.getStatus(src)).thenReturn((Object)srcStatus);
        Mockito.when((Object)srcStatus.isFolder()).thenReturn((Object)false);
        Mockito.when((Object)this.mFs.listStatus(src)).thenReturn((Object)listedUri);
        Mockito.when((Object)srcStatus.getPath()).thenReturn((Object)srcString);
        Mockito.when((Object)srcStatus.getLength()).thenReturn((Object)fileLength);
        CmdInfo cmdInfo = this.mMigrateRunner.runDistCp(src, dst, overwrite, batchSize, jobControlId);
        CmdRunAttempt actualSingleAttempt = (CmdRunAttempt)cmdInfo.getCmdRunAttempt().get(0);
        CmdRunAttempt expectedAttempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        expectedAttempt.setFileCount((long)fileCount);
        expectedAttempt.setFileSize(fileLength);
        MigrateConfig config = new MigrateConfig(srcString, dstString, WriteType.THROUGH, overwrite);
        expectedAttempt.setConfig((JobConfig)config);
        CmdInfo expected = new CmdInfo(jobControlId, OperationType.DIST_CP, JobSource.CLI, 0L, (List)listedPath);
        expected.addCmdRunAttempt(expectedAttempt);
        boolean attemptComparison = this.compareCmdRunAttempt(expectedAttempt, actualSingleAttempt);
        boolean compareCmdMetaInfo = this.compareCmdMetaInfo(cmdInfo, expected);
        Assert.assertTrue((boolean)attemptComparison);
        Assert.assertTrue((boolean)compareCmdMetaInfo);
    }

    @Test
    public void testDistCpSetJobConfigAndFileMetrics() {
        int fileCountLimit = 10;
        int fileNameLength = 5;
        List<Pair<String, String>> filePath = this.createFilePaths(fileCountLimit, fileNameLength);
        long expectedFileSize = (long)filePath.size() * 100L;
        String expectedFilePath = filePath.stream().map(Pair::getFirst).collect(Collectors.joining(","));
        CmdRunAttempt attempt = new CmdRunAttempt((RetryPolicy)new CountingRetry(3), this.mJobMaster);
        try (MockedStatic mockedDistributedCmdMetrics = Mockito.mockStatic(DistributedCmdMetrics.class);){
            mockedDistributedCmdMetrics.when(() -> DistributedCmdMetrics.getFileSize((String)ArgumentMatchers.anyString(), (FileSystem)((FileSystem)ArgumentMatchers.any(FileSystem.class)), (RetryPolicy)((RetryPolicy)ArgumentMatchers.any(CountingRetry.class)))).thenReturn((Object)100L);
            this.mMigrateRunner.setJobConfigAndFileMetrics(filePath, false, WriteType.THROUGH, attempt);
            Assert.assertEquals((long)attempt.getFileSize(), (long)expectedFileSize);
            Assert.assertEquals((Object)attempt.getFilePath(), (Object)expectedFilePath);
        }
    }

    private List<Pair<String, String>> createFilePaths(int fileCountLimit, int nameLength) {
        ArrayList<Pair<String, String>> parts = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(1, fileCountLimit); ++i) {
            String src = CommonUtils.randomAlphaNumString((int)nameLength);
            String dst = CommonUtils.randomAlphaNumString((int)nameLength);
            parts.add((Pair<String, String>)new Pair((Object)src, (Object)dst));
        }
        return parts;
    }

    private List<URIStatus> createURIStatuses(int fileCountLimit, int nameLength) throws Exception {
        ArrayList<URIStatus> parts = new ArrayList<URIStatus>();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(1, fileCountLimit); ++i) {
            String src = CommonUtils.randomAlphaNumString((int)nameLength);
            URIStatus mock = (URIStatus)Mockito.mock(URIStatus.class);
            Mockito.when((Object)mock.getPath()).thenReturn((Object)src);
            parts.add(mock);
        }
        return parts;
    }

    private boolean compareCmdRunAttempt(CmdRunAttempt attempt, CmdRunAttempt other) {
        return Objects.equal((Object)attempt.getFileSize(), (Object)other.getFileSize()) && Objects.equal((Object)attempt.getFileCount(), (Object)other.getFileCount()) && Objects.equal((Object)attempt.getJobConfig(), (Object)other.getJobConfig());
    }

    private boolean compareCmdMetaInfo(CmdInfo cmdInfo, CmdInfo other) {
        return Objects.equal((Object)cmdInfo.getJobControlId(), (Object)other.getJobControlId()) && Objects.equal((Object)cmdInfo.getJobSource(), (Object)other.getJobSource()) && Objects.equal((Object)cmdInfo.getOperationType(), (Object)other.getOperationType());
    }
}

