/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.job.task;

import alluxio.AlluxioMockUtil;
import alluxio.grpc.RunTaskCommand;
import alluxio.job.JobConfig;
import alluxio.job.RunTaskContext;
import alluxio.job.SleepJobConfig;
import alluxio.job.plan.PlanDefinition;
import alluxio.job.plan.PlanDefinitionRegistry;
import alluxio.job.util.SerializationUtils;
import alluxio.worker.job.task.TaskExecutor;
import alluxio.worker.job.task.TaskExecutorManager;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class TaskExecutorTest {
    private TaskExecutorManager mTaskExecutorManager;
    private PlanDefinitionRegistry mRegistry;

    @Before
    public void before() {
        this.mTaskExecutorManager = (TaskExecutorManager)Mockito.mock(TaskExecutorManager.class);
        this.mRegistry = (PlanDefinitionRegistry)Mockito.mock(PlanDefinitionRegistry.class);
        AlluxioMockUtil.setInternalState(PlanDefinitionRegistry.class, (String)"INSTANCE", (Object)this.mRegistry);
    }

    @Test
    public void runCompletion() throws Exception {
        long jobId = 1L;
        long taskId = 2L;
        JobConfig jobConfig = (JobConfig)Mockito.mock(JobConfig.class);
        ArrayList taskArgs = Lists.newArrayList((Object[])new Integer[]{1});
        RunTaskContext context = (RunTaskContext)Mockito.mock(RunTaskContext.class);
        Integer taskResult = 1;
        PlanDefinition planDefinition = (PlanDefinition)Mockito.mock(PlanDefinition.class);
        Mockito.when((Object)this.mRegistry.getJobDefinition((JobConfig)Mockito.any(JobConfig.class))).thenReturn((Object)planDefinition);
        Mockito.when((Object)planDefinition.runTask((JobConfig)Mockito.any(JobConfig.class), (Serializable)Mockito.eq((Object)taskArgs), (RunTaskContext)Mockito.any(RunTaskContext.class))).thenReturn((Object)taskResult);
        RunTaskCommand command = RunTaskCommand.newBuilder().setJobConfig(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig))).setTaskArgs(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)taskArgs))).build();
        TaskExecutor executor = new TaskExecutor(jobId, taskId, command, context, this.mTaskExecutorManager);
        executor.run();
        ((PlanDefinition)Mockito.verify((Object)planDefinition)).runTask((JobConfig)Mockito.any(JobConfig.class), (Serializable)Mockito.eq((Object)taskArgs), (RunTaskContext)Mockito.eq((Object)context));
        ((TaskExecutorManager)Mockito.verify((Object)this.mTaskExecutorManager)).notifyTaskCompletion(jobId, taskId, (Serializable)taskResult);
    }

    @Test
    public void runFailure() throws Exception {
        long jobId = 1L;
        long taskId = 2L;
        SleepJobConfig jobConfig = new SleepJobConfig(10L);
        ArrayList taskArgs = Lists.newArrayList((Object[])new Integer[]{1});
        RunTaskContext context = (RunTaskContext)Mockito.mock(RunTaskContext.class);
        PlanDefinition planDefinition = (PlanDefinition)Mockito.mock(PlanDefinition.class);
        Mockito.when((Object)this.mRegistry.getJobDefinition((JobConfig)Mockito.eq((Object)jobConfig))).thenReturn((Object)planDefinition);
        Mockito.when((Object)planDefinition.runTask((JobConfig)Mockito.eq((Object)jobConfig), (Serializable)Mockito.any(Serializable.class), (RunTaskContext)Mockito.any(RunTaskContext.class))).thenThrow(new Throwable[]{new UnsupportedOperationException("failure")});
        RunTaskCommand command = RunTaskCommand.newBuilder().setJobConfig(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)jobConfig))).setTaskArgs(ByteString.copyFrom((byte[])SerializationUtils.serialize((Object)taskArgs))).build();
        TaskExecutor executor = new TaskExecutor(jobId, taskId, command, context, this.mTaskExecutorManager);
        executor.run();
        ((TaskExecutorManager)Mockito.verify((Object)this.mTaskExecutorManager)).notifyTaskFailure(Mockito.eq((long)jobId), Mockito.eq((long)taskId), (Throwable)Mockito.any());
    }
}

