/*
 * Decompiled with CFR 0.152.
 */
package alluxio.logserver;

import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlluxioLog4jSocketNode
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioLog4jSocketNode.class);
    private static final String ROOT_LOGGER_PROPERTY_KEY = "log4j.rootLogger";
    private static final String ROOT_LOGGER_APPENDER_FILE_PROPERTY_KEY = "log4j.appender.LOGSERVER_CLIENT_LOGGER.File";
    private final String mBaseLogsDir;
    private final Socket mSocket;

    public AlluxioLog4jSocketNode(String baseLogsDir, Socket socket) {
        this.mBaseLogsDir = (String)Preconditions.checkNotNull((Object)baseLogsDir, (Object)"Base logs directory cannot be null.");
        this.mSocket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"Client socket cannot be null");
    }

    @Override
    public void run() {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(this.mSocket.getInputStream()));){
            LoggerRepository hierarchy = null;
            while (!Thread.currentThread().isInterrupted()) {
                LoggingEvent event;
                try {
                    event = (LoggingEvent)objectInputStream.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class of serialized object cannot be found.", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read object from stream due to I/O error.", e);
                }
                if (hierarchy == null) {
                    hierarchy = this.configureHierarchy(event.getMDC("ProcessType").toString());
                }
                org.apache.log4j.Logger remoteLogger = hierarchy.getLogger(event.getLoggerName());
                remoteLogger.callAppenders(event);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.mSocket.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close client socket.");
            }
        }
    }

    private LoggerRepository configureHierarchy(String processType) throws IOException {
        File configFile;
        String inetAddressStr = this.mSocket.getInetAddress().getHostAddress();
        Properties properties = new Properties();
        try {
            configFile = new File(new URI(System.getProperty("log4j.configuration")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot derive a valid URI to log4j.properties file.", e);
        }
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            properties.load(inputStream);
        }
        Level level = Level.TRACE;
        Hierarchy clientHierarchy = new Hierarchy((org.apache.log4j.Logger)new RootLogger(level));
        String logDirectoryPath = PathUtils.concatPath((Object)this.mBaseLogsDir, (Object)processType.toLowerCase());
        File logDirectory = new File(logDirectoryPath);
        if (!logDirectory.exists()) {
            logDirectory.mkdir();
        }
        String logFilePath = PathUtils.concatPath((Object)logDirectoryPath, (Object)(inetAddressStr + ".log"));
        properties.setProperty(ROOT_LOGGER_PROPERTY_KEY, level.toString() + "," + "LOGSERVER_CLIENT_LOGGER");
        properties.setProperty(ROOT_LOGGER_APPENDER_FILE_PROPERTY_KEY, logFilePath);
        new PropertyConfigurator().doConfigure(properties, (LoggerRepository)clientHierarchy);
        return clientHierarchy;
    }
}

