/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.ConfigurationTestUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AbstractLocalAlluxioCluster;
import alluxio.master.LocalAlluxioMaster;
import alluxio.master.TestUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerProcess;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalAlluxioCluster
extends AbstractLocalAlluxioCluster {
    private boolean mIncludeSecondary;
    private boolean mIncludeProxy;
    private LocalAlluxioMaster mMaster;

    public LocalAlluxioCluster() {
        this(1, false, false);
    }

    public LocalAlluxioCluster(int numWorkers, boolean includeSecondary, boolean includeProxy) {
        super(numWorkers);
        this.mIncludeSecondary = includeSecondary;
        this.mIncludeProxy = includeProxy;
    }

    public LocalAlluxioCluster(int numWorkers, boolean includeSecondary) {
        this(numWorkers, includeSecondary, false);
    }

    @Override
    public FileSystem getClient() throws IOException {
        return this.mMaster.getClient();
    }

    @Override
    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.mMaster.getClient(context);
    }

    @Override
    public LocalAlluxioMaster getLocalAlluxioMaster() {
        return this.mMaster;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public String getMasterURI() {
        return this.mMaster.getUri();
    }

    public int getMasterRpcPort() {
        return this.mMaster.getRpcLocalPort();
    }

    public String getAlluxioHome() {
        return this.mWorkDirectory;
    }

    public WorkerProcess getWorkerProcess() {
        return (WorkerProcess)this.mWorkers.get(0);
    }

    public WorkerNetAddress getWorkerAddress() {
        return this.getWorkerProcess().getAddress();
    }

    @Override
    public void initConfiguration(String name) throws IOException {
        this.setAlluxioWorkDirectory(name);
        this.setHostname();
        for (Map.Entry entry : ConfigurationTestUtils.testConfigurationDefaults((AlluxioConfiguration)Configuration.global(), (String)this.mHostname, (String)this.mWorkDirectory).entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        Configuration.set((PropertyKey)PropertyKey.TEST_MODE, (Object)true);
        Configuration.set((PropertyKey)PropertyKey.JOB_WORKER_THROTTLING, (Object)false);
        Configuration.set((PropertyKey)PropertyKey.PROXY_WEB_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_RPC_PORT, (Object)0);
        Configuration.set((PropertyKey)PropertyKey.WORKER_WEB_PORT, (Object)0);
    }

    @Override
    public void startMasters() throws Exception {
        this.mMaster = LocalAlluxioMaster.create(this.mWorkDirectory, this.mIncludeSecondary);
        this.mMaster.start();
        this.waitForMasterServing();
    }

    @Override
    protected void startProxy() throws Exception {
        if (this.mIncludeProxy) {
            super.startProxy();
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        TestUtils.assertAllLocksReleased(this);
        System.clearProperty("fs.hdfs.impl.disable.cache");
    }

    @Override
    public void stopMasters() throws Exception {
        this.mMaster.stop();
    }
}

