/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.AlluxioTestDirectory;
import alluxio.Process;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.AlluxioMasterProcess;
import alluxio.master.AlluxioSecondaryMaster;
import alluxio.master.ClientPool;
import alluxio.master.TestUtils;
import alluxio.master.journal.JournalType;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LocalAlluxioMaster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlluxioMaster.class);
    private final String mHostname;
    private final String mJournalFolder;
    private final Supplier<String> mClientSupplier = this::getUri;
    private final ClientPool mClientPool = new ClientPool(this.mClientSupplier);
    private final boolean mIncludeSecondary;
    private AlluxioMasterProcess mMasterProcess;
    private Thread mMasterThread;
    private AlluxioSecondaryMaster mSecondaryMaster;
    private Thread mSecondaryMasterThread;

    private LocalAlluxioMaster(boolean includeSecondary) {
        this.mHostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)Configuration.global());
        this.mJournalFolder = Configuration.getString((PropertyKey)PropertyKey.MASTER_JOURNAL_FOLDER);
        this.mIncludeSecondary = includeSecondary;
    }

    public static LocalAlluxioMaster create(boolean includeSecondary) throws IOException {
        String workDirectory = LocalAlluxioMaster.uniquePath();
        FileUtils.deletePathRecursively((String)workDirectory);
        Configuration.set((PropertyKey)PropertyKey.WORK_DIR, (Object)workDirectory);
        return LocalAlluxioMaster.create(workDirectory, includeSecondary);
    }

    public static LocalAlluxioMaster create(String workDirectory, boolean includeSecondary) throws IOException {
        if (!Files.isDirectory(Paths.get(workDirectory, new String[0]), new LinkOption[0])) {
            Files.createDirectory(Paths.get(workDirectory, new String[0]), new FileAttribute[0]);
        }
        return new LocalAlluxioMaster(includeSecondary);
    }

    public void start() {
        this.mMasterProcess = AlluxioMasterProcess.Factory.create();
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting Alluxio master {}.", (Object)LocalAlluxioMaster.this.mMasterProcess);
                    LocalAlluxioMaster.this.mMasterProcess.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start master error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
        this.mMasterThread.setName("MasterThread-" + System.identityHashCode(this.mMasterThread));
        this.mMasterThread.start();
        if (Configuration.getEnum((PropertyKey)PropertyKey.MASTER_JOURNAL_TYPE, JournalType.class) == JournalType.EMBEDDED) {
            return;
        }
        if (!this.mIncludeSecondary) {
            return;
        }
        this.mSecondaryMaster = new AlluxioSecondaryMaster();
        Runnable runSecondaryMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting secondary master {}.", (Object)LocalAlluxioMaster.this.mSecondaryMaster);
                    LocalAlluxioMaster.this.mSecondaryMaster.start();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.error("Start secondary master error", (Throwable)e);
                    throw new RuntimeException(e + " \n Start Secondary Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mSecondaryMasterThread = new Thread(runSecondaryMaster);
        this.mSecondaryMasterThread.setName("SecondaryMasterThread-" + System.identityHashCode(this.mSecondaryMasterThread));
        this.mSecondaryMasterThread.start();
        TestUtils.waitForReady((Process)this.mSecondaryMaster);
    }

    public boolean isServing() {
        return this.mMasterProcess.isGrpcServingAsLeader();
    }

    public void stop() throws Exception {
        if (this.mSecondaryMasterThread != null) {
            this.mSecondaryMaster.stop();
            while (this.mSecondaryMasterThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mSecondaryMasterThread.getName());
                this.mSecondaryMasterThread.join(1000L);
            }
            this.mSecondaryMasterThread = null;
        }
        if (this.mMasterThread != null) {
            this.mMasterProcess.stop();
            while (this.mMasterThread.isAlive()) {
                LOG.info("Stopping thread {}.", (Object)this.mMasterThread.getName());
                this.mMasterThread.interrupt();
                this.mMasterThread.join(1000L);
            }
            this.mMasterThread = null;
        }
        this.clearClients();
        System.clearProperty("alluxio.web.resources");
        System.clearProperty("alluxio.master.min.worker.threads");
    }

    public void clearClients() throws IOException {
        this.mClientPool.close();
    }

    public InetSocketAddress getAddress() {
        return this.mMasterProcess.getRpcAddress();
    }

    public AlluxioMasterProcess getMasterProcess() {
        return this.mMasterProcess;
    }

    public int getRpcLocalPort() {
        return this.mMasterProcess.getRpcAddress().getPort();
    }

    public String getUri() {
        return "alluxio://" + this.mHostname + ":" + this.getRpcLocalPort();
    }

    public FileSystem getClient() throws IOException {
        return this.mClientPool.getClient();
    }

    public FileSystem getClient(FileSystemContext context) throws IOException {
        return this.mClientPool.getClient(context);
    }

    private static String uniquePath() throws IOException {
        return AlluxioTestDirectory.createTemporaryDirectory((String)"alluxio-master").getAbsolutePath();
    }

    public String getJournalFolder() {
        return this.mJournalFolder;
    }
}

