/*
 * Decompiled with CFR 0.152.
 */
package alluxio.multi.process;

import alluxio.conf.PropertyKey;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ExternalProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcess.class);
    private final Map<PropertyKey, Object> mConf;
    private final Class<?> mClazz;
    private final File mOutFile;
    private Process mProcess;

    public ExternalProcess(Map<PropertyKey, Object> conf, Class<?> clazz, File outfile) {
        this.mConf = conf;
        this.mClazz = clazz;
        this.mOutFile = outfile;
    }

    public synchronized void start() throws IOException {
        Preconditions.checkState((this.mProcess == null ? 1 : 0) != 0, (Object)"Process is already running");
        String java = PathUtils.concatPath((Object)System.getProperty("java.home"), (Object[])new Object[]{"bin", "java"});
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(java, "-cp", classpath));
        for (Map.Entry<PropertyKey, Object> entry : this.mConf.entrySet()) {
            args.add(String.format("-D%s=%s", entry.getKey().toString(), entry.getValue()));
        }
        args.add(this.mClazz.getCanonicalName());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectError(this.mOutFile);
        pb.redirectOutput(this.mOutFile);
        this.mProcess = pb.start();
    }

    public synchronized void stop() {
        if (this.mProcess != null) {
            try {
                this.mProcess.destroyForcibly().waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for process to close", (Throwable)e);
            }
            this.mProcess = null;
        }
    }
}

