/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.MetadataCache;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.Bits;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.FileSystemOptions;
import alluxio.util.ThreadUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CachingFileSystem
extends BaseFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileSystem.class);
    private static final int THREAD_KEEPALIVE_SECOND = 60;
    private static final int THREAD_TERMINATION_TIMEOUT_MS = 10000;
    private final MetadataCache mMetadataCache;
    private final ExecutorService mAccessTimeUpdater;

    public CachingFileSystem(FileSystemContext context, boolean cachingEnabled) {
        super(context, cachingEnabled);
        int maxSize = this.mFsContext.getClusterConf().getInt(PropertyKey.USER_METADATA_CACHE_MAX_SIZE);
        long expirationTimeMs = this.mFsContext.getClusterConf().getMs(PropertyKey.USER_METADATA_CACHE_EXPIRATION_TIME);
        this.mMetadataCache = new MetadataCache(maxSize, expirationTimeMs);
        int masterClientThreads = this.mFsContext.getClusterConf().getInt(PropertyKey.USER_FILE_MASTER_CLIENT_THREADS);
        this.mAccessTimeUpdater = new ThreadPoolExecutor(0, masterClientThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        URIStatus status = this.mMetadataCache.get(path);
        if (status == null) {
            status = super.getStatus(path, options);
            this.mMetadataCache.put(path, status);
        } else if (options.getUpdateTimestamps()) {
            this.asyncUpdateFileAccessTime(path);
        }
        return status;
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        this.checkUri(path);
        List<URIStatus> statuses = super.listStatus(path, options);
        for (URIStatus status : statuses) {
            this.mMetadataCache.put(status.getPath(), status);
        }
        return statuses;
    }

    @VisibleForTesting
    public void asyncUpdateFileAccessTime(AlluxioURI path) {
        this.mAccessTimeUpdater.submit(() -> {
            try {
                AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
                GetStatusPOptions getStatusOptions = FileSystemOptions.getStatusDefaults(conf).toBuilder().setAccessMode(Bits.READ).setUpdateTimestamps(true).build();
                super.getStatus(path, getStatusOptions);
            }
            catch (AlluxioException | IOException e) {
                LOG.error("Failed to update access time for file " + path, (Throwable)e);
            }
        });
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            ThreadUtils.shutdownAndAwaitTermination(this.mAccessTimeUpdater, 10000L);
            super.close();
        }
    }
}

