/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.resource.ResourcePool;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@ThreadSafe
public final class FileSystemMasterClientPool
extends ResourcePool<FileSystemMasterClient> {
    private final Queue<FileSystemMasterClient> mClientList = new ConcurrentLinkedQueue<FileSystemMasterClient>();
    private final MasterClientContext mMasterContext;

    public FileSystemMasterClientPool(MasterClientContext ctx) {
        super(ctx.getClusterConf().getInt(PropertyKey.USER_FILE_MASTER_CLIENT_THREADS));
        this.mMasterContext = ctx;
    }

    @Override
    public void close() throws IOException {
        FileSystemMasterClient client;
        Closer closer = Closer.create();
        while ((client = this.mClientList.poll()) != null) {
            closer.register(client);
        }
        closer.close();
    }

    @Override
    protected FileSystemMasterClient createNewResource() {
        FileSystemMasterClient client = FileSystemMasterClient.Factory.create(this.mMasterContext);
        this.mClientList.add(client);
        return client;
    }
}

