/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.cache.Cache;
import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class MetadataCache {
    private final Cache<String, URIStatus> mCache;

    public MetadataCache(int maxSize, long expirationTimeMs) {
        this.mCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(expirationTimeMs, TimeUnit.MILLISECONDS).build();
    }

    public URIStatus get(AlluxioURI path) {
        return this.mCache.getIfPresent(path.getPath());
    }

    public void put(AlluxioURI path, URIStatus status) {
        this.mCache.put(path.getPath(), status);
    }

    public void put(String path, URIStatus status) {
        this.mCache.put(path, status);
    }

    @VisibleForTesting
    public long size() {
        return this.mCache.size();
    }
}

