/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.Hash;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.collect.Maps;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioProperties {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioProperties.class);
    private final ConcurrentHashMap<PropertyKey, Optional<String>> mUserProps = new ConcurrentHashMap();
    private final ConcurrentHashMap<PropertyKey, Source> mSources = new ConcurrentHashMap();
    private Hash mHash = new Hash(() -> this.keySet().stream().filter(key -> this.get((PropertyKey)key) != null).sorted(Comparator.comparing(PropertyKey::getName)).map(key -> String.format("%s:%s:%s", key.getName(), this.get((PropertyKey)key), this.getSource((PropertyKey)key)).getBytes()));

    public AlluxioProperties() {
    }

    public AlluxioProperties(AlluxioProperties alluxioProperties) {
        this.mUserProps.putAll(alluxioProperties.mUserProps);
        this.mSources.putAll(alluxioProperties.mSources);
    }

    @Nullable
    public String get(PropertyKey key) {
        if (this.mUserProps.containsKey(key)) {
            return this.mUserProps.get(key).orElse(null);
        }
        return PropertyKey.fromString(key.toString()).getDefaultValue();
    }

    public void clear() {
        this.mUserProps.clear();
        this.mSources.clear();
    }

    public void put(PropertyKey key, String value, Source source) {
        if (!this.mUserProps.containsKey(key) || source.compareTo(this.getSource(key)) >= 0) {
            this.mUserProps.put(key, Optional.ofNullable(value));
            this.mSources.put(key, source);
            this.mHash.markOutdated();
        }
    }

    public void set(PropertyKey key, String value) {
        this.put(key, value, Source.RUNTIME);
    }

    public void merge(Map<?, ?> properties, Source source) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            PropertyKey propertyKey;
            String value;
            String key = entry.getKey().toString().trim();
            String string = value = entry.getValue() == null ? null : entry.getValue().toString().trim();
            if (PropertyKey.isValid(key)) {
                propertyKey = PropertyKey.fromString(key);
            } else {
                LOG.debug("Property {} from source {} is unrecognized", (Object)key, (Object)source);
                propertyKey = PropertyKey.getOrBuildCustom(key);
            }
            this.put(propertyKey, value, source);
        }
        this.mHash.markOutdated();
    }

    public void remove(PropertyKey key) {
        if (this.mUserProps.containsKey(key)) {
            this.mUserProps.remove(key);
            this.mSources.remove(key);
            this.mHash.markOutdated();
        }
    }

    public boolean isSet(PropertyKey key) {
        if (this.isSetByUser(key)) {
            return true;
        }
        return PropertyKey.fromString(key.toString()).getDefaultValue() != null;
    }

    public boolean isSetByUser(PropertyKey key) {
        if (this.mUserProps.containsKey(key)) {
            Optional<String> val = this.mUserProps.get(key);
            return val.isPresent();
        }
        return false;
    }

    public Set<Map.Entry<PropertyKey, String>> entrySet() {
        return this.keySet().stream().map(key -> Maps.immutableEntry(key, this.get((PropertyKey)key))).collect(Collectors.toSet());
    }

    public Set<PropertyKey> keySet() {
        HashSet<? extends PropertyKey> keySet = new HashSet<PropertyKey>(PropertyKey.defaultKeys());
        keySet.addAll(this.mUserProps.keySet());
        return Collections.unmodifiableSet(keySet);
    }

    public Set<PropertyKey> userKeySet() {
        return Collections.unmodifiableSet(this.mUserProps.keySet());
    }

    public void forEach(BiConsumer<? super PropertyKey, ? super String> action) {
        for (Map.Entry<PropertyKey, String> entry : this.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public AlluxioProperties copy() {
        return new AlluxioProperties(this);
    }

    @VisibleForTesting
    public void setSource(PropertyKey key, Source source) {
        this.mSources.put(key, source);
        this.mHash.markOutdated();
    }

    public Source getSource(PropertyKey key) {
        Source source = this.mSources.get(key);
        if (source != null) {
            return source;
        }
        return Source.DEFAULT;
    }

    public String hash() {
        return this.mHash.get();
    }
}

