/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.DefaultSupplier;
import alluxio.RuntimeConstants;
import alluxio.conf.Deprecated;
import alluxio.conf.DeprecatedKeyChecker;
import alluxio.conf.RemovedKey;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.Scope;
import alluxio.grpc.WritePType;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Strings;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.OSUtils;
import alluxio.util.io.PathUtils;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PropertyKey
implements Comparable<PropertyKey> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyKey.class);
    private static final Map<String, PropertyKey> DEFAULT_KEYS_MAP = new ConcurrentHashMap<String, PropertyKey>();
    private static final Map<String, PropertyKey> DEFAULT_ALIAS_MAP = new ConcurrentHashMap<String, PropertyKey>();
    public static final PropertyKey CONF_DIR = new Builder("alluxio.conf.dir").setDefaultValue(String.format("${%s}/conf", "alluxio.home")).setDescription("The directory containing files used to configure Alluxio.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey CONF_VALIDATION_ENABLED = new Builder("alluxio.conf.validation.enabled").setDefaultValue(true).setDescription("Whether to validate the configuration properties when initializing Alluxio clients or server process.").setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey DEBUG = new Builder("alluxio.debug").setDefaultValue(false).setDescription("Set to true to enable debug mode which has additional logging and info in the Web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey EXTENSIONS_DIR = new Builder("alluxio.extensions.dir").setDefaultValue(String.format("${%s}/extensions", "alluxio.home")).setDescription("The directory containing Alluxio extensions.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey HOME = new Builder("alluxio.home").setDefaultValue("/opt/alluxio").setDescription("Alluxio installation directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey LOGGER_TYPE = new Builder("alluxio.logger.type").setDefaultValue("Console").setDescription("The type of logger.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).build();
    public static final PropertyKey LOGS_DIR = new Builder("alluxio.logs.dir").setDefaultValue(String.format("${%s}/logs", "alluxio.work.dir")).setDescription("The path under Alluxio home directory to store log files. It has a corresponding environment variable $ALLUXIO_LOGS_DIR.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey USER_LOGS_DIR = new Builder("alluxio.user.logs.dir").setDefaultValue(String.format("${%s}/user", "alluxio.logs.dir")).setDescription("The path to store logs of Alluxio shell. To change its value, one can  set environment variable $ALLUXIO_USER_LOGS_DIR.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey METRICS_CONF_FILE = new Builder("alluxio.metrics.conf.file").setDefaultValue(String.format("${%s}/metrics.properties", "alluxio.conf.dir")).setDescription("The file path of the metrics system configuration file. By default it is `metrics.properties` in the `conf` directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey METRICS_CONTEXT_SHUTDOWN_TIMEOUT = new Builder("alluxio.metrics.context.shutdown.timeout").setDefaultValue("1sec").setDescription("Time to wait for the metrics context to shut down. The main purpose for this property is to allow tests to shut down faster.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setIsHidden(true).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_AUTH_TIMEOUT = new Builder("alluxio.network.connection.auth.timeout").setDefaultValue("30sec").setDescription("Maximum time to wait for a connection (gRPC channel) to attempt to receive an authentication response.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT = new Builder("alluxio.network.connection.health.check.timeout").setAlias("alluxio.network.connection.health.check.timeout.ms").setDefaultValue("5sec").setDescription("Allowed duration for checking health of client connections (gRPC channels) before being assigned to a client. If a connection does not become active  within configured time, it will be shut down and a new connection will be created for the client").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT = new Builder("alluxio.network.connection.server.shutdown.timeout").setDefaultValue("60sec").setDescription("Maximum time to wait for gRPC server to stop on shutdown").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey NETWORK_CONNECTION_SHUTDOWN_TIMEOUT = new Builder("alluxio.network.connection.shutdown.timeout").setDefaultValue("60sec").setDescription("Maximum time to wait for connections (gRPC channels) to stop on shutdown").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_HOST_RESOLUTION_TIMEOUT_MS = new Builder("alluxio.network.host.resolution.timeout").setAlias("alluxio.network.host.resolution.timeout.ms").setDefaultValue("5sec").setDescription("During startup of the Master and Worker processes Alluxio needs to ensure that they are listening on externally resolvable and reachable host names. To do this, Alluxio will automatically attempt to select an appropriate host name if one was not explicitly specified. This represents the maximum amount of time spent waiting to determine if a candidate host name is resolvable over the network.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey SITE_CONF_DIR = new Builder("alluxio.site.conf.dir").setDefaultSupplier(() -> String.format("${%s}/,%s/.alluxio/,/etc/alluxio/", "alluxio.conf.dir", System.getProperty("user.home")), String.format("${%s}/,${user.home}/.alluxio/,/etc/alluxio/", "alluxio.conf.dir")).setDescription(String.format("Comma-separated search path for %s.", "alluxio-site.properties")).setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey TEST_MODE = new Builder("alluxio.test.mode").setDefaultValue(false).setDescription("Flag used only during tests to allow special behavior.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setIsHidden(true).build();
    public static final PropertyKey TMP_DIRS = new Builder("alluxio.tmp.dirs").setDefaultValue("/tmp").setDescription("The path(s) to store Alluxio temporary files, use commas as delimiters. If multiple paths are specified, one will be selected at random per temporary file. Currently, only files to be uploaded to object stores are stored in these paths.").setScope(Scope.SERVER).build();
    public static final PropertyKey VERSION = new Builder("alluxio.version").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setDefaultValue("2.1.1").setDescription("Version of Alluxio. User should never modify this property.").setIgnoredSiteProperty(true).setIsHidden(true).build();
    public static final PropertyKey WEB_FILE_INFO_ENABLED = new Builder("alluxio.web.file.info.enabled").setDefaultValue(true).setDescription("Whether detailed file information are enabled for the web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_RESOURCES = new Builder("alluxio.web.resources").setDefaultValue(String.format("${%s}/webui/", "alluxio.home")).setDescription("Path to the web UI resources. User should never modify this property.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).setIsHidden(true).build();
    public static final PropertyKey WEB_THREADS = new Builder("alluxio.web.threads").setDefaultValue(1).setDescription("How many threads to serve Alluxio web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_CORS_ENABLED = new Builder("alluxio.web.cors.enabled").setDefaultValue(false).setDescription("Set to true to enable Cross-Origin Resource Sharing for RESTful APIendpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey WEB_REFRESH_INTERVAL = new Builder("alluxio.web.refresh.interval").setDefaultValue("15s").setDescription("The amount of time to await before refreshing the Web UI if it is set to auto refresh.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey WORK_DIR = new Builder("alluxio.work.dir").setDefaultValue(String.format("${%s}", "alluxio.home")).setDescription("The directory to use for Alluxio's working directory. By default, the journal, logs, and under file storage data (if using local filesystem) are written here.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey ZOOKEEPER_ADDRESS = new Builder("alluxio.zookeeper.address").setDescription("Address of ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey ZOOKEEPER_CONNECTION_TIMEOUT = new Builder("alluxio.zookeeper.connection.timeout").setDefaultValue("15s").setDescription("Connection timeout to use when connecting to Zookeeper").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey ZOOKEEPER_ELECTION_PATH = new Builder("alluxio.zookeeper.election.path").setDefaultValue("/alluxio/election").setDescription("Election directory in ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey ZOOKEEPER_ENABLED = new Builder("alluxio.zookeeper.enabled").setDefaultValue(false).setDescription("If true, setup master fault tolerant mode using ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT = new Builder("alluxio.zookeeper.leader.inquiry.retry").setDefaultValue(10).setDescription("The number of retries to inquire leader from ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey ZOOKEEPER_LEADER_PATH = new Builder("alluxio.zookeeper.leader.path").setDefaultValue("/alluxio/leader").setDescription("Leader directory in ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey ZOOKEEPER_SESSION_TIMEOUT = new Builder("alluxio.zookeeper.session.timeout").setDefaultValue("60s").setDescription("Session timeout to use when connecting to Zookeeper").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey ZOOKEEPER_AUTH_ENABLED = new Builder("alluxio.zookeeper.auth.enabled").setDefaultValue(true).setDescription("If true, enable client-side Zookeeper authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey ZOOKEEPER_LEADER_CONNECTION_ERROR_POLICY = new Builder("alluxio.zookeeper.leader.connection.error.policy").setDefaultValue("SESSION").setDescription("Connection error policy defines how errors on zookeeper connections to be treated in leader election. STANDARD policy treats every connection event as failure.SESSION policy relies on zookeeper sessions for judging failures, helping leader to retain its status, as long as its session is protected.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_ALLOW_SET_OWNER_FAILURE = new Builder("alluxio.underfs.allow.set.owner.failure").setDefaultValue(false).setDescription("Whether to allow setting owner in UFS to fail. When set to true, it is possible file or directory owners diverge between Alluxio and UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_CLEANUP_ENABLED = new Builder("alluxio.underfs.cleanup.enabled").setDefaultValue(false).setDescription("Whether or not to clean up under file storage periodically.Some ufs operations may not be completed and cleaned up successfully in normal ways and leave some intermediate data that needs periodical cleanup.If enabled, all the mount points will be cleaned up when a leader master starts or cleanup interval is reached. This should be used sparingly.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_CLEANUP_INTERVAL = new Builder("alluxio.underfs.cleanup.interval").setDefaultValue("1day").setDescription("The interval for periodically cleaning all the  mounted under file storages.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_LISTING_LENGTH = new Builder("alluxio.underfs.listing.length").setDefaultValue(1000).setDescription("The maximum number of directory entries to list in a single query to under file system. If the total number of entries is greater than the specified length, multiple queries will be issued.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_GCS_DEFAULT_MODE = new Builder("alluxio.underfs.gcs.default.mode").setDefaultValue("0700").setDescription("Mode (in octal notation) for GCS objects if mode cannot be discovered.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_DIRECTORY_SUFFIX = new Builder("alluxio.underfs.gcs.directory.suffix").setDefaultValue("/").setDescription("Directories are represented in GCS as zero-byte objects named with the specified suffix.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING = new Builder("alluxio.underfs.gcs.owner.id.to.username.mapping").setDescription("Optionally, specify a preset gcs owner id to Alluxio username static mapping in the format \"id1=user1;id2=user2\". The Google Cloud Storage IDs can be found at the console address https://console.cloud.google.com/storage/settings . Please use the \"Owners\" one.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_CONFIGURATION = new Builder("alluxio.underfs.hdfs.configuration").setDefaultValue(String.format("${%s}/core-site.xml:${%s}/hdfs-site.xml", "alluxio.conf.dir", "alluxio.conf.dir")).setDescription("Location of the HDFS configuration file to overwrite the default HDFS client configuration. Note that, these files must be availableon every node.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_IMPL = new Builder("alluxio.underfs.hdfs.impl").setDefaultValue("org.apache.hadoop.hdfs.DistributedFileSystem").setDescription("The implementation class of the HDFS as the under storage system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_PREFIXES = new Builder("alluxio.underfs.hdfs.prefixes").setDefaultValue("hdfs://,glusterfs:///,maprfs:///").setDescription("Optionally, specify which prefixes should run through the HDFS implementation of UnderFileSystem. The delimiter is any whitespace and/or ','.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_REMOTE = new Builder("alluxio.underfs.hdfs.remote").setDefaultValue(false).setDescription("Boolean indicating whether or not the under storage worker nodes are remote with respect to Alluxio worker nodes. If set to true, Alluxio will not attempt to discover locality information from the under storage because locality is impossible. This will improve performance. The default value is false.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_HEADER_LAST_MODIFIED = new Builder("alluxio.underfs.web.header.last.modified").setDefaultValue("EEE, dd MMM yyyy HH:mm:ss zzz").setDescription("Date format of last modified for a http response header.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_CONNECTION_TIMEOUT = new Builder("alluxio.underfs.web.connnection.timeout").setDefaultValue("60s").setDescription("Default timeout for a http connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_PARENT_NAMES = new Builder("alluxio.underfs.web.parent.names").setDefaultValue("Parent Directory,..,../").setDescription("The text of the http link for the parent directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_TITLES = new Builder("alluxio.underfs.web.titles").setDefaultValue("Index of ,Directory listing for ").setDescription("The title of the content for a http url.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_BREADCRUMBS_ENABLED = new Builder("alluxio.underfs.object.store.breadcrumbs.enabled").setDefaultValue(true).setDescription("Set this to false to prevent Alluxio from creating zero byte objects during read or list operations on object store UFS. Leaving this on enables more efficient listing of prefixes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE = new Builder("alluxio.underfs.object.store.multi.range.chunk.size").setDefaultValue(String.format("${%s}", "alluxio.user.block.size.bytes.default")).setDescription("Default chunk size for ranged reads from multi-range object input streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_SERVICE_THREADS = new Builder("alluxio.underfs.object.store.service.threads").setDefaultValue(20).setDescription("The number of threads in executor pool for parallel object store UFS operations, such as directory renames and deletes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY = new Builder("alluxio.underfs.object.store.mount.shared.publicly").setDefaultValue(false).setDescription("Whether or not to share object storage under storage system mounted point with all Alluxio users. Note that this configuration has no effect on HDFS nor local UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_BASE_SLEEP_MS = new Builder("alluxio.underfs.eventual.consistency.retry.base.sleep").setDefaultValue("50ms").setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the base time for the exponential backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_NUM = new Builder("alluxio.underfs.eventual.consistency.retry.max.num").setDefaultValue(20).setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the maximum number of retries.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_SLEEP_MS = new Builder("alluxio.underfs.eventual.consistency.retry.max.sleep").setDefaultValue("30sec").setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the maximum wait time in the backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_MAX = new Builder("alluxio.underfs.oss.connection.max").setDefaultValue(1024).setDescription("The maximum number of OSS connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_TIMEOUT = new Builder("alluxio.underfs.oss.connection.timeout").setAlias("alluxio.underfs.oss.connection.timeout.ms").setDefaultValue("50sec").setDescription("The timeout when connecting to OSS.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_TTL = new Builder("alluxio.underfs.oss.connection.ttl").setDefaultValue(-1).setDescription("The TTL of OSS connections in ms.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_SOCKET_TIMEOUT = new Builder("alluxio.underfs.oss.socket.timeout").setAlias("alluxio.underfs.oss.socket.timeout.ms").setDefaultValue("50sec").setDescription("The timeout of OSS socket.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_ADMIN_THREADS_MAX = new Builder("alluxio.underfs.s3.admin.threads.max").setDefaultValue(20).setDescription("The maximum number of threads to use for metadata operations when communicating with S3. These operations may be fairly concurrent and frequent but should not take much time to process.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DISABLE_DNS_BUCKETS = new Builder("alluxio.underfs.s3.disable.dns.buckets").setDefaultValue(false).setDescription("Optionally, specify to make all S3 requests path style.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_ENDPOINT = new Builder("alluxio.underfs.s3.endpoint").setDescription("Optionally, to reduce data latency or visit resources which are separated in different AWS regions, specify a regional endpoint to make aws requests. An endpoint is a URL that is the entry point for a web service. For example, s3.cn-north-1.amazonaws.com.cn is an entry point for the Amazon S3 service in beijing region.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING = new Builder("alluxio.underfs.s3.owner.id.to.username.mapping").setDescription("Optionally, specify a preset s3 canonical id to Alluxio username static mapping, in the format \"id1=user1;id2=user2\". The AWS S3 canonical ID can be found at the console address https://console.aws.amazon.com/iam/home?#security_credential . Please expand the \"Account Identifiers\" tab and refer to \"Canonical User ID\".").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_PROXY_HOST = new Builder("alluxio.underfs.s3.proxy.host").setDescription("Optionally, specify a proxy host for communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_PROXY_PORT = new Builder("alluxio.underfs.s3.proxy.port").setDescription("Optionally, specify a proxy port for communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_THREADS_MAX = new Builder("alluxio.underfs.s3.threads.max").setDefaultValue(40).setDescription("The maximum number of threads to use for communicating with S3 and the maximum number of concurrent connections to S3. Includes both threads for data upload and metadata operations. This number should be at least as large as the max admin threads plus max upload threads.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_UPLOAD_THREADS_MAX = new Builder("alluxio.underfs.s3.upload.threads.max").setDefaultValue(20).setDescription("For an Alluxio worker, this is the maximum number of threads to use for uploading data to S3 for multipart uploads. These operations can be fairly expensive, so multiple threads are encouraged. However, this also splits the bandwidth between threads, meaning the overall latency for completing an upload will be higher for more threads. For the Alluxio master, this is the maximum number of threads used for the rename (copy) operation. It is recommended that value should be greater than or equal to alluxio.underfs.object.store.service.threads").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DEFAULT_MODE = new Builder("alluxio.underfs.s3.default.mode").setAlias("alluxio.underfs.s3a.default.mode").setDefaultValue("0700").setDescription("Mode (in octal notation) for S3 objects if mode cannot be discovered.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DIRECTORY_SUFFIX = new Builder("alluxio.underfs.s3.directory.suffix").setAlias("alluxio.underfs.s3a.directory.suffix").setDefaultValue("/").setDescription("Directories are represented in S3 as zero-byte objects named with the specified suffix.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_BULK_DELETE_ENABLED = new Builder("alluxio.underfs.s3.bulk.delete.enabled").setAlias("alluxio.underfs.s3a.bulk.delete.enabled").setDefaultValue(true).setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_INHERIT_ACL = new Builder("alluxio.underfs.s3.inherit.acl").setAlias("alluxio.underfs.s3a.inherit_acl").setDefaultValue(true).setDescription("Set this property to false to disable inheriting bucket ACLs on objects. Note that the translation from bucket ACLs to Alluxio user permissions is best effort as some S3-like storage services doe not implement ACLs fully compatible with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE = new Builder("alluxio.underfs.s3.intermediate.upload.clean.age").setAlias("alluxio.underfs.s3a.intermediate.upload.clean.age").setDefaultValue("3day").setDescription("Streaming uploads may not have been completed/aborted correctly and need periodical ufs cleanup. If ufs cleanup is enabled, intermediate multipart uploads in all non-readonly S3 mount points older than this age will be cleaned. This may impact other ongoing upload operations, so a large clean age is encouraged.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_LIST_OBJECTS_V1 = new Builder("alluxio.underfs.s3.list.objects.v1").setAlias("alluxio.underfs.s3a.list.objects.v1").setDefaultValue(false).setDescription("Whether to use version 1 of GET Bucket (List Objects) API.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_REQUEST_TIMEOUT = new Builder("alluxio.underfs.s3.request.timeout").setAlias("alluxio.underfs.s3a.request.timeout.ms", "alluxio.underfs.s3a.request.timeout").setDefaultValue("1min").setDescription("The timeout for a single request to S3. Infinity if set to 0. Setting this property to a non-zero value can improve performance by avoiding the long tail of requests to S3. For very slow connections to S3, consider increasing this value or setting it to 0.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SECURE_HTTP_ENABLED = new Builder("alluxio.underfs.s3.secure.http.enabled").setAlias("alluxio.underfs.s3a.secure.http.enabled").setDefaultValue(false).setDescription("Whether or not to use HTTPS protocol when communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SERVER_SIDE_ENCRYPTION_ENABLED = new Builder("alluxio.underfs.s3.server.side.encryption.enabled").setAlias("alluxio.underfs.s3a.server.side.encryption.enabled").setDefaultValue(false).setDescription("Whether or not to encrypt data stored in S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SIGNER_ALGORITHM = new Builder("alluxio.underfs.s3.signer.algorithm").setAlias("alluxio.underfs.s3a.signer.algorithm").setDescription("The signature algorithm which should be used to sign requests to the s3 service. This is optional, and if not set, the client will automatically determine it. For interacting with an S3 endpoint which only supports v2 signatures, set this to \"S3SignerType\".").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SOCKET_TIMEOUT = new Builder("alluxio.underfs.s3.socket.timeout").setAlias("alluxio.underfs.s3a.socket.timeout.ms", "alluxio.underfs.s3a.socket.timeout").setDefaultValue("50sec").setDescription("Length of the socket timeout when communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_STREAMING_UPLOAD_ENABLED = new Builder("alluxio.underfs.s3.streaming.upload.enabled").setAlias("alluxio.underfs.s3a.streaming.upload.enabled").setDefaultValue(false).setDescription("(Experimental) If true, using streaming upload to write to S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE = new Builder("alluxio.underfs.s3.streaming.upload.partition.size").setAlias("alluxio.underfs.s3a.streaming.upload.partition.size").setDefaultValue("64MB").setDescription("Maximum allowable size of a single buffer file when using S3A streaming upload. When the buffer file reaches the partition size, it will be uploaded and the upcoming data will write to other buffer files.If the partition size is too small, S3A upload speed might be affected. ").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_KODO_REQUESTS_MAX = new Builder("alluxio.underfs.kodo.requests.max").setDefaultValue(64).setDescription("The maximum number of kodo connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_KODO_CONNECT_TIMEOUT = new Builder("alluxio.underfs.kodo.connect.timeout").setDefaultValue("50sec").setDescription("The connect timeout of kodo.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey GCS_ACCESS_KEY = new Builder("fs.gcs.accessKeyId").setDescription("The access key of GCS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey GCS_SECRET_KEY = new Builder("fs.gcs.secretAccessKey").setDescription("The secret key of GCS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey OSS_ACCESS_KEY = new Builder("fs.oss.accessKeyId").setDescription("The access key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey OSS_ENDPOINT_KEY = new Builder("fs.oss.endpoint").setDescription("The endpoint key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey OSS_SECRET_KEY = new Builder("fs.oss.accessKeySecret").setDescription("The secret key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey S3A_ACCESS_KEY = new Builder("aws.accessKeyId").setDescription("The access key of S3 bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey S3A_SECRET_KEY = new Builder("aws.secretKey").setDescription("The secret key of S3 bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_AUTH_METHOD_KEY = new Builder("fs.swift.auth.method").setDescription("Choice of authentication method: [tempauth (default), swiftauth, keystone, keystonev3].").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_AUTH_URL_KEY = new Builder("fs.swift.auth.url").setDescription("Authentication URL for REST server, e.g., http://server:8090/auth/v1.0.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_PASSWORD_KEY = new Builder("fs.swift.password").setDescription("The password used for user:tenant authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_SIMULATION = new Builder("fs.swift.simulation").setDescription("Whether to simulate a single node Swift backend for testing purposes: true or false (default).").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_TENANT_KEY = new Builder("fs.swift.tenant").setDescription("Swift user for authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_USER_KEY = new Builder("fs.swift.user").setDescription("Swift tenant for authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_REGION_KEY = new Builder("fs.swift.region").setDescription("Service region when using Keystone authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey COS_ACCESS_KEY = new Builder("fs.cos.access.key").setDescription("The access key of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey COS_APP_ID = new Builder("fs.cos.app.id").setDescription("The app id of COS bucket.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_CONNECTION_MAX = new Builder("fs.cos.connection.max").setDefaultValue(1024).setDescription("The maximum number of COS connections.").build();
    public static final PropertyKey COS_CONNECTION_TIMEOUT = new Builder("fs.cos.connection.timeout").setDefaultValue("50sec").setDescription("The timeout of connecting to COS.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_SOCKET_TIMEOUT = new Builder("fs.cos.socket.timeout").setDefaultValue("50sec").setDescription("The timeout of COS socket.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_REGION = new Builder("fs.cos.region").setDescription("The region name of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey COS_SECRET_KEY = new Builder("fs.cos.secret.key").setDescription("The secret key of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey MASTER_JOURNAL_UFS_OPTION = new Builder(Template.MASTER_JOURNAL_UFS_OPTION, new Object[0]).setDescription("The configuration to use for the journal operations.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey KODO_ACCESS_KEY = new Builder("fs.kodo.accesskey").setDescription("The access key of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey KODO_SECRET_KEY = new Builder("fs.kodo.secretkey").setDescription("The secret key of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey KODO_DOWNLOAD_HOST = new Builder("alluxio.underfs.kodo.downloadhost").setDescription("The download domain of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey KODO_ENDPOINT = new Builder("alluxio.underfs.kodo.endpoint").setDescription("The endpoint of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_ALLUXIO = new Builder(Template.MASTER_MOUNT_TABLE_ALLUXIO, "root").setDefaultValue("/").setDescription("Alluxio root mount point.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_OPTION = new Builder(Template.MASTER_MOUNT_TABLE_OPTION, "root").setDescription("Configuration for the UFS of Alluxio root mount point.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_READONLY = new Builder(Template.MASTER_MOUNT_TABLE_READONLY, "root").setDefaultValue(false).setDescription("Whether Alluxio root mount point is readonly.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_SHARED = new Builder(Template.MASTER_MOUNT_TABLE_SHARED, "root").setDefaultValue(true).setDescription("Whether Alluxio root mount point is shared.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_UFS = new Builder(Template.MASTER_MOUNT_TABLE_UFS, "root").setAlias("alluxio.underfs.address").setDescription("The storage address of the UFS at the Alluxio root mount point.").setDefaultValue(String.format("${%s}/underFSStorage", "alluxio.work.dir")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_AUDIT_LOGGING_ENABLED = new Builder("alluxio.master.audit.logging.enabled").setDefaultValue(false).setDescription("Set to true to enable file system master audit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_AUDIT_LOGGING_QUEUE_CAPACITY = new Builder("alluxio.master.audit.logging.queue.capacity").setDefaultValue(10000).setDescription("Capacity of the queue used by audit logging.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_DIRECTORY = new Builder("alluxio.master.backup.directory").setDefaultValue("/alluxio_backups").setDescription("Default directory for writing master metadata backups. This path is an absolute path of the root UFS. For example, if the root ufs directory is hdfs://host:port/alluxio/data, the default backup directory will be hdfs://host:port/alluxio_backups.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_ENTRY_BUFFER_COUNT = new Builder("alluxio.master.backup.entry.buffer.count").setDefaultValue("10000").setDescription("How many journal entries to buffer during a back-up.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BIND_HOST = new Builder("alluxio.master.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname that Alluxio master binds to.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_CLUSTER_METRICS_UPDATE_INTERVAL = new Builder("alluxio.master.cluster.metrics.update.interval").setDefaultValue("1m").setDescription("The interval for periodically updating the cluster level metrics.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).setIsHidden(true).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_ENABLED = new Builder("alluxio.master.daily.backup.enabled").setDefaultValue(false).setDescription("Whether or not to enable daily primary master metadata backup.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_FILES_RETAINED = new Builder("alluxio.master.daily.backup.files.retained").setDefaultValue(3).setDescription("The maximum number of backup files to keep in the backup directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_TIME = new Builder("alluxio.master.daily.backup.time").setDefaultValue("05:00").setDescription("Default UTC time for writing daily master metadata backups. The accepted time format is hour:minute which is based on a 24-hour clock (E.g., 05:30, 06:00, and 22:04). Backing up metadata requires a pause in master metadata changes, so please set this value to an off-peak time to avoid interfering with other users of the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_ADDRESSES = new Builder("alluxio.master.embedded.journal.addresses").setDescription(String.format("A comma-separated list of journal addresses for all masters in the cluster. The format is 'hostname1:port1,hostname2:port2,...'. When left unset, Alluxio uses ${%s}:${%s} by default", "alluxio.master.hostname", "alluxio.master.embedded.journal.port")).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_ELECTION_TIMEOUT = new Builder("alluxio.master.embedded.journal.election.timeout").setDescription("The election timeout for the embedded journal. When this period elapses without a master receiving any messages, the master will attempt to become the primary.Election timeout will be waited initially when the cluster is forming. So larger values for election timeout will cause longer start-up time. Smaller values might introduce instability to leadership.").setDefaultValue("10s").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_HEARTBEAT_INTERVAL = new Builder("alluxio.master.embedded.journal.heartbeat.interval").setDescription("The period between sending heartbeats from the embedded journal primary to followers. This should be less than half of the election timeout " + String.format("{%s}", "alluxio.master.embedded.journal.election.timeout") + ", because the election is driven by heart beats.").setDefaultValue("3s").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_APPENDER_BATCH_SIZE = new Builder("alluxio.master.embedded.journal.appender.batch.size").setDescription("Amount of data that is appended from leader to followers in a single heartbeat. Setting higher values might require increasing election timeout due to increased network delay. Setting lower values might stall knowledge propagation between the leader and followers.").setDefaultValue("512KB").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_PORT = new Builder("alluxio.master.embedded.journal.port").setDescription("The port to use for embedded journal communication with other masters.").setDefaultValue(19200).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_STORAGE_LEVEL = new Builder("alluxio.master.embedded.journal.storage.level").setDescription("The storage level for storing embedded journal logs. Use DISK for maximum durability. Use MAPPED for better performance, but some risk of losing state in case of power loss or host failure. Use MEMORY for optimal performance, but no state persistence across cluster restarts.").setDefaultValue("DISK").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_SHUTDOWN_TIMEOUT = new Builder("alluxio.master.embedded.journal.shutdown.timeout").setDefaultValue("10sec").setDescription("Maximum time to wait for embedded journal to stop on shutdown.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_WRITE_TIMEOUT = new Builder("alluxio.master.embedded.journal.write.timeout").setDefaultValue("30sec").setDescription("Maximum time to wait for a write/flush on embedded journal.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_TRIGGERED_SNAPSHOT_WAIT_TIMEOUT = new Builder("alluxio.master.embedded.journal.triggered.snapshot.wait.timeout").setDefaultValue("2hour").setDescription("Maximum time to wait for the triggered snapshot to finish.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_TRANSPORT_REQUEST_TIMEOUT_MS = new Builder("alluxio.master.embedded.journal.transport.request.timeout.ms").setDefaultValue("5sec").setDescription("Timeout for requests between embedded journal masters.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_TRANSPORT_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.master.embedded.journal.transport.max.inbound.message.size").setDefaultValue("100MB").setDescription("The max inbound message size used by copycat client/server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_ADDRESSES = new Builder("alluxio.master.rpc.addresses").setDescription("A list of comma-separated host:port RPC addresses where the client should look for masters when using multiple masters without Zookeeper. This property is not used when Zookeeper is enabled, since Zookeeper already stores the master addresses.").build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_JOURNAL_FLUSH_INTERVAL = new Builder("alluxio.master.file.access.time.journal.flush.interval").setDefaultValue("1h").setDescription("The minimum interval between files access time update journal entries get flushed asynchronously. Setting it to a non-positive value will make the the journal update synchronous. Asynchronous update reduces the performance impact of tracking access time but can lose some access time update when master stops unexpectedly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_UPDATE_PRECISION = new Builder("alluxio.master.file.access.time.update.precision").setDefaultValue("1d").setDescription("The file last access time is precise up to this value. Setting it toa non-positive value will update last access time on every file access operation.Longer precision will help reduce the performance impact of tracking access time by reduce the amount of metadata writes occur while reading the same group of files repetitively.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_UPDATER_SHUTDOWN_TIMEOUT = new Builder("alluxio.master.file.access.time.updater.shutdown.timeout").setDefaultValue("1sec").setDescription("Maximum time to wait for access updater to stop on shutdown.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FORMAT_FILE_PREFIX = new Builder("alluxio.master.format.file.prefix").setAlias("alluxio.master.format.file_prefix").setDefaultValue("_format_").setDescription("The file prefix of the file generated in the journal directory when the journal is formatted. The master will search for a file with this prefix when determining if the journal is formatted.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_STANDBY_HEARTBEAT_INTERVAL = new Builder("alluxio.master.standby.heartbeat.interval").setDefaultValue("2min").setDescription("The heartbeat interval between Alluxio primary master and standby masters.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE = new Builder("alluxio.master.metastore").setDefaultValue("HEAP").setDescription("The type of metastore to use, either HEAP or ROCKS. The heap metastore keeps all metadata on-heap, while the rocks metastore stores some metadata on heap and some metadata on disk. The rocks metastore has the advantage of being able to support a large namespace (1 billion plus files) without needing a massive heap size.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_DIR = new Builder("alluxio.master.metastore.dir").setDefaultValue(String.format("${%s}/metastore", "alluxio.work.dir")).setDescription("The metastore work directory. Only some metastores need disk.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_EVICT_BATCH_SIZE = new Builder("alluxio.master.metastore.inode.cache.evict.batch.size").setDefaultValue("1000").setDescription("The batch size for evicting entries from the inode cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_HIGH_WATER_MARK_RATIO = new Builder("alluxio.master.metastore.inode.cache.high.water.mark.ratio").setDefaultValue("0.85").setDescription("The high water mark for the inode cache, as a ratio from high water mark to total cache size. If this is 0.85 and the max size is 10 million, the high water mark value is 8.5 million. When the cache reaches the high water mark, the eviction process will evict down to the low water mark.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_LOW_WATER_MARK_RATIO = new Builder("alluxio.master.metastore.inode.cache.low.water.mark.ratio").setDefaultValue("0.8").setDescription("The low water mark for the inode cache, as a ratio from low water mark to total cache size. If this is 0.8 and the max size is 10 million, the low water mark value is 8 million. When the cache reaches the high water mark, the eviction process will evict down to the low water mark.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_MAX_SIZE = new Builder("alluxio.master.metastore.inode.cache.max.size").setDefaultValue("10000000").setDescription("The number of inodes to cache on-heap. This only applies to off-heap metastores, e.g. ROCKS. Set this to 0 to disable the on-heap inode cache").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_ITERATION_CRAWLER_COUNT = new Builder("alluxio.master.metastore.inode.iteration.crawler.count").setDefaultSupplier(() -> Runtime.getRuntime().availableProcessors(), "Use {CPU core count} for enumeration").setDescription("The number of threads used during inode tree enumeration.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_ENUMERATOR_BUFFER_COUNT = new Builder("alluxio.master.metastore.inode.enumerator.buffer.count").setDefaultValue("10000").setDescription("The number of entries to buffer during read-ahead enumeration.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_INHERIT_OWNER_AND_GROUP = new Builder("alluxio.master.metastore.inode.inherit.owner.and.group").setDefaultValue("true").setDescription("Whether to inherit the owner/group from the parent when creating a new inode path if empty").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_SERVICE_THREADS = new Builder("alluxio.master.metrics.service.threads").setDefaultValue(5).setDescription("The number of threads in executor pool for parallel processing metrics submitted by workers or clients").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_TIME_SERIES_INTERVAL = new Builder("alluxio.master.metrics.time.series.interval").setDefaultValue("5min").setDescription("Interval for which the master records metrics information. This affects the granularity of the metrics graphed in the UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL = new Builder("alluxio.master.lost.worker.file.detection.interval").setAlias("alluxio.master.worker.heartbeat.interval").setDefaultValue("10sec").setDescription("The interval between Alluxio master detections to find lost workers and files based on updates from Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_HEARTBEAT_TIMEOUT = new Builder("alluxio.master.heartbeat.timeout").setDefaultValue("10min").setDescription("Timeout between leader master and standby master indicating a lost master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_HOSTNAME = new Builder("alluxio.master.hostname").setDescription("The hostname of Alluxio master.").setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_LOCK_POOL_INITSIZE = new Builder("alluxio.master.lock.pool.initsize").setDefaultValue(1000).setDescription("Initial size of the lock pool for master inodes.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_LOW_WATERMARK = new Builder("alluxio.master.lock.pool.low.watermark").setDefaultValue(500000).setDescription("Low watermark of lock pool size. When the size grows over the high watermark, a background thread will try to evict unused locks until the size reaches the low watermark.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_HIGH_WATERMARK = new Builder("alluxio.master.lock.pool.high.watermark").setDefaultValue(1000000).setDescription("High watermark of lock pool size. When the size grows over the high watermark, a background thread starts evicting unused locks from the pool.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_CONCURRENCY_LEVEL = new Builder("alluxio.master.lock.pool.concurrency.level").setDefaultValue(100).setDescription("Maximum concurrency level for the lock pool").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_BATCH_TIME_MS = new Builder("alluxio.master.journal.flush.batch.time").setAlias("alluxio.master.journal.flush.batch.time.ms").setDefaultValue("5ms").setDescription("Time to wait for batching journal writes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_TIMEOUT_MS = new Builder("alluxio.master.journal.flush.timeout").setAlias("alluxio.master.journal.flush.timeout.ms").setDefaultValue("5min").setDescription("The amount of time to keep retrying journal writes before giving up and shutting down the master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_RETRY_INTERVAL = new Builder("alluxio.master.journal.retry.interval").setDefaultValue("1sec").setDescription("The amount of time to sleep between retrying journal flushes").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FOLDER = new Builder("alluxio.master.journal.folder").setDefaultValue(String.format("${%s}/journal", "alluxio.work.dir")).setDescription("The path to store master journal logs. When using the UFS journal this could be a URI like hdfs://namenode:port/alluxio/journal. When using the embedded journal this must be a local path").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_INIT_FROM_BACKUP = new Builder("alluxio.master.journal.init.from.backup").setDescription("A uri for a backup to initialize the journal from. When the master becomes primary, if it sees that its journal is freshly formatted, it will restore its state from the backup. When running multiple masters, this property must be configured on all masters since it isn't known during startup which master will become the first primary.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TOLERATE_CORRUPTION = new Builder("alluxio.master.journal.tolerate.corruption").setDefaultValue(false).setDescription("Whether to tolerate master state corruption when standby master replaying journal. If enabled, errors from applying journal to master metadata will only be logged instead of forcing master to exit. This property should be used sparingly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setIsHidden(true).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TYPE = new Builder("alluxio.master.journal.type").setDefaultValue("EMBEDDED").setDescription("The type of journal to use. Valid options are UFS (store journal in UFS), EMBEDDED (use a journal embedded in the masters), and NOOP (do not use a journal)").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_LOG_SIZE_BYTES_MAX = new Builder("alluxio.master.journal.log.size.bytes.max").setDefaultValue("10MB").setDescription("If a log file is bigger than this value, it will rotate to next file.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS = new Builder("alluxio.master.journal.tailer.shutdown.quiet.wait.time").setAlias("alluxio.master.journal.tailer.shutdown.quiet.wait.time.ms").setDefaultValue("5sec").setDescription("Before the standby master shuts down its tailer thread, there should be no update to the leader master's journal in this specified time period.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TAILER_SLEEP_TIME_MS = new Builder("alluxio.master.journal.tailer.sleep.time").setAlias("alluxio.master.journal.tailer.sleep.time.ms").setDefaultValue("1sec").setDescription("Time for the standby master to sleep for when it cannot find anything new in leader master's journal.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES = new Builder("alluxio.master.journal.checkpoint.period.entries").setDefaultValue(2000000).setDescription("The number of journal entries to write before creating a new journal checkpoint.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_GC_PERIOD_MS = new Builder("alluxio.master.journal.gc.period").setAlias("alluxio.master.journal.gc.period.ms").setDefaultValue("2min").setDescription("Frequency with which to scan for and delete stale journal checkpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_GC_THRESHOLD_MS = new Builder("alluxio.master.journal.gc.threshold").setAlias("alluxio.master.journal.gc.threshold.ms").setDefaultValue("5min").setDescription("Minimum age for garbage collecting checkpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TEMPORARY_FILE_GC_THRESHOLD_MS = new Builder("alluxio.master.journal.temporary.file.gc.threshold").setAlias("alluxio.master.journal.temporary.file.gc.threshold.ms").setDescription("Minimum age for garbage collecting temporary checkpoint files.").setDefaultValue("30min").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_KEYTAB_KEY_FILE = new Builder("alluxio.master.keytab.file").setDescription("Kerberos keytab file for Alluxio master.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOG_CONFIG_REPORT_HEARTBEAT_INTERVAL = new Builder("alluxio.master.log.config.report.heartbeat.interval").setDefaultValue("1h").setDescription("The interval for periodically logging the configuration check report.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_REPAIR = new Builder("alluxio.master.periodic.block.integrity.check.repair").setDefaultValue(false).setDescription("Whether the system should delete orphaned blocks found during the periodic integrity check. This is an experimental feature.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_INTERVAL = new Builder("alluxio.master.periodic.block.integrity.check.interval").setDefaultValue("1hr").setDescription("The period for the block integrity check, disabled if <= 0.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_CHECKER_INTERVAL_MS = new Builder("alluxio.master.persistence.checker.interval").setDefaultValue("1s").setDescription("How often the master checks persistence status for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_INITIAL_INTERVAL_MS = new Builder("alluxio.master.persistence.initial.interval").setDefaultValue("1s").setDescription("How often the  master persistence checker checks persistence status for files written using ASYNC_THROUGH").build();
    public static final PropertyKey MASTER_PERSISTENCE_MAX_INTERVAL_MS = new Builder("alluxio.master.persistence.max.interval").setDefaultValue("1hr").setDescription("Max wait interval for master persistence checker persistence status for files written using ASYNC_THROUGH").build();
    public static final PropertyKey MASTER_PERSISTENCE_MAX_TOTAL_WAIT_TIME_MS = new Builder("alluxio.master.persistence.max.total.wait.time").setDefaultValue("1day").setDescription("Total wait time for master persistence checker persistence status for files written using ASYNC_THROUGH").build();
    public static final PropertyKey MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS = new Builder("alluxio.master.persistence.scheduler.interval").setDefaultValue("1s").setDescription("How often the master schedules persistence jobs for files written using ASYNC_THROUGH").build();
    public static final PropertyKey MASTER_PERSISTENCE_BLACKLIST = new Builder("alluxio.master.persistence.blacklist").setDescription("Patterns to blacklist persist, comma separated, string match, no regex. This affects any async persist call (including ASYNC_THROUGH writes and CLI persist) but does not affect CACHE_THROUGH writes. Users may want to specify temporary files in the blacklist to avoid unnecessary I/O and errors. Some examples are `.staging` and `.tmp`.").setScope(Scope.MASTER).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_REPLICATION_CHECK_INTERVAL_MS = new Builder("alluxio.master.replication.check.interval").setDefaultValue("1min").setDescription("How often the master runs background process to check replication level for files").build();
    public static final PropertyKey MASTER_PRINCIPAL = new Builder("alluxio.master.principal").setDescription("Kerberos principal for Alluxio master.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_PORT = new Builder("alluxio.master.rpc.port").setAlias("alluxio.master.port").setDefaultValue(19998).setDescription("The port for Alluxio master's RPC service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_SERVING_THREAD_TIMEOUT = new Builder("alluxio.master.serving.thread.timeout").setDefaultValue("5m").setDescription("When stepping down from being the primary, the master will wait this long for the gRPC serving thread to stop before giving up and shutting down the server").setIsHidden(true).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SKIP_ROOT_ACL_CHECK = new Builder("alluxio.master.skip.root.acl.check").setDefaultValue(false).setDescription("Skip root directory ACL check when restarting either from journal or backup. This is to allow users to restore a backup from a different cluster onto their current one without having to recreate the different clusters owner user.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).setIsHidden(true).setIgnoredSiteProperty(true).build();
    public static final PropertyKey MASTER_STARTUP_BLOCK_INTEGRITY_CHECK_ENABLED = new Builder("alluxio.master.startup.block.integrity.check.enabled").setDefaultValue(true).setDescription("Whether the system should be checked on startup for orphaned blocks (blocks having no corresponding files but still taking system resource due to various system failures). Orphaned blocks will be deleted during master startup if this property is true. This property is available since 1.7.1").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS = new Builder("alluxio.master.tieredstore.global.level0.alias").setDefaultValue("MEM").setDescription("The name of the highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS = new Builder("alluxio.master.tieredstore.global.level1.alias").setDefaultValue("SSD").setDescription("The name of the second highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS = new Builder("alluxio.master.tieredstore.global.level2.alias").setDefaultValue("HDD").setDescription("The name of the third highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVELS = new Builder("alluxio.master.tieredstore.global.levels").setDefaultValue(3).setDescription("The total number of storage tiers in the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_MEDIUMTYPE = new Builder("alluxio.master.tieredstore.global.mediumtype").setDefaultValue("MEM, SSD, HDD").setDescription("The list of medium types we support in the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TTL_CHECKER_INTERVAL_MS = new Builder("alluxio.master.ttl.checker.interval").setAlias("alluxio.master.ttl.checker.interval.ms").setDefaultValue("1hour").setDescription("How often to periodically check and delete the files with expired ttl value.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_INTERVAL = new Builder("alluxio.master.ufs.active.sync.interval").setDefaultValue("30sec").setDescription("Time interval to periodically actively sync UFS").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_MAX_AGE = new Builder("alluxio.master.ufs.active.sync.max.age").setDefaultValue("10").setDescription("The maximum number of intervals we will wait to find a quiet period before we have to sync the directories").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_INITIAL_SYNC_ENABLED = new Builder("alluxio.master.ufs.active.sync.initial.sync.enabled").setDefaultValue("true").setDescription("Whether to perform an initial sync when we add a sync point").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).setIsHidden(true).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_MAX_ACTIVITIES = new Builder("alluxio.master.ufs.active.sync.max.activities").setDefaultValue("10").setDescription("Max number of changes in a directory to be considered for active syncing").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_THREAD_POOL_SIZE = new Builder("alluxio.master.ufs.active.sync.thread.pool.size").setDefaultValue("3").setDescription("Max number of threads used to perform active sync").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_POLL_TIMEOUT = new Builder("alluxio.master.ufs.active.sync.poll.timeout").setDefaultValue("10sec").setDescription("Max time to wait before timing out a polling operation").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_EVENT_RATE_INTERVAL = new Builder("alluxio.master.ufs.active.sync.event.rate.interval").setDefaultValue("60sec").setDescription("The time interval we use to estimate incoming event rate").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_BLOCK_LOCATION_CACHE_CAPACITY = new Builder("alluxio.master.ufs.block.location.cache.capacity").setDefaultValue(1000000).setDescription("The capacity of the UFS block locations cache. This cache caches UFS block locations for files that are persisted but not in Alluxio space, so that listing status of these files do not need to repeatedly ask UFS for their block locations. If this is set to 0, the cache will be disabled.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_MANAGED_BLOCKING_ENABLED = new Builder("alluxio.master.ufs.managed.blocking.enabled").setDescription("Whether to run UFS operations with managed blocking. This will provide RPC layer a hint that UFS is possible slow.The default is true for object stores and false for the rest. unless set explicitly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).setIsHidden(true).build();
    public static final PropertyKey MASTER_UFS_PATH_CACHE_CAPACITY = new Builder("alluxio.master.ufs.path.cache.capacity").setDefaultValue(100000).setDescription("The capacity of the UFS path cache. This cache is used to approximate the `ONCE` metadata load behavior (see `alluxio.user.file.metadata.load.type`). Larger caches will consume more memory, but will better approximate the `ONCE` behavior.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_PATH_CACHE_THREADS = new Builder("alluxio.master.ufs.path.cache.threads").setDefaultValue(64).setDescription("The maximum size of the thread pool for asynchronously processing paths for the UFS path cache. Greater number of threads will decrease the amount of staleness in the async cache, but may impact performance. If this is set to 0, the cache will be disabled, and `alluxio.user.file.metadata.load.type=ONCE` will behave like `ALWAYS`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UPDATE_CHECK_ENABLED = new Builder("alluxio.master.update.check.enabled").setDefaultValue(true).setDescription("Whether to check for update availability.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED = new Builder("alluxio.master.unsafe.direct.persist.object.enabled").setDefaultValue(true).setDescription("When set to false, writing files using ASYNC_THROUGH or persist CLI with object stores as the UFS will first create temporary objects suffixed by \".alluxio.TIMESTAMP.tmp\" in the object store before committed to the final UFS path. When set to true, files will be put to the destination path directly in the object store without staging with a temp suffix. Enabling this optimization by directly persisting files can significantly improve the efficiency writing to object store by making less data copy as rename in object store can be slow, but leaving a short vulnerability window for undefined behavior if a file is written using ASYNC_THROUGH but renamed or removed before the async persist operation completes, while this same file path was reused for other new files in Alluxio.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WEB_BIND_HOST = new Builder("alluxio.master.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio master web UI binds to.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WEB_HOSTNAME = new Builder("alluxio.master.web.hostname").setDescription("The hostname of Alluxio Master web UI.").setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_WEB_PORT = new Builder("alluxio.master.web.port").setDefaultValue(19999).setDescription("The port Alluxio web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WHITELIST = new Builder("alluxio.master.whitelist").setDefaultValue("/").setDescription("A comma-separated list of prefixes of the paths which are cacheable, separated by semi-colons. Alluxio will try to cache the cacheable file when it is read for the first time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WORKER_CONNECT_WAIT_TIME = new Builder("alluxio.master.worker.connect.wait.time").setDefaultValue("5sec").setDescription("Alluxio master will wait a period of time after start up for all workers to register, before it starts accepting client requests. This property determines the wait time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WORKER_TIMEOUT_MS = new Builder("alluxio.master.worker.timeout").setAlias("alluxio.master.worker.timeout.ms").setDefaultValue("5min").setDescription("Timeout between master and worker indicating a lost worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_PARALLELISM = new Builder("alluxio.master.rpc.executor.parallelism").setDefaultSupplier(() -> 2 * Runtime.getRuntime().availableProcessors(), "2 * {CPU core count}").setDescription("The parallelism level of master RPC executor service .").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_MIN_RUNNABLE = new Builder("alluxio.master.rpc.executor.min.runnable").setDefaultValue(1).setDescription("the minimum allowed number of core threads not blocked. To ensure progress, when too few unblocked threads exist and unexecuted tasks may exist, new threads are constructed up to the value of alluxio.master.rpc.executor.max.pool.size. A value of 1 ensures liveness. A larger value might improve throughput but might also increase overhead.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_CORE_POOL_SIZE = new Builder("alluxio.master.rpc.executor.core.pool.size").setDefaultValue(0).setDescription("the number of threads to keep in thread pool of master RPC executor service. By default it is same as the parallelism level, but may be set to a larger value to reduce dynamic overhead if tasks regularly block. A smaller value (for example 0) is equivalent to the default.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_MAX_POOL_SIZE = new Builder("alluxio.master.rpc.executor.max.pool.size").setDefaultValue(500).setDescription("the maximum number of threads allowed for master RPC executor service. When the maximum is reached, attempts to replace blocked threads fail.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_KEEPALIVE = new Builder("alluxio.master.rpc.executor.keepalive").setDefaultValue("60sec").setDescription("the keep alive time of a thread in master RPC executor servicelast used before this thread is terminated (and replaced if necessary).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey SECONDARY_MASTER_METASTORE_DIR = new Builder("alluxio.secondary.master.metastore.dir").setDefaultValue(String.format("${%s}/secondary-metastore", "alluxio.work.dir")).setDescription("The secondary master metastore work directory. Only some metastores need disk.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey MASTER_FILE_SYSTEM_LISTSTATUS_RESULTS_PER_MESSAGE = new Builder("alluxio.master.filesystem.liststatus.result.message.length").setDefaultValue(10000).setDescription("Count of items on each list-status response message.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey WORKER_ALLOCATOR_CLASS = new Builder("alluxio.worker.allocator.class").setDefaultValue("alluxio.worker.block.allocator.MaxFreeAllocator").setDescription("The strategy that a worker uses to allocate space among storage directories in certain storage layer. Valid options include: `alluxio.worker.block.allocator.MaxFreeAllocator`, `alluxio.worker.block.allocator.GreedyAllocator`, `alluxio.worker.block.allocator.RoundRobinAllocator`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BIND_HOST = new Builder("alluxio.worker.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio's worker node binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_HEARTBEAT_INTERVAL_MS = new Builder("alluxio.worker.block.heartbeat.interval").setAlias("alluxio.worker.block.heartbeat.interval.ms").setDefaultValue("1sec").setDescription("The interval between block workers' heartbeats to update block status, storage health and other workers' information to Alluxio Master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS = new Builder("alluxio.worker.block.heartbeat.timeout").setAlias("alluxio.worker.block.heartbeat.timeout.ms").setDefaultValue(String.format("${%s}", "alluxio.worker.master.connect.retry.timeout")).setDescription("The timeout value of block workers' heartbeats. If the worker can't connect to master before this interval expires, the worker will exit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_FOLDER = new Builder("alluxio.worker.data.folder").setDefaultValue("/alluxioworker/").setDescription("A relative path within each storage directory used as the data folder for Alluxio worker to put data for tiered store.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_FOLDER_PERMISSIONS = new Builder("alluxio.worker.data.folder.permissions").setDefaultValue("rwxrwxrwx").setDescription("The permission set for the worker data folder. If short circuit is used this folder should be accessible by all users (rwxrwxrwx).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_SERVER_CLASS = new Builder("alluxio.worker.data.server.class").setDefaultValue("alluxio.worker.grpc.GrpcDataServer").setDescription("Selects the networking stack to run the worker with. Valid options are: `alluxio.worker.grpc.GrpcDataServer`.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_SERVER_DOMAIN_SOCKET_ADDRESS = new Builder("alluxio.worker.data.server.domain.socket.address").setDescription("The path to the domain socket. Short-circuit reads make use of a UNIX domain socket when this is set (non-empty). This is a special path in the file system that allows the client and the AlluxioWorker to communicate. You will need to set a path to this socket. The AlluxioWorker needs to be able to create the path. If alluxio.worker.data.server.domain.socket.as.uuid is set, the path should be the home directory for the domain socket. The full path for the domain socket with be {path}/{uuid}.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID = new Builder("alluxio.worker.data.server.domain.socket.as.uuid").setDefaultValue("false").setDescription("If true, the property alluxio.worker.data.server.domain.socket.addressis the path to the home directory for the domain socket and a unique identifier is used as the domain socket name. If false, the property is the absolute path to the UNIX domain socket.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey WORKER_DATA_TMP_FOLDER = new Builder("alluxio.worker.data.folder.tmp").setDefaultValue(".tmp_blocks").setDescription("A relative path in alluxio.worker.data.folder used to store the temporary data for uncommitted files.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_TMP_SUBDIR_MAX = new Builder("alluxio.worker.data.tmp.subdir.max").setDefaultValue(1024).setDescription("The maximum number of sub-directories allowed to be created in ${alluxio.worker.data.tmp.folder}.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_EVICTOR_CLASS = new Builder("alluxio.worker.evictor.class").setDefaultValue("alluxio.worker.block.evictor.LRUEvictor").setDescription("The strategy that a worker uses to evict block files when a storage layer runs out of space. Valid options include `alluxio.worker.block.evictor.LRFUEvictor`, `alluxio.worker.block.evictor.GreedyEvictor`, `alluxio.worker.block.evictor.LRUEvictor`, `alluxio.worker.block.evictor.PartialLRUEvictor`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_EVICTOR_LRFU_ATTENUATION_FACTOR = new Builder("alluxio.worker.evictor.lrfu.attenuation.factor").setDefaultValue(2.0).setDescription("A attenuation factor in [2, INF) to control the behavior of LRFU.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_EVICTOR_LRFU_STEP_FACTOR = new Builder("alluxio.worker.evictor.lrfu.step.factor").setDefaultValue(0.25).setDescription("A factor in [0, 1] to control the behavior of LRFU: smaller value makes LRFU more similar to LFU; and larger value makes LRFU closer to LRU.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FILE_PERSIST_POOL_SIZE = new Builder("alluxio.worker.file.persist.pool.size").setDefaultValue(64).setDescription("The size of the thread pool per worker, in which the thread persists an ASYNC_THROUGH file to under storage.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FILE_PERSIST_RATE_LIMIT = new Builder("alluxio.worker.file.persist.rate.limit").setDefaultValue("2GB").setDescription("The rate limit of asynchronous persistence per second.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FILE_PERSIST_RATE_LIMIT_ENABLED = new Builder("alluxio.worker.file.persist.rate.limit.enabled").setDefaultValue(false).setDescription("Whether to enable rate limiting when performing asynchronous persistence.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FILE_BUFFER_SIZE = new Builder("alluxio.worker.file.buffer.size").setDefaultValue("1MB").setDescription("The buffer size for worker to write data into the tiered storage.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FILESYSTEM_HEARTBEAT_INTERVAL_MS = new Builder("alluxio.worker.filesystem.heartbeat.interval").setAlias("alluxio.worker.filesystem.heartbeat.interval.ms").setDefaultValue("1sec").setDescription("The heartbeat interval between the worker and file system master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FREE_SPACE_TIMEOUT = new Builder("alluxio.worker.free.space.timeout").setDefaultValue("10sec").setDescription("The duration for which a worker will wait for eviction to make space available for a client write request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_HOSTNAME = new Builder("alluxio.worker.hostname").setDescription("The hostname of Alluxio worker.").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_KEYTAB_FILE = new Builder("alluxio.worker.keytab.file").setDescription("Kerberos keytab file for Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MASTER_CONNECT_RETRY_TIMEOUT = new Builder("alluxio.worker.master.connect.retry.timeout").setDescription("Retry period before workers give up on connecting to master and exit.").setDefaultValue("1hour").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MEMORY_SIZE = new Builder("alluxio.worker.memory.size").setDefaultSupplier(() -> {
        try {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return operatingSystemMXBean.getTotalPhysicalMemorySize() * 2L / 3L;
        }
        catch (Exception e) {
            return "1GB";
        }
    }, "2/3 of total system memory, or 1GB if system memory size cannot be determined").setDescription("Memory capacity of each worker node.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_ASYNC_CACHE_MANAGER_THREADS_MAX = new Builder("alluxio.worker.network.async.cache.manager.threads.max").setDefaultValue(8).setDescription("The maximum number of threads used to cache blocks asynchronously in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_BLOCK_READER_THREADS_MAX = new Builder("alluxio.worker.network.block.reader.threads.max").setDefaultValue(2048).setDescription("The maximum number of threads used to read blocks in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_BLOCK_WRITER_THREADS_MAX = new Builder("alluxio.worker.network.block.writer.threads.max").setDefaultValue(1024).setDescription("The maximum number of threads used to write blocks in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.worker.network.writer.buffer.size.messages").setDefaultValue(8).setDescription("When a client writes to a remote worker, the maximum number of data messages to buffer by the server for each request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_FLOWCONTROL_WINDOW = new Builder("alluxio.worker.network.flowcontrol.window").setDefaultValue("2MB").setDescription("The HTTP2 flow control window used by worker gRPC connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_KEEPALIVE_TIME_MS = new Builder("alluxio.worker.network.keepalive.time").setDefaultValue("30sec").setDescription("The amount of time for data server (for block reads and block writes) to wait for a response before pinging the client to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_KEEPALIVE_TIMEOUT_MS = new Builder("alluxio.worker.network.keepalive.timeout").setDefaultValue("30sec").setDescription("The maximum time for a data server (for block reads and block writes) to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.worker.network.max.inbound.message.size").setDefaultValue("4MB").setDescription("The max inbound message size used by worker gRPC connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_BOSS_THREADS = new Builder("alluxio.worker.network.netty.boss.threads").setDefaultValue(1).setDescription("How many threads to use for accepting new requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_CHANNEL = new Builder("alluxio.worker.network.netty.channel").setDescription("Netty channel type: NIO or EPOLL. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).setDefaultValue("EPOLL").build();
    public static final PropertyKey WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD = new Builder("alluxio.worker.network.netty.shutdown.quiet.period").setDefaultValue("2sec").setDescription("The quiet period. When the netty server is shutting down, it will ensure that no RPCs occur during the quiet period. If an RPC occurs, then the quiet period will restart before shutting down the netty server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WATERMARK_HIGH = new Builder("alluxio.worker.network.netty.watermark.high").setDefaultValue("32KB").setDescription("Determines how many bytes can be in the write queue before switching to non-writable.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WATERMARK_LOW = new Builder("alluxio.worker.network.netty.watermark.low").setDefaultValue("8KB").setDescription("Once the high watermark limit is reached, the queue must be flushed down to the low watermark before switching back to writable.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WORKER_THREADS = new Builder("alluxio.worker.network.netty.worker.threads").setDefaultValue(0).setDescription("How many threads to use for processing requests. Zero defaults to #cpuCores * 2.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_READER_BUFFER_SIZE_BYTES = new Builder("alluxio.worker.network.reader.buffer.size").setDefaultValue("4MB").setDescription("When a client reads from a remote worker, the maximum amount of data not received by client allowed before the worker pauses sending more data. If this value is lower than read chunk size, read performance may be impacted as worker waits more often for buffer to free up. Higher value will increase the memory consumed by each read request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_READER_MAX_CHUNK_SIZE_BYTES = new Builder("alluxio.worker.network.reader.max.chunk.size.bytes").setDefaultValue("2MB").setDescription("When a client read from a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_SHUTDOWN_TIMEOUT = new Builder("alluxio.worker.network.shutdown.timeout").setDefaultValue("15sec").setDescription("Maximum amount of time to wait until the worker gRPC server is shutdown (regardless of the quiet period).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_ZEROCOPY_ENABLED = new Builder("alluxio.worker.network.zerocopy.enabled").setDefaultValue(true).setDescription("Whether zero copy is enabled on worker when processing data streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_MASTER_CLIENT_POOL_SIZE = new Builder("alluxio.worker.block.master.client.pool.size").setDefaultValue(11).setDescription("The block master client pool size on the Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_PRINCIPAL = new Builder("alluxio.worker.principal").setDescription("Kerberos principal for Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_RPC_PORT = new Builder("alluxio.worker.rpc.port").setAlias("alluxio.worker.port").setDefaultValue(29999).setDescription("The port for Alluxio worker's RPC service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_SESSION_TIMEOUT_MS = new Builder("alluxio.worker.session.timeout").setAlias("alluxio.worker.session.timeout.ms").setDefaultValue("1min").setDescription("Timeout between worker and client connection indicating a lost session connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_STORAGE_CHECKER_ENABLED = new Builder("alluxio.worker.storage.checker.enabled").setDefaultValue(true).setDescription("Whether periodic storage health checker is enabled on Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_BLOCK_LOCK_READERS = new Builder("alluxio.worker.tieredstore.block.lock.readers").setDefaultValue(1000).setDescription("The max number of concurrent readers for a block lock.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_BLOCK_LOCKS = new Builder("alluxio.worker.tieredstore.block.locks").setDefaultValue(1000).setDescription("Total number of block locks for an Alluxio block worker. Larger value leads to finer locking granularity, but uses more space.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 0).setDefaultValue("MEM").setDescription("The alias of the top storage tier on this worker. It must match one of the global storage tiers from the master configuration. We disable placing an alias lower in the global hierarchy before an alias with a higher position on the worker hierarchy. So by default, SSD cannot come before MEM on any worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 0).setDefaultSupplier(() -> OSUtils.isLinux() ? "/mnt/ramdisk" : "/Volumes/ramdisk", "/mnt/ramdisk on Linux, /Volumes/ramdisk on OSX").setDescription("The path of storage directory for the top storage tier. Note for MacOS the value should be `/Volumes/`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 0).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(0))).setDescription(String.format("A list of media types (e.g., \"MEM,SSD,SSD\") for each storage directory on the top storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 0).setDefaultValue(String.format("${%s}", "alluxio.worker.memory.size")).setDescription("The capacity of the top storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 0).setDefaultValue(0.95).setDescription("The high watermark of the space in the top storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 0).setDefaultValue(0.7).setDescription("The low watermark of the space in the top storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 1).setDescription("The alias of the second storage tier on this worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 1).setDescription("The path of storage directory for the second storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 1).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(1))).setDescription(String.format("A list of media types (e.g., \"MEM,SSD,SSD\") for each storage directory on the second storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL1_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 1).setDescription("The capacity of the second storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 1).setDescription("The high watermark of the space in the second storage tier (a value between 0 and 1).").setDefaultValue(0.95).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 1).setDefaultValue(0.7).setDescription("The low watermark of the space in the second storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 2).setDescription("The alias of the third storage tier on this worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 2).setDescription("The path of storage directory for the third storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 2).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(2))).setDescription(String.format("A list of media types (e.g., \"MEM,SSD,SSD\") for each storage directory on the third storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL2_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 2).setDescription("The capacity of the third storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 2).setDefaultValue(0.95).setDescription("The high watermark of the space in the third storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 2).setDefaultValue(0.7).setDescription("The low watermark of the space in the third storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVELS = new Builder("alluxio.worker.tieredstore.levels").setDefaultValue(1).setDescription("The number of storage tiers on the worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_RESERVER_INTERVAL_MS = new Builder("alluxio.worker.tieredstore.reserver.interval").setAlias("alluxio.worker.tieredstore.reserver.interval.ms").setDefaultValue("1sec").setDescription("The time period of space reserver service, which keeps certain portion of available space on each layer.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_BIND_HOST = new Builder("alluxio.worker.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio worker's web server binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_HOSTNAME = new Builder("alluxio.worker.web.hostname").setDescription("The hostname Alluxio worker's web UI binds to.").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_PORT = new Builder("alluxio.worker.web.port").setDefaultValue(30000).setDescription("The port Alluxio worker's web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_BLOCK_OPEN_TIMEOUT_MS = new Builder("alluxio.worker.ufs.block.open.timeout").setAlias("alluxio.worker.ufs.block.open.timeout.ms").setDefaultValue("5min").setDescription("Timeout to open a block from UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_ENABLED = new Builder("alluxio.worker.ufs.instream.cache.enabled").setDefaultValue("true").setDescription("Enable caching for seekable under storage input stream, so that subsequent seek operations on the same file will reuse the cached input stream. This will improve position read performance as the open operations of some under file system would be expensive. The cached input stream would be stale, when the UFS file is modified without notifying alluxio. ").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_EXPIRARTION_TIME = new Builder("alluxio.worker.ufs.instream.cache.expiration.time").setDefaultValue("5min").setDescription("Cached UFS instream expiration time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_MAX_SIZE = new Builder("alluxio.worker.ufs.instream.cache.max.size").setDefaultValue("5000").setDescription("The max entries in the UFS instream cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey PROXY_S3_WRITE_TYPE = new Builder("alluxio.proxy.s3.writetype").setDefaultValue("CACHE_THROUGH").setDescription("Write type when creating buckets and objects through S3 API. Valid options are `MUST_CACHE` (write will only go to Alluxio and must be stored in Alluxio), `CACHE_THROUGH` (try to cache, write to UnderFS synchronously), `ASYNC_THROUGH` (try to cache, write to UnderFS asynchronously), `THROUGH` (no cache, write to UnderFS synchronously).").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_S3_DELETE_TYPE = new Builder("alluxio.proxy.s3.deletetype").setDefaultValue("ALLUXIO_AND_UFS").setDescription(String.format("Delete type when deleting buckets and objects through S3 API. Valid options are `%s` (delete both in Alluxio and UFS), `%s` (delete only the buckets or objects in Alluxio namespace).", "ALLUXIO_AND_UFS", "ALLUXIO_ONLY")).setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_S3_MULTIPART_TEMPORARY_DIR_SUFFIX = new Builder("alluxio.proxy.s3.multipart.temporary.dir.suffix").setDefaultValue("_s3_multipart_tmp").setDescription("Suffix for the directory which holds parts during a multipart upload.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey PROXY_STREAM_CACHE_TIMEOUT_MS = new Builder("alluxio.proxy.stream.cache.timeout").setAlias("alluxio.proxy.stream.cache.timeout.ms").setDefaultValue("1hour").setDescription("The timeout for the input and output streams cache eviction in the proxy.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_BIND_HOST = new Builder("alluxio.proxy.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname that the Alluxio proxy's web server runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_HOSTNAME = new Builder("alluxio.proxy.web.hostname").setDescription("The hostname Alluxio proxy's web UI binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_PORT = new Builder("alluxio.proxy.web.port").setDefaultValue(39999).setDescription("The port Alluxio proxy's web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey LOCALITY_ORDER = new Builder("alluxio.locality.order").setDefaultValue(String.format("%s,%s", "node", "rack")).setDescription("Ordering of locality tiers").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey LOCALITY_SCRIPT = new Builder("alluxio.locality.script").setDefaultValue("alluxio-locality.sh").setDescription("A script to determine tiered identity for locality checking").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey LOCALITY_TIER_NODE = new Builder(Template.LOCALITY_TIER, "node").setDescription("Value to use for determining node locality").build();
    public static final PropertyKey LOCALITY_TIER_RACK = new Builder(Template.LOCALITY_TIER, "rack").setDescription("Value to use for determining rack locality").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey LOCALITY_COMPARE_NODE_IP = new Builder("alluxio.locality.compare.node.ip").setDefaultValue(false).setDescription("Whether try to resolve the node IP address for locality checking").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey LOGSERVER_LOGS_DIR = new Builder("alluxio.logserver.logs.dir").setDefaultValue(String.format("${%s}/logs", "alluxio.work.dir")).setDescription("Default location for remote log files.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_HOSTNAME = new Builder("alluxio.logserver.hostname").setDescription("The hostname of Alluxio logserver.").setIgnoredSiteProperty(true).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_PORT = new Builder("alluxio.logserver.port").setDefaultValue(45600).setDescription("Default port of logserver to receive logs from alluxio servers.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_THREADS_MAX = new Builder("alluxio.logserver.threads.max").setDefaultValue(2048).setDescription("The maximum number of threads used by logserver to service logging requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_THREADS_MIN = new Builder("alluxio.logserver.threads.min").setDefaultValue(512).setDescription("The minimum number of threads used by logserver to service logging requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey USER_BLOCK_MASTER_CLIENT_THREADS = new Builder("alluxio.user.block.master.client.threads").setDefaultValue(10).setDescription("The number of threads used by a block master client pool to talk to the block master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_POOL_SIZE = new Builder("alluxio.user.block.worker.client.pool.size").setDefaultValue(1024).setDescription("The maximum number of block worker clients cached in the block worker client pool.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = new Builder("alluxio.user.block.worker.client.pool.gc.threshold").setDefaultValue("300sec").setDescription("A block worker client is closed if it has been idle for more than this threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES = new Builder("alluxio.user.block.remote.read.buffer.size.bytes").setDefaultValue("8MB").setDescription("The size of the file buffer to read data from remote Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CONF_SYNC_INTERVAL = new Builder("alluxio.user.conf.sync.interval").setDefaultValue("1min").setDescription("The time period of client master heartbeat to update the configuration if necessary from meta master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_MAX = new Builder("alluxio.user.file.replication.max").setDefaultValue(-1).setDescription("The target max replication level of a file in Alluxio space. Setting this property to a negative value means no upper limit.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_MIN = new Builder("alluxio.user.file.replication.min").setDefaultValue(0).setDescription("The target min replication level of a file in Alluxio space.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_DURABLE = new Builder("alluxio.user.file.replication.durable").setDefaultValue(1).setDescription("The target replication level of a file created by ASYNC_THROUGH writesbefore this file is persisted.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_SIZE_BYTES_DEFAULT = new Builder("alluxio.user.block.size.bytes.default").setDefaultValue("64MB").setDescription("Default block size for Alluxio files.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_READ_RETRY = new Builder("alluxio.user.block.worker.client.read.retry").setDefaultValue(5).setDescription("The maximum number of workers to retry before the client gives up on reading a block").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CONF_CLUSTER_DEFAULT_ENABLED = new Builder("alluxio.user.conf.cluster.default.enabled").setDefaultValue(true).setDescription("When this property is true, an Alluxio client will load the default values of configuration properties set by Alluxio master.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_DATE_FORMAT_PATTERN = new Builder("alluxio.user.date.format.pattern").setDefaultValue("MM-dd-yyyy HH:mm:ss:SSS").setDescription("Display formatted date in cli command and web UI by given date format pattern.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_BUFFER_BYTES = new Builder("alluxio.user.file.buffer.bytes").setDefaultValue("8MB").setDescription("The size of the file buffer to use for file system reads/writes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY = new Builder("alluxio.user.file.copyfromlocal.block.location.policy.class").setDefaultValue("alluxio.client.block.policy.RoundRobinPolicy").setDescription("The default location policy for choosing workers for writing a file's blocks using copyFromLocal command.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_DELETE_UNCHECKED = new Builder("alluxio.user.file.delete.unchecked").setDefaultValue(false).setDescription("Whether to check if the UFS contents are in sync with Alluxio before attempting to delete persisted directories recursively.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_MASTER_CLIENT_THREADS = new Builder("alluxio.user.file.master.client.threads").setDefaultValue(10).setDescription("The number of threads used by a file master client to talk to the file master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_METADATA_LOAD_TYPE = new Builder("alluxio.user.file.metadata.load.type").setDefaultValue("ONCE").setDescription("The behavior of loading metadata from UFS. When information about a path is requested and the path does not exist in Alluxio, metadata can be loaded from the UFS. Valid options are `ALWAYS`, `NEVER`, and `ONCE`. `ALWAYS` will always access UFS to see if the path exists in the UFS. `NEVER` will never consult the UFS. `ONCE` will access the UFS the \"first\" time (according to a cache), but not after that. This parameter is ignored if a metadata sync is performed, via the parameter \"alluxio.user.file.metadata.sync.interval\"").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_METADATA_SYNC_INTERVAL = new Builder("alluxio.user.file.metadata.sync.interval").setDefaultValue("-1").setDescription("The interval for syncing UFS metadata before invoking an operation on a path. -1 means no sync will occur. 0 means Alluxio will always sync the metadata of the path before an operation. If you specify a time interval, Alluxio will (best effort) not re-sync a path within that time interval. Syncing the metadata for a path must interact with the UFS, so it is an expensive operation. If a sync is performed for an operation, the configuration of \"alluxio.user.file.metadata.load.type\" will be ignored.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PASSIVE_CACHE_ENABLED = new Builder("alluxio.user.file.passive.cache.enabled").setDefaultValue(true).setDescription("Whether to cache files to local Alluxio workers when the files are read from remote workers (not UFS).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_READ_TYPE_DEFAULT = new Builder("alluxio.user.file.readtype.default").setDefaultValue("CACHE_PROMOTE").setDescription("Default read type when creating Alluxio files. Valid options are `CACHE_PROMOTE` (move data to highest tier if already in Alluxio storage, write data into highest tier of local Alluxio if data needs to be read from under storage), `CACHE` (write data into highest tier of local Alluxio if data needs to be read from under storage), `NO_CACHE` (no data interaction with Alluxio, if the read is from Alluxio data migration or eviction will not occur).").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PERSIST_ON_RENAME = new Builder("alluxio.user.file.persist.on.rename").setDefaultValue("false").setDescription("Whether or not to asynchronously persist any files which have been renamed. This is helpful when working with compute frameworks which use rename to commit results.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME = new Builder("alluxio.user.file.persistence.initial.wait.time").setDefaultValue("0").setDescription(String.format("Time to wait before starting the persistence job. When the value is set to -1, the file will be persisted by rename operation or persist CLI but will not be automatically persisted in other cases. This is to avoid the heavy object copy in rename operation when %s is set to %s. This value should be smaller than the value of %s", "alluxio.user.file.writetype.default", WritePType.ASYNC_THROUGH, "alluxio.master.persistence.max.total.wait.time")).build();
    public static final PropertyKey USER_FILE_WAITCOMPLETED_POLL_MS = new Builder("alluxio.user.file.waitcompleted.poll").setAlias("alluxio.user.file.waitcompleted.poll.ms").setDefaultValue("1sec").setDescription("The time interval to poll a file for its completion status when using waitCompleted.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_CREATE_TTL = new Builder("alluxio.user.file.create.ttl").setDefaultValue(-1L).setDescription("Time to live for files created by a user, no ttl by default.").build();
    public static final PropertyKey USER_FILE_CREATE_TTL_ACTION = new Builder("alluxio.user.file.create.ttl.action").setDefaultValue("DELETE").setDescription("When file's ttl is expired, the action performs on it. Options: DELETE (default) or FREE").build();
    public static final PropertyKey USER_FILE_UFS_TIER_ENABLED = new Builder("alluxio.user.file.ufs.tier.enabled").setDescription("When workers run out of available memory, whether the client can skip writing data to Alluxio but fallback to write to UFS without stopping the application. This property only works when the write type is ASYNC_THROUGH.").setDefaultValue(false).build();
    public static final PropertyKey USER_BLOCK_WRITE_LOCATION_POLICY = new Builder("alluxio.user.block.write.location.policy.class").setDefaultValue("alluxio.client.block.policy.LocalFirstPolicy").setDescription("The default location policy for choosing workers for writing a file's blocks.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES = new Builder("alluxio.user.block.avoid.eviction.policy.reserved.size.bytes").setDefaultValue("0MB").setDescription("The portion of space reserved in a worker when using the LocalFirstAvoidEvictionPolicy class as block location policy.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_WRITE_TYPE_DEFAULT = new Builder("alluxio.user.file.writetype.default").setDefaultValue("ASYNC_THROUGH").setDescription(String.format("Default write type when creating Alluxio files. Valid options are `MUST_CACHE` (write will only go to Alluxio and must be stored in Alluxio), `CACHE_THROUGH` (try to cache, write to UnderFS synchronously), `THROUGH` (no cache, write to UnderFS synchronously), `ASYNC_THROUGH` (write to cache, write to UnderFS asynchronously, replicated %s times in Alluxio before data is persisted.", USER_FILE_REPLICATION_DURABLE)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_HOSTNAME = new Builder("alluxio.user.hostname").setDescription("The hostname to use for an Alluxio client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_WRITE_TIER_DEFAULT = new Builder("alluxio.user.file.write.tier.default").setDefaultValue(0).setDescription("The default tier for choosing a where to write a block. Valid option is any integer. Non-negative values identify tiers starting from top going down (0 identifies the first tier, 1 identifies the second tier, and so on). If the provided value is greater than the number of tiers, it identifies the last tier. Negative values identify tiers starting from the bottom going up (-1 identifies the last tier, -2 identifies the second to last tier, and so on). If the absolute value of the provided value is greater than the number of tiers, it identifies the first tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_LOCAL_READER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.local.reader.chunk.size.bytes").setDefaultValue("8MB").setDescription("When a client reads from a local worker, the maximum data chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_LOCAL_WRITER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.local.writer.chunk.size.bytes").setDefaultValue("64KB").setDescription("When a client writes to a local worker, the maximum data chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METRICS_COLLECTION_ENABLED = new Builder("alluxio.user.metrics.collection.enabled").setDefaultValue(false).setDescription("Enable collecting the client-side metrics and heartbeat them to master").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METRICS_HEARTBEAT_INTERVAL_MS = new Builder("alluxio.user.metrics.heartbeat.interval").setAlias("alluxio.user.metrics.heartbeat.interval.ms").setDefaultValue("3sec").setDescription("The time period of client master heartbeat to send the client-side metrics.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_APP_ID = new Builder("alluxio.user.app.id").setScope(Scope.CLIENT).setDescription("The custom id to use for labeling this client's info, such as metrics. If unset, a random long will be used. This value is displayed in the client logs on initialization. Note that using the same app id will cause client info to be aggregated, so different applications must set their own ids or leave this value unset to use a randomly generated id.").build();
    public static final PropertyKey USER_NETWORK_DATA_TIMEOUT_MS = new Builder("alluxio.user.network.data.timeout").setAlias("alluxio.user.network.data.timeout.ms").setDefaultValue("30sec").setDescription("The maximum time for an Alluxio client to wait for a data response (e.g. block reads and block writes) from Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_FLOWCONTROL_WINDOW = new Builder("alluxio.user.network.flowcontrol.window").setDefaultValue("2MB").setDescription("The HTTP2 flow control window used by user gRPC connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_KEEPALIVE_TIME_MS = new Builder("alluxio.user.network.keepalive.time").setDefaultValue(Long.MAX_VALUE).setDescription("The amount of time for a gRPC client (for block reads and block writes) to wait for a response before pinging the server to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_KEEPALIVE_TIMEOUT_MS = new Builder("alluxio.user.network.keepalive.timeout").setDefaultValue("30sec").setDescription("The maximum time for a gRPC client (for block reads and block writes) to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.user.network.max.inbound.message.size").setDefaultValue("100MB").setDescription("The max inbound message size used by user gRPC connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_NETTY_CHANNEL = new Builder("alluxio.user.network.netty.channel").setDescription("Type of netty channels. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setDefaultValue("EPOLL").build();
    public static final PropertyKey USER_NETWORK_NETTY_WORKER_THREADS = new Builder("alluxio.user.network.netty.worker.threads").setDefaultValue(0).setDescription("How many threads to use for remote block worker client to read from remote block workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_READER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.network.reader.buffer.size.messages").setDefaultValue(16).setDescription("When a client reads from a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_READER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.network.reader.chunk.size.bytes").setDefaultValue("1MB").setDescription("When a client reads from a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.network.writer.buffer.size.messages").setDefaultValue(16).setDescription("When a client writes to a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_WRITER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.network.writer.chunk.size.bytes").setDefaultValue("1MB").setDescription("When a client writes to a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_WRITER_CLOSE_TIMEOUT_MS = new Builder("alluxio.user.network.writer.close.timeout").setAlias("alluxio.user.network.writer.close.timeout.ms").setDefaultValue("30min").setDescription("The timeout to close a writer client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_WRITER_FLUSH_TIMEOUT = new Builder("alluxio.user.network.writer.flush.timeout").setDefaultValue("30min").setDescription("The timeout to wait for flush to finish in a data writer.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_ZEROCOPY_ENABLED = new Builder("alluxio.user.network.zerocopy.enabled").setDefaultValue(true).setDescription("Whether zero copy is enabled on client when processing data streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_BASE_SLEEP_MS = new Builder("alluxio.user.rpc.retry.base.sleep").setAlias("alluxio.user.rpc.retry.base.sleep.ms").setDefaultValue("50ms").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the base time in the exponential backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_MAX_DURATION = new Builder("alluxio.user.rpc.retry.max.duration").setDefaultValue("2min").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the maximum duration to retry for before giving up. Note that, this value is set to 5s for fs and fsadmin CLIs.").build();
    public static final PropertyKey USER_WORKER_LIST_REFRESH_INTERVAL = new Builder("alluxio.user.worker.list.refresh.interval").setDefaultValue("2min").setDescription("The interval used to refresh the live worker list on the client").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_MAX_SLEEP_MS = new Builder("alluxio.user.rpc.retry.max.sleep").setAlias("alluxio.user.rpc.retry.max.sleep.ms").setDefaultValue("3sec").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the maximum wait time in the backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED = new Builder("alluxio.user.ufs.block.location.all.fallback.enabled").setDefaultValue(false).setDescription("Whether to return all workers as block location if ufs block locations are not co-located with any Alluxio workers or is empty.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_LOCATION_POLICY = new Builder("alluxio.user.ufs.block.read.location.policy").setDefaultValue("alluxio.client.block.policy.LocalFirstPolicy").setDescription(String.format("When an Alluxio client reads a file from the UFS, it delegates the read to an Alluxio worker. The client uses this policy to choose which worker to read through. Built-in choices: %s.", Arrays.asList(PropertyKey.javadocLink("alluxio.client.block.policy.DeterministicHashPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.LocalFirstAvoidEvictionPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.LocalFirstPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.MostAvailableFirstPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.RoundRobinPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.SpecificHostPolicy")))).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_LOCATION_POLICY_DETERMINISTIC_HASH_SHARDS = new Builder("alluxio.user.ufs.block.read.location.policy.deterministic.hash.shards").setDefaultValue(1).setDescription("When alluxio.user.ufs.block.read.location.policy is set to alluxio.client.block.policy.DeterministicHashPolicy, this specifies the number of hash shards.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_CONCURRENCY_MAX = new Builder("alluxio.user.ufs.block.read.concurrency.max").setDefaultValue(Integer.MAX_VALUE).setDescription("The maximum concurrent readers for one UFS block on one Block Worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_SHORT_CIRCUIT_ENABLED = new Builder("alluxio.user.short.circuit.enabled").setDefaultValue(true).setDescription("The short circuit read/write which allows the clients to read/write data without going through Alluxio workers if the data is local is enabled if set to true.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_ENABLED = new Builder("alluxio.user.metadata.cache.enabled").setDefaultValue(false).setDescription("If this is enabled, metadata of paths will be cached. The cached metadata will be evicted when it expires after alluxio.user.metadata.cache.expiration.time or the cache size is over the limit of alluxio.user.metadata.cache.max.size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_MAX_SIZE = new Builder("alluxio.user.metadata.cache.max.size").setDefaultValue(100000).setDescription("Maximum number of paths with cached metadata.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_EXPIRATION_TIME = new Builder("alluxio.user.metadata.cache.expiration.time").setDefaultValue("10min").setDescription("Metadata will expire and be evicted after being cached for this time period.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_CACHED_PATHS_MAX = new Builder("alluxio.fuse.cached.paths.max").setDefaultValue(500).setDescription("Maximum number of Alluxio paths to cache for FUSE conversion.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey FUSE_DEBUG_ENABLED = new Builder("alluxio.fuse.debug.enabled").setDefaultValue(false).setDescription("Run FUSE in debug mode, and have the fuse process log every FS request.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey FUSE_FS_NAME = new Builder("alluxio.fuse.fs.name").setDefaultValue("alluxio-fuse").setDescription("The FUSE file system name.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey FUSE_MAXWRITE_BYTES = new Builder("alluxio.fuse.maxwrite.bytes").setDefaultValue("128KB").setDescription("Maximum granularity of write operations, capped by the kernel to 128KB max (as of Linux 3.16.0).").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey FUSE_USER_GROUP_TRANSLATION_ENABLED = new Builder("alluxio.fuse.user.group.translation.enabled").setDefaultValue(false).setDescription("Whether to translate Alluxio users and groups into Unix users and groups when exposing Alluxio files through the FUSE API. When this property is set to false, the user and group for all FUSE files will match the user who started the alluxio-fuse process.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.NONE).build();
    public static final PropertyKey SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS = new Builder("alluxio.security.authentication.custom.provider.class").setDescription("The class to provide customized authentication implementation, when alluxio.security.authentication.type is set to CUSTOM. It must implement the interface 'alluxio.security.authentication.AuthenticationProvider'.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey SECURITY_AUTHENTICATION_TYPE = new Builder("alluxio.security.authentication.type").setDefaultValue("SIMPLE").setDescription("The authentication mode. Currently three modes are supported: NOSASL, SIMPLE, CUSTOM. The default value SIMPLE indicates that a simple authentication is enabled. Server trusts whoever the client claims to be.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_ENABLED = new Builder("alluxio.security.authorization.permission.enabled").setDefaultValue(true).setDescription("Whether to enable access control based on file permission.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP = new Builder("alluxio.security.authorization.permission.supergroup").setDefaultValue("supergroup").setDescription("The super group of Alluxio file system. All users in this group have super permission.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_UMASK = new Builder("alluxio.security.authorization.permission.umask").setDefaultValue("022").setDescription("The umask of creating file and directory. The initial creation permission is 777, and the difference between directory and file is 111. So for default umask value 022, the created directory has permission 755 and file has permission 644.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS = new Builder("alluxio.security.group.mapping.cache.timeout").setAlias("alluxio.security.group.mapping.cache.timeout.ms").setDefaultValue("1min").setDescription("Time for cached group mapping to expire.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey SECURITY_GROUP_MAPPING_CLASS = new Builder("alluxio.security.group.mapping.class").setDefaultValue("alluxio.security.group.provider.ShellBasedUnixGroupsMapping").setDescription("The class to provide user-to-groups mapping service. Master could get the various group memberships of a given user.  It must implement the interface 'alluxio.security.group.GroupMappingService'. The default implementation execute the 'groups' shell command to fetch the group memberships of a given user.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey SECURITY_LOGIN_IMPERSONATION_USERNAME = new Builder("alluxio.security.login.impersonation.username").setDescription(String.format("When %s is set to SIMPLE or CUSTOM, user application uses this property to indicate the IMPERSONATED user requesting Alluxio service. If it is not set explicitly, or set to %s, impersonation will not be used. A special value of '%s' can be specified to impersonate the hadoop client user.", SECURITY_AUTHENTICATION_TYPE, "_NONE_", "_HDFS_USER_")).setDefaultValue("_HDFS_USER_").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey SECURITY_LOGIN_USERNAME = new Builder("alluxio.security.login.username").setDescription("When alluxio.security.authentication.type is set to SIMPLE or CUSTOM, user application uses this property to indicate the user requesting Alluxio service. If it is not set explicitly, the OS login user will be used.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.CLIENT).build();
    public static final PropertyKey AUTHENTICATION_INACTIVE_CHANNEL_REAUTHENTICATE_PERIOD = new Builder("alluxio.security.stale.channel.purge.interval").setDefaultValue("3day").setDescription("Interval for which client channels that have been inactive will be regarded as unauthenticated. Such channels will reauthenticate with their target master upon being used for new RPCs.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey INTEGRATION_MASTER_RESOURCE_CPU = new Builder("alluxio.integration.master.resource.cpu").setDefaultValue(1).setDescription("The number of CPUs to run an Alluxio master for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MASTER_RESOURCE_MEM = new Builder("alluxio.integration.master.resource.mem").setDefaultValue("1024MB").setDescription("The amount of memory to run an Alluxio master for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_ALLUXIO_JAR_URL = new Builder("alluxio.integration.mesos.alluxio.jar.url").setDefaultValue(String.format("http://downloads.alluxio.io/downloads/files/${%s}/alluxio-${%s}-bin.tar.gz", "alluxio.version", "alluxio.version")).setDescription("Url to download an Alluxio distribution from during Mesos deployment.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_ALLUXIO_MASTER_NAME = new Builder("alluxio.integration.mesos.master.name").setDefaultValue("AlluxioMaster").setDescription("The name of the master process to use within Mesos.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_ALLUXIO_MASTER_NODE_COUNT = new Builder("alluxio.integration.mesos.master.node.count").setDescription("The number of Alluxio master process to run within Mesos.").setDefaultValue(1).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_ALLUXIO_WORKER_NAME = new Builder("alluxio.integration.mesos.worker.name").setDefaultValue("AlluxioWorker").setDescription("The name of the worker process to use within Mesos.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_JDK_PATH = new Builder("alluxio.integration.mesos.jdk.path").setDefaultValue("jdk1.8.0_151").setDescription("If installing java from a remote URL during mesos deployment, this must be set to the directory name of the untarred jdk.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_JDK_URL = new Builder("alluxio.integration.mesos.jdk.url").setDefaultValue("LOCAL").setDescription("A url from which to install the jdk during Mesos deployment. Default to LOCAL which tells Mesos to use the local JDK on the system. When using this property, alluxio.integration.mesos.jdk.path must also be set correctly.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_PRINCIPAL = new Builder("alluxio.integration.mesos.principal").setDefaultValue("alluxio").setDescription("The Mesos principal for the Alluxio Mesos Framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_ROLE = new Builder("alluxio.integration.mesos.role").setDefaultValue("*").setDescription("Mesos role for the Alluxio Mesos Framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MESOS_SECRET = new Builder("alluxio.integration.mesos.secret").setDescription("Secret token for authenticating with Mesos.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.NONE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey INTEGRATION_MESOS_USER = new Builder("alluxio.integration.mesos.user").setDescription("The Mesos user for the Alluxio Mesos Framework. Defaults to the current user.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_WORKER_RESOURCE_CPU = new Builder("alluxio.integration.worker.resource.cpu").setDefaultValue(1).setDescription("The number of CPUs to run an Alluxio worker for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_WORKER_RESOURCE_MEM = new Builder("alluxio.integration.worker.resource.mem").setDefaultValue("1024MB").setDescription("The amount of memory to run an Alluxio worker for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_YARN_WORKERS_PER_HOST_MAX = new Builder("alluxio.integration.yarn.workers.per.host.max").setDefaultValue(1).setDescription("The number of workers to run on an Alluxio host for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey UNDERFS_VERSION = new Builder("alluxio.underfs.version").setDefaultValue("2.7").setIsHidden(true).build();
    public static final PropertyKey JOB_MASTER_CLIENT_THREADS = new Builder("alluxio.job.master.client.threads").setDescription("The number of threads the Alluxio master uses to make requests to the job master.").setDefaultValue(1024).build();
    public static final PropertyKey JOB_MASTER_FINISHED_JOB_PURGE_COUNT = new Builder("alluxio.job.master.finished.job.purge.count").setDescription("The maximum amount of jobs to purge at any single time when the job master reaches its maximum capacity. It is recommended to set this value when setting the capacity of the job master to a large ( > 10M) value. Default is -1 denoting an unlimited value").setDefaultValue("-1").build();
    public static final PropertyKey JOB_MASTER_FINISHED_JOB_RETENTION_TIME = new Builder("alluxio.job.master.finished.job.retention.time").setDescription("The length of time the Alluxio Job Master should save information about completed jobs before they are discarded.").setDefaultValue("300sec").build();
    public static final PropertyKey JOB_MASTER_JOB_CAPACITY = new Builder("alluxio.job.master.job.capacity").setDescription("The total possible number of available job statuses in the job master. This value includes running and finished jobs which are have completed within alluxio.job.master.finished.job.retention.time.").setDefaultValue(100000).build();
    public static final PropertyKey JOB_MASTER_WORKER_HEARTBEAT_INTERVAL = new Builder("alluxio.job.master.worker.heartbeat.interval").setDescription("The amount of time that the Alluxio job worker should wait in between heartbeats to the Job Master.").setDefaultValue("1sec").build();
    public static final PropertyKey JOB_MASTER_WORKER_TIMEOUT = new Builder("alluxio.job.master.worker.timeout").setDescription("The time period after which the job master will mark a worker as lost without a subsequent heartbeat.").setDefaultValue("60sec").build();
    public static final PropertyKey JOB_MASTER_BIND_HOST = new Builder("alluxio.job.master.bind.host").setDescription("The host that the Alluxio job master will bind to.").setDefaultValue("0.0.0.0").build();
    public static final PropertyKey JOB_MASTER_HOSTNAME = new Builder("alluxio.job.master.hostname").setDescription("The hostname of the Alluxio job master.").setDefaultValue(String.format("${%s}", "alluxio.master.hostname")).build();
    public static final PropertyKey JOB_MASTER_LOST_WORKER_INTERVAL = new Builder("alluxio.job.master.lost.worker.interval").setDescription("The time interval the job master waits between checks for lost workers.").setDefaultValue("1sec").build();
    public static final PropertyKey JOB_MASTER_RPC_PORT = new Builder("alluxio.job.master.rpc.port").setDescription("The port for Alluxio job master's RPC service.").setDefaultValue(20001).build();
    public static final PropertyKey JOB_MASTER_WEB_BIND_HOST = new Builder("alluxio.job.master.web.bind.host").setDescription("The host that the job master web server binds to.").setDefaultValue("0.0.0.0").build();
    public static final PropertyKey JOB_MASTER_WEB_HOSTNAME = new Builder("alluxio.job.master.web.hostname").setDescription("The hostname of the job master web server.").setDefaultValue("${alluxio.job.master.hostname}").build();
    public static final PropertyKey JOB_MASTER_WEB_PORT = new Builder("alluxio.job.master.web.port").setDescription("The port the job master web server uses.").setDefaultValue(20002).build();
    public static final PropertyKey JOB_WORKER_BIND_HOST = new Builder("alluxio.job.worker.bind.host").setDescription("The host that the Alluxio job worker will bind to.").setDefaultValue("0.0.0.0").build();
    public static final PropertyKey JOB_WORKER_DATA_PORT = new Builder("alluxio.job.worker.data.port").setDescription("The port the Alluxio Job worker uses to send data.").setDefaultValue(30002).build();
    public static final PropertyKey JOB_WORKER_HOSTNAME = new Builder("alluxio.job.worker.hostname").setDescription("The hostname of the Alluxio job worker.").setDefaultValue(String.format("${%s}", "alluxio.worker.hostname")).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_RPC_PORT = new Builder("alluxio.job.worker.rpc.port").setDescription("The port for Alluxio job worker's RPC service.").setDefaultValue(30001).build();
    public static final PropertyKey JOB_WORKER_THREADPOOL_SIZE = new Builder("alluxio.job.worker.threadpool.size").setDescription("Number of threads in the thread pool for job worker. This may be adjusted to a lower value to alleviate resource saturation on the job worker nodes (CPU + IO).").setDefaultValue(10).build();
    public static final PropertyKey JOB_WORKER_WEB_BIND_HOST = new Builder("alluxio.job.worker.web.bind.host").setDescription("The host the job worker web server binds to.").setDefaultValue("0.0.0.0").build();
    public static final PropertyKey JOB_WORKER_WEB_PORT = new Builder("alluxio.job.worker.web.port").setDescription("The port the Alluxio job worker web server uses.").setDefaultValue(30003).build();
    public static final PropertyKey JOB_MASTER_RPC_ADDRESSES = new Builder("alluxio.job.master.rpc.addresses").setDescription(String.format("The list of RPC addresses to use for the job service configured in non-zookeeper HA mode. If this property is not specifically defined, it will first fall back to using %s, replacing those address ports with the port defined by %s. Otherwise the addresses are inherited from %s using the port defined in %s", "alluxio.master.rpc.addresses", "alluxio.job.master.rpc.port", "alluxio.job.master.embedded.journal.addresses", "alluxio.job.master.rpc.port")).setScope(Scope.CLIENT).build();
    public static final PropertyKey JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES = new Builder("alluxio.job.master.embedded.journal.addresses").setDescription(String.format("A comma-separated list of journal addresses for all job masters in the cluster. The format is 'hostname1:port1,hostname2:port2,...'. Defaults to the journal addresses set for the Alluxio masters (%s), but with the job master embedded journal port.", "alluxio.master.embedded.journal.addresses")).build();
    public static final PropertyKey JOB_MASTER_EMBEDDED_JOURNAL_PORT = new Builder("alluxio.job.master.embedded.journal.port").setDescription("The port to use for embedded journal communication with other job masters.").setDefaultValue(20003).build();
    public static final PropertyKey ZOOKEEPER_JOB_ELECTION_PATH = new Builder("alluxio.zookeeper.job.election.path").setDefaultValue("/job_election").build();
    public static final PropertyKey ZOOKEEPER_JOB_LEADER_PATH = new Builder("alluxio.zookeeper.job.leader.path").setDefaultValue("/job_leader").build();
    public static final PropertyKey JVM_MONITOR_WARN_THRESHOLD_MS = new Builder("alluxio.jvm.monitor.warn.threshold").setDefaultValue("10sec").setDescription("Extra sleep time longer than this threshold, log WARN.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey JVM_MONITOR_INFO_THRESHOLD_MS = new Builder("alluxio.jvm.monitor.info.threshold").setDefaultValue("1sec").setDescription("Extra sleep time longer than this threshold, log INFO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey JVM_MONITOR_SLEEP_INTERVAL_MS = new Builder("alluxio.jvm.monitor.sleep.interval").setDefaultValue("1sec").setDescription("The time for the JVM monitor thread to sleep.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_JVM_MONITOR_ENABLED = new Builder("alluxio.master.jvm.monitor.enabled").setDefaultValue(false).setDescription("Whether to enable start JVM monitor thread on master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey WORKER_JVM_MONITOR_ENABLED = new Builder("alluxio.worker.jvm.monitor.enabled").setDefaultValue(false).setDescription("Whether to enable start JVM monitor thread on worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey TABLE_ENABLED = new Builder("alluxio.table.enabled").setDefaultValue(true).setDescription("(Experimental) Enables the table service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_CATALOG_PATH = new Builder("alluxio.table.catalog.path").setDefaultValue("/catalog").setDescription("The Alluxio file path for the table catalog metadata.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_TRANSFORM_MANAGER_JOB_MONITOR_INTERVAL = new Builder("alluxio.table.transform.manager.job.monitor.interval").setDefaultValue(10000).setDescription("Job monitor is a heartbeat thread in the transform manager, this is the time interval in milliseconds the job monitor heartbeat is run to check the status of the transformation jobs and update table and partition locations after transformation.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_TRANSFORM_MANAGER_JOB_HISTORY_RETENTION_TIME = new Builder("alluxio.table.transform.manager.job.history.retention.time").setDefaultValue("300sec").setDescription("The length of time the Alluxio Table Master should keep information about finished transformation jobs before they are discarded.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    @Deprecated(message="This key is used only for testing. It is always deprecated")
    public static final PropertyKey TEST_DEPRECATED_KEY = new Builder("alluxio.test.deprecated.key").build();
    private final String mName;
    private final String mDescription;
    private final DefaultSupplier mDefaultSupplier;
    private final String[] mAliases;
    private final boolean mIgnoredSiteProperty;
    private final boolean mIsBuiltIn;
    private final boolean mIsHidden;
    private final ConsistencyCheckLevel mConsistencyCheckLevel;
    private final Scope mScope;
    private final DisplayType mDisplayType;
    private static final DeprecatedKeyChecker DEPRECATED_CHECKER = new DeprecatedKeyChecker();

    private static String javadocLink(String fullyQualifiedClassname) {
        String javadocPath = fullyQualifiedClassname.replace(".", "/") + ".html";
        return String.format("<a href=\"%s\">%s</a>", PathUtils.concatPath((Object)RuntimeConstants.ALLUXIO_JAVADOC_URL, (Object)javadocPath), fullyQualifiedClassname);
    }

    public static boolean isValid(String input) {
        if (DEFAULT_KEYS_MAP.containsKey(input) || DEFAULT_ALIAS_MAP.containsKey(input)) {
            return true;
        }
        for (Template template : Template.values()) {
            if (!template.matches(input)) continue;
            return true;
        }
        return false;
    }

    public static PropertyKey fromString(String input) {
        PropertyKey key = DEFAULT_KEYS_MAP.get(input);
        if (key != null) {
            return key;
        }
        key = DEFAULT_ALIAS_MAP.get(input);
        if (key != null) {
            return key;
        }
        for (Template template : Template.values()) {
            key = template.getPropertyKey(input);
            if (key == null) continue;
            return key;
        }
        if (PropertyKey.isRemoved(input)) {
            String errorMsg = String.format("%s is no longer a valid property. %s", input, PropertyKey.getRemovalMessage(input));
            LOG.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        throw new IllegalArgumentException(ExceptionMessage.INVALID_CONFIGURATION_KEY.getMessage(input));
    }

    public static Collection<? extends PropertyKey> defaultKeys() {
        return Sets.newHashSet(DEFAULT_KEYS_MAP.values());
    }

    private PropertyKey(String name, String description, DefaultSupplier defaultSupplier, String[] aliases, boolean ignoredSiteProperty, boolean isHidden, ConsistencyCheckLevel consistencyCheckLevel, Scope scope, DisplayType displayType, boolean isBuiltIn) {
        this.mName = Preconditions.checkNotNull(name, "name");
        this.mDescription = Strings.isNullOrEmpty(description) ? "N/A" : description;
        this.mDefaultSupplier = defaultSupplier;
        this.mAliases = aliases;
        this.mIgnoredSiteProperty = ignoredSiteProperty;
        this.mIsHidden = isHidden;
        this.mConsistencyCheckLevel = consistencyCheckLevel;
        this.mScope = scope;
        this.mDisplayType = displayType;
        this.mIsBuiltIn = isBuiltIn;
    }

    private PropertyKey(String name) {
        this(name, null, new DefaultSupplier(() -> null, "null"), null, false, false, ConsistencyCheckLevel.IGNORE, Scope.ALL, DisplayType.DEFAULT, true);
    }

    @VisibleForTesting
    public static boolean register(PropertyKey key) {
        String name = key.getName();
        String[] aliases = key.getAliases();
        if (DEFAULT_KEYS_MAP.containsKey(name) && (DEFAULT_KEYS_MAP.get(name).isBuiltIn() || !key.isBuiltIn())) {
            return false;
        }
        DEFAULT_KEYS_MAP.put(name, key);
        if (aliases != null) {
            for (String alias : aliases) {
                DEFAULT_ALIAS_MAP.put(alias, key);
            }
        }
        return true;
    }

    @VisibleForTesting
    public static void unregister(PropertyKey key) {
        String name = key.getName();
        DEFAULT_KEYS_MAP.remove(name);
        DEFAULT_ALIAS_MAP.remove(name);
    }

    public static PropertyKey getOrBuildCustom(String name) {
        return DEFAULT_KEYS_MAP.computeIfAbsent(name, key -> new Builder((String)key).setIsBuiltIn(false).buildUnregistered());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyKey)) {
            return false;
        }
        PropertyKey that = (PropertyKey)o;
        return Objects.equal(this.mName, that.mName);
    }

    public int hashCode() {
        return Objects.hashCode(this.mName);
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int compareTo(PropertyKey o) {
        return this.mName.compareTo(o.mName);
    }

    public int length() {
        return this.mName.length();
    }

    public boolean isNested(String key) {
        return key.length() > this.length() + 1 && key.startsWith(this.mName) && key.charAt(this.length()) == '.';
    }

    public String getName() {
        return this.mName;
    }

    public String[] getAliases() {
        return this.mAliases;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public String getDefaultValue() {
        Object defaultValue = this.mDefaultSupplier.get();
        return defaultValue == null ? null : defaultValue.toString();
    }

    public DefaultSupplier getDefaultSupplier() {
        return this.mDefaultSupplier;
    }

    public boolean isIgnoredSiteProperty() {
        return this.mIgnoredSiteProperty;
    }

    public boolean isBuiltIn() {
        return this.mIsBuiltIn;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public ConsistencyCheckLevel getConsistencyLevel() {
        return this.mConsistencyCheckLevel;
    }

    public Scope getScope() {
        return this.mScope;
    }

    public DisplayType getDisplayType() {
        return this.mDisplayType;
    }

    public static boolean isDeprecated(PropertyKey key) {
        return DEPRECATED_CHECKER.hasAnnotation(key);
    }

    public static boolean isDeprecated(String name) {
        return PropertyKey.isDeprecated(PropertyKey.fromString(name));
    }

    public static boolean isRemoved(String key) {
        return RemovedKey.isRemoved(key);
    }

    public static String getDeprecationMessage(PropertyKey key) {
        Deprecated annotation;
        if (PropertyKey.isDeprecated(key) && (annotation = DEPRECATED_CHECKER.getAnnotation(key)) != null) {
            return annotation.message();
        }
        return "";
    }

    public static String getRemovalMessage(String key) {
        String msg = RemovedKey.getMessage(key);
        return msg == null ? "" : msg;
    }

    @ThreadSafe
    public static enum Template {
        LOCALITY_TIER("alluxio.locality.%s", "alluxio\\.locality\\.(\\w+)"),
        MASTER_IMPERSONATION_GROUPS_OPTION("alluxio.master.security.impersonation.%s.groups", "alluxio\\.master\\.security\\.impersonation\\.([a-zA-Z_0-9-\\.@]+)\\.groups"),
        MASTER_IMPERSONATION_USERS_OPTION("alluxio.master.security.impersonation.%s.users", "alluxio\\.master\\.security\\.impersonation\\.([a-zA-Z_0-9-\\.@]+)\\.users"),
        MASTER_JOURNAL_UFS_OPTION("alluxio.master.journal.ufs.option", "alluxio\\.master\\.journal\\.ufs\\.option"),
        MASTER_JOURNAL_UFS_OPTION_PROPERTY("alluxio.master.journal.ufs.option.%s", "alluxio\\.master\\.journal\\.ufs\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$200()),
        MASTER_MOUNT_TABLE_ALLUXIO("alluxio.master.mount.table.%s.alluxio", "alluxio\\.master\\.mount\\.table.(\\w+)\\.alluxio"),
        MASTER_MOUNT_TABLE_OPTION("alluxio.master.mount.table.%s.option", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.option"),
        MASTER_MOUNT_TABLE_OPTION_PROPERTY("alluxio.master.mount.table.%s.option.%s", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$300()),
        MASTER_MOUNT_TABLE_READONLY("alluxio.master.mount.table.%s.readonly", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.readonly"),
        MASTER_MOUNT_TABLE_SHARED("alluxio.master.mount.table.%s.shared", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.shared"),
        MASTER_MOUNT_TABLE_UFS("alluxio.master.mount.table.%s.ufs", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.ufs"),
        MASTER_MOUNT_TABLE_ROOT_OPTION_PROPERTY("alluxio.master.mount.table.root.option.%s", "alluxio\\.master\\.mount\\.table\\.root\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$300()),
        MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS("alluxio.master.tieredstore.global.level%d.alias", "alluxio\\.master\\.tieredstore\\.global\\.level(\\d+)\\.alias"),
        UNDERFS_AZURE_ACCOUNT_KEY("fs.azure.account.key.%s.blob.core.windows.net", "fs\\.azure\\.account\\.key\\.(\\w+)\\.blob\\.core\\.windows\\.net", PropertyCreators.access$400(new Builder("fs.azure.account.key.%s.blob.core.windows.net").setDisplayType(DisplayType.CREDENTIALS))),
        WORKER_TIERED_STORE_LEVEL_ALIAS("alluxio.worker.tieredstore.level%d.alias", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.alias"),
        WORKER_TIERED_STORE_LEVEL_DIRS_PATH("alluxio.worker.tieredstore.level%d.dirs.path", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.path"),
        WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE("alluxio.worker.tieredstore.level%d.dirs.mediumtype", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.mediumtype"),
        WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA("alluxio.worker.tieredstore.level%d.dirs.quota", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.quota"),
        WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO("alluxio.worker.tieredstore.level%d.watermark.high.ratio", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.watermark\\.high\\.ratio"),
        WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO("alluxio.worker.tieredstore.level%d.watermark.low.ratio", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.watermark\\.low\\.ratio"),
        TEST_DEPRECATED_TEMPLATE("alluxio.test.%s.format.deprecated.template", "alluxio\\.test\\.(\\w+)\\.format\\.deprecated\\.template");

        private static final String NESTED_GROUP = "nested";
        private final String mFormat;
        private final Pattern mPattern;
        private BiFunction<String, PropertyKey, PropertyKey> mPropertyCreator = PropertyCreators.access$500();

        private Template(String format, String re) {
            this.mFormat = format;
            this.mPattern = Pattern.compile(re);
        }

        private Template(String format, String re, BiFunction<String, PropertyKey, PropertyKey> propertyCreator) {
            this(format, re);
            this.mPropertyCreator = propertyCreator;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("format", this.mFormat).add("pattern", this.mPattern).toString();
        }

        public PropertyKey format(Object ... params) {
            return new PropertyKey(String.format(this.mFormat, params));
        }

        public boolean matches(String input) {
            Matcher matcher = this.mPattern.matcher(input);
            return matcher.matches();
        }

        public Matcher match(String input) {
            return this.mPattern.matcher(input);
        }

        @Nullable
        private PropertyKey getPropertyKey(String propertyName) {
            Matcher matcher = this.match(propertyName);
            if (!matcher.matches()) {
                return null;
            }
            String nestedKeyName = null;
            try {
                nestedKeyName = matcher.group(NESTED_GROUP);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            PropertyKey nestedProperty = null;
            if (nestedKeyName != null && PropertyKey.isValid(nestedKeyName)) {
                nestedProperty = PropertyKey.fromString(nestedKeyName);
            }
            return this.mPropertyCreator.apply(propertyName, nestedProperty);
        }

        private static class PropertyCreators {
            private static final BiFunction<String, PropertyKey, PropertyKey> DEFAULT_PROPERTY_CREATOR = PropertyCreators.fromBuilder(new Builder(""));
            private static final BiFunction<String, PropertyKey, PropertyKey> NESTED_UFS_PROPERTY_CREATOR = PropertyCreators.createNestedPropertyCreator(Scope.SERVER, ConsistencyCheckLevel.ENFORCE);
            private static final BiFunction<String, PropertyKey, PropertyKey> NESTED_JOURNAL_PROPERTY_CREATOR = PropertyCreators.createNestedPropertyCreator(Scope.MASTER, ConsistencyCheckLevel.ENFORCE);

            private PropertyCreators() {
            }

            private static BiFunction<String, PropertyKey, PropertyKey> fromBuilder(Builder builder) {
                return (name, baseProperty) -> builder.setName((String)name).buildUnregistered();
            }

            private static BiFunction<String, PropertyKey, PropertyKey> createNestedPropertyCreator(Scope scope, ConsistencyCheckLevel consistencyCheckLevel) {
                return (name, baseProperty) -> {
                    Builder builder = new Builder((String)name).setScope(scope).setConsistencyCheckLevel(consistencyCheckLevel);
                    if (baseProperty != null) {
                        builder.setDisplayType(baseProperty.getDisplayType());
                        builder.setDefaultSupplier(baseProperty.getDefaultSupplier());
                    }
                    return builder.buildUnregistered();
                };
            }

            static /* synthetic */ BiFunction access$200() {
                return NESTED_JOURNAL_PROPERTY_CREATOR;
            }

            static /* synthetic */ BiFunction access$300() {
                return NESTED_UFS_PROPERTY_CREATOR;
            }

            static /* synthetic */ BiFunction access$400(Builder x0) {
                return PropertyCreators.fromBuilder(x0);
            }

            static /* synthetic */ BiFunction access$500() {
                return DEFAULT_PROPERTY_CREATOR;
            }
        }
    }

    @ThreadSafe
    public static final class Name {
        public static final String CONF_DIR = "alluxio.conf.dir";
        public static final String CONF_VALIDATION_ENABLED = "alluxio.conf.validation.enabled";
        public static final String DEBUG = "alluxio.debug";
        public static final String EXTENSIONS_DIR = "alluxio.extensions.dir";
        public static final String HOME = "alluxio.home";
        public static final String INTEGRATION_MASTER_RESOURCE_CPU = "alluxio.integration.master.resource.cpu";
        public static final String INTEGRATION_MASTER_RESOURCE_MEM = "alluxio.integration.master.resource.mem";
        public static final String INTEGRATION_MESOS_ALLUXIO_MASTER_NAME = "alluxio.integration.mesos.master.name";
        public static final String INTEGRATION_MESOS_ALLUXIO_MASTER_NODE_COUNT = "alluxio.integration.mesos.master.node.count";
        public static final String INTEGRATION_MESOS_ALLUXIO_WORKER_NAME = "alluxio.integration.mesos.worker.name";
        public static final String INTEGRATION_MESOS_ALLUXIO_JAR_URL = "alluxio.integration.mesos.alluxio.jar.url";
        public static final String INTEGRATION_MESOS_JDK_PATH = "alluxio.integration.mesos.jdk.path";
        public static final String INTEGRATION_MESOS_JDK_URL = "alluxio.integration.mesos.jdk.url";
        public static final String INTEGRATION_MESOS_PRINCIPAL = "alluxio.integration.mesos.principal";
        public static final String INTEGRATION_MESOS_ROLE = "alluxio.integration.mesos.role";
        public static final String INTEGRATION_MESOS_SECRET = "alluxio.integration.mesos.secret";
        public static final String INTEGRATION_MESOS_USER = "alluxio.integration.mesos.user";
        public static final String INTEGRATION_WORKER_RESOURCE_CPU = "alluxio.integration.worker.resource.cpu";
        public static final String INTEGRATION_WORKER_RESOURCE_MEM = "alluxio.integration.worker.resource.mem";
        public static final String INTEGRATION_YARN_WORKERS_PER_HOST_MAX = "alluxio.integration.yarn.workers.per.host.max";
        public static final String LOGGER_TYPE = "alluxio.logger.type";
        public static final String LOGS_DIR = "alluxio.logs.dir";
        public static final String METRICS_CONF_FILE = "alluxio.metrics.conf.file";
        public static final String METRICS_CONTEXT_SHUTDOWN_TIMEOUT = "alluxio.metrics.context.shutdown.timeout";
        public static final String NETWORK_CONNECTION_AUTH_TIMEOUT = "alluxio.network.connection.auth.timeout";
        public static final String NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT = "alluxio.network.connection.health.check.timeout";
        public static final String NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT = "alluxio.network.connection.server.shutdown.timeout";
        public static final String NETWORK_CONNECTION_SHUTDOWN_TIMEOUT = "alluxio.network.connection.shutdown.timeout";
        public static final String NETWORK_HOST_RESOLUTION_TIMEOUT_MS = "alluxio.network.host.resolution.timeout";
        public static final String SITE_CONF_DIR = "alluxio.site.conf.dir";
        public static final String TEST_MODE = "alluxio.test.mode";
        public static final String TMP_DIRS = "alluxio.tmp.dirs";
        public static final String USER_LOGS_DIR = "alluxio.user.logs.dir";
        public static final String VERSION = "alluxio.version";
        public static final String WEB_FILE_INFO_ENABLED = "alluxio.web.file.info.enabled";
        public static final String WEB_RESOURCES = "alluxio.web.resources";
        public static final String WEB_THREADS = "alluxio.web.threads";
        public static final String WEB_CORS_ENABLED = "alluxio.web.cors.enabled";
        public static final String WEB_REFRESH_INTERVAL = "alluxio.web.refresh.interval";
        public static final String WORK_DIR = "alluxio.work.dir";
        public static final String ZOOKEEPER_ADDRESS = "alluxio.zookeeper.address";
        public static final String ZOOKEEPER_CONNECTION_TIMEOUT = "alluxio.zookeeper.connection.timeout";
        public static final String ZOOKEEPER_ELECTION_PATH = "alluxio.zookeeper.election.path";
        public static final String ZOOKEEPER_ENABLED = "alluxio.zookeeper.enabled";
        public static final String ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT = "alluxio.zookeeper.leader.inquiry.retry";
        public static final String ZOOKEEPER_LEADER_PATH = "alluxio.zookeeper.leader.path";
        public static final String ZOOKEEPER_SESSION_TIMEOUT = "alluxio.zookeeper.session.timeout";
        public static final String ZOOKEEPER_AUTH_ENABLED = "alluxio.zookeeper.auth.enabled";
        public static final String ZOOKEEPER_LEADER_CONNECTION_ERROR_POLICY = "alluxio.zookeeper.leader.connection.error.policy";
        public static final String UNDERFS_ALLOW_SET_OWNER_FAILURE = "alluxio.underfs.allow.set.owner.failure";
        public static final String UNDERFS_CLEANUP_ENABLED = "alluxio.underfs.cleanup.enabled";
        public static final String UNDERFS_CLEANUP_INTERVAL = "alluxio.underfs.cleanup.interval";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_BASE_SLEEP_MS = "alluxio.underfs.eventual.consistency.retry.base.sleep";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_NUM = "alluxio.underfs.eventual.consistency.retry.max.num";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_SLEEP_MS = "alluxio.underfs.eventual.consistency.retry.max.sleep";
        public static final String UNDERFS_LISTING_LENGTH = "alluxio.underfs.listing.length";
        public static final String UNDERFS_GCS_DEFAULT_MODE = "alluxio.underfs.gcs.default.mode";
        public static final String UNDERFS_GCS_DIRECTORY_SUFFIX = "alluxio.underfs.gcs.directory.suffix";
        public static final String UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.gcs.owner.id.to.username.mapping";
        public static final String UNDERFS_HDFS_CONFIGURATION = "alluxio.underfs.hdfs.configuration";
        public static final String UNDERFS_HDFS_IMPL = "alluxio.underfs.hdfs.impl";
        public static final String UNDERFS_HDFS_PREFIXES = "alluxio.underfs.hdfs.prefixes";
        public static final String UNDERFS_HDFS_REMOTE = "alluxio.underfs.hdfs.remote";
        public static final String UNDERFS_WEB_HEADER_LAST_MODIFIED = "alluxio.underfs.web.header.last.modified";
        public static final String UNDERFS_WEB_CONNECTION_TIMEOUT = "alluxio.underfs.web.connnection.timeout";
        public static final String UNDERFS_WEB_PARENT_NAMES = "alluxio.underfs.web.parent.names";
        public static final String UNDERFS_WEB_TITLES = "alluxio.underfs.web.titles";
        public static final String UNDERFS_VERSION = "alluxio.underfs.version";
        public static final String UNDERFS_OBJECT_STORE_BREADCRUMBS_ENABLED = "alluxio.underfs.object.store.breadcrumbs.enabled";
        public static final String UNDERFS_OBJECT_STORE_SERVICE_THREADS = "alluxio.underfs.object.store.service.threads";
        public static final String UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY = "alluxio.underfs.object.store.mount.shared.publicly";
        public static final String UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE = "alluxio.underfs.object.store.multi.range.chunk.size";
        public static final String UNDERFS_OSS_CONNECT_MAX = "alluxio.underfs.oss.connection.max";
        public static final String UNDERFS_OSS_CONNECT_TIMEOUT = "alluxio.underfs.oss.connection.timeout";
        public static final String UNDERFS_OSS_CONNECT_TTL = "alluxio.underfs.oss.connection.ttl";
        public static final String UNDERFS_OSS_SOCKET_TIMEOUT = "alluxio.underfs.oss.socket.timeout";
        public static final String UNDERFS_S3_BULK_DELETE_ENABLED = "alluxio.underfs.s3.bulk.delete.enabled";
        public static final String UNDERFS_S3_DEFAULT_MODE = "alluxio.underfs.s3.default.mode";
        public static final String UNDERFS_S3_DIRECTORY_SUFFIX = "alluxio.underfs.s3.directory.suffix";
        public static final String UNDERFS_S3_INHERIT_ACL = "alluxio.underfs.s3.inherit.acl";
        public static final String UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE = "alluxio.underfs.s3.intermediate.upload.clean.age";
        public static final String UNDERFS_S3_LIST_OBJECTS_V1 = "alluxio.underfs.s3.list.objects.v1";
        public static final String UNDERFS_S3_REQUEST_TIMEOUT = "alluxio.underfs.s3.request.timeout";
        public static final String UNDERFS_S3_SECURE_HTTP_ENABLED = "alluxio.underfs.s3.secure.http.enabled";
        public static final String UNDERFS_S3_SERVER_SIDE_ENCRYPTION_ENABLED = "alluxio.underfs.s3.server.side.encryption.enabled";
        public static final String UNDERFS_S3_SIGNER_ALGORITHM = "alluxio.underfs.s3.signer.algorithm";
        public static final String UNDERFS_S3_SOCKET_TIMEOUT = "alluxio.underfs.s3.socket.timeout";
        public static final String UNDERFS_S3_STREAMING_UPLOAD_ENABLED = "alluxio.underfs.s3.streaming.upload.enabled";
        public static final String UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE = "alluxio.underfs.s3.streaming.upload.partition.size";
        public static final String UNDERFS_S3_ADMIN_THREADS_MAX = "alluxio.underfs.s3.admin.threads.max";
        public static final String UNDERFS_S3_DISABLE_DNS_BUCKETS = "alluxio.underfs.s3.disable.dns.buckets";
        public static final String UNDERFS_S3_ENDPOINT = "alluxio.underfs.s3.endpoint";
        public static final String UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.s3.owner.id.to.username.mapping";
        public static final String UNDERFS_S3_PROXY_HOST = "alluxio.underfs.s3.proxy.host";
        public static final String UNDERFS_S3_PROXY_PORT = "alluxio.underfs.s3.proxy.port";
        public static final String UNDERFS_S3_THREADS_MAX = "alluxio.underfs.s3.threads.max";
        public static final String UNDERFS_S3_UPLOAD_THREADS_MAX = "alluxio.underfs.s3.upload.threads.max";
        public static final String KODO_ENDPOINT = "alluxio.underfs.kodo.endpoint";
        public static final String KODO_DOWNLOAD_HOST = "alluxio.underfs.kodo.downloadhost";
        public static final String UNDERFS_KODO_CONNECT_TIMEOUT = "alluxio.underfs.kodo.connect.timeout";
        public static final String UNDERFS_KODO_REQUESTS_MAX = "alluxio.underfs.kodo.requests.max";
        public static final String COS_ACCESS_KEY = "fs.cos.access.key";
        public static final String COS_APP_ID = "fs.cos.app.id";
        public static final String COS_CONNECTION_MAX = "fs.cos.connection.max";
        public static final String COS_CONNECTION_TIMEOUT = "fs.cos.connection.timeout";
        public static final String COS_REGION = "fs.cos.region";
        public static final String COS_SECRET_KEY = "fs.cos.secret.key";
        public static final String COS_SOCKET_TIMEOUT = "fs.cos.socket.timeout";
        public static final String GCS_ACCESS_KEY = "fs.gcs.accessKeyId";
        public static final String GCS_SECRET_KEY = "fs.gcs.secretAccessKey";
        public static final String OSS_ACCESS_KEY = "fs.oss.accessKeyId";
        public static final String OSS_ENDPOINT_KEY = "fs.oss.endpoint";
        public static final String OSS_SECRET_KEY = "fs.oss.accessKeySecret";
        public static final String S3A_ACCESS_KEY = "aws.accessKeyId";
        public static final String S3A_SECRET_KEY = "aws.secretKey";
        public static final String SWIFT_AUTH_METHOD_KEY = "fs.swift.auth.method";
        public static final String SWIFT_AUTH_URL_KEY = "fs.swift.auth.url";
        public static final String SWIFT_PASSWORD_KEY = "fs.swift.password";
        public static final String SWIFT_REGION_KEY = "fs.swift.region";
        public static final String SWIFT_SIMULATION = "fs.swift.simulation";
        public static final String SWIFT_TENANT_KEY = "fs.swift.tenant";
        public static final String SWIFT_USER_KEY = "fs.swift.user";
        public static final String KODO_ACCESS_KEY = "fs.kodo.accesskey";
        public static final String KODO_SECRET_KEY = "fs.kodo.secretkey";
        public static final String MASTER_AUDIT_LOGGING_ENABLED = "alluxio.master.audit.logging.enabled";
        public static final String MASTER_AUDIT_LOGGING_QUEUE_CAPACITY = "alluxio.master.audit.logging.queue.capacity";
        public static final String MASTER_BACKUP_DIRECTORY = "alluxio.master.backup.directory";
        public static final String MASTER_BACKUP_ENTRY_BUFFER_COUNT = "alluxio.master.backup.entry.buffer.count";
        public static final String MASTER_BIND_HOST = "alluxio.master.bind.host";
        public static final String MASTER_CLUSTER_METRICS_UPDATE_INTERVAL = "alluxio.master.cluster.metrics.update.interval";
        public static final String MASTER_DAILY_BACKUP_ENABLED = "alluxio.master.daily.backup.enabled";
        public static final String MASTER_DAILY_BACKUP_FILES_RETAINED = "alluxio.master.daily.backup.files.retained";
        public static final String MASTER_DAILY_BACKUP_TIME = "alluxio.master.daily.backup.time";
        public static final String MASTER_FILE_ACCESS_TIME_JOURNAL_FLUSH_INTERVAL = "alluxio.master.file.access.time.journal.flush.interval";
        public static final String MASTER_FILE_ACCESS_TIME_UPDATE_PRECISION = "alluxio.master.file.access.time.update.precision";
        public static final String MASTER_FILE_ACCESS_TIME_UPDATER_SHUTDOWN_TIMEOUT = "alluxio.master.file.access.time.updater.shutdown.timeout";
        public static final String MASTER_FORMAT_FILE_PREFIX = "alluxio.master.format.file.prefix";
        public static final String MASTER_STANDBY_HEARTBEAT_INTERVAL = "alluxio.master.standby.heartbeat.interval";
        public static final String MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL = "alluxio.master.lost.worker.file.detection.interval";
        public static final String MASTER_HEARTBEAT_TIMEOUT = "alluxio.master.heartbeat.timeout";
        public static final String MASTER_HOSTNAME = "alluxio.master.hostname";
        public static final String MASTER_LOCK_POOL_INITSIZE = "alluxio.master.lock.pool.initsize";
        public static final String MASTER_LOCK_POOL_LOW_WATERMARK = "alluxio.master.lock.pool.low.watermark";
        public static final String MASTER_LOCK_POOL_HIGH_WATERMARK = "alluxio.master.lock.pool.high.watermark";
        public static final String MASTER_LOCK_POOL_CONCURRENCY_LEVEL = "alluxio.master.lock.pool.concurrency.level";
        public static final String MASTER_JOURNAL_FLUSH_BATCH_TIME_MS = "alluxio.master.journal.flush.batch.time";
        public static final String MASTER_JOURNAL_FLUSH_TIMEOUT_MS = "alluxio.master.journal.flush.timeout";
        public static final String MASTER_JOURNAL_FLUSH_RETRY_INTERVAL = "alluxio.master.journal.retry.interval";
        public static final String MASTER_JOURNAL_FOLDER = "alluxio.master.journal.folder";
        public static final String MASTER_JOURNAL_INIT_FROM_BACKUP = "alluxio.master.journal.init.from.backup";
        public static final String MASTER_JOURNAL_TOLERATE_CORRUPTION = "alluxio.master.journal.tolerate.corruption";
        public static final String MASTER_JOURNAL_TYPE = "alluxio.master.journal.type";
        public static final String MASTER_JOURNAL_LOG_SIZE_BYTES_MAX = "alluxio.master.journal.log.size.bytes.max";
        public static final String MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS = "alluxio.master.journal.tailer.shutdown.quiet.wait.time";
        public static final String MASTER_JOURNAL_TAILER_SLEEP_TIME_MS = "alluxio.master.journal.tailer.sleep.time";
        public static final String MASTER_RPC_ADDRESSES = "alluxio.master.rpc.addresses";
        public static final String MASTER_EMBEDDED_JOURNAL_ADDRESSES = "alluxio.master.embedded.journal.addresses";
        public static final String MASTER_EMBEDDED_JOURNAL_ELECTION_TIMEOUT = "alluxio.master.embedded.journal.election.timeout";
        public static final String MASTER_EMBEDDED_JOURNAL_APPENDER_BATCH_SIZE = "alluxio.master.embedded.journal.appender.batch.size";
        public static final String MASTER_EMBEDDED_JOURNAL_HEARTBEAT_INTERVAL = "alluxio.master.embedded.journal.heartbeat.interval";
        public static final String MASTER_EMBEDDED_JOURNAL_PORT = "alluxio.master.embedded.journal.port";
        public static final String MASTER_EMBEDDED_JOURNAL_STORAGE_LEVEL = "alluxio.master.embedded.journal.storage.level";
        public static final String MASTER_EMBEDDED_JOURNAL_SHUTDOWN_TIMEOUT = "alluxio.master.embedded.journal.shutdown.timeout";
        public static final String MASTER_EMBEDDED_JOURNAL_WRITE_TIMEOUT = "alluxio.master.embedded.journal.write.timeout";
        public static final String MASTER_EMBEDDED_JOURNAL_TRIGGERED_SNAPSHOT_WAIT_TIMEOUT = "alluxio.master.embedded.journal.triggered.snapshot.wait.timeout";
        public static final String MASTER_EMBEDDED_JOURNAL_TRANSPORT_REQUEST_TIMEOUT_MS = "alluxio.master.embedded.journal.transport.request.timeout.ms";
        public static final String MASTER_EMBEDDED_JOURNAL_TRANSPORT_MAX_INBOUND_MESSAGE_SIZE = "alluxio.master.embedded.journal.transport.max.inbound.message.size";
        public static final String MASTER_KEYTAB_KEY_FILE = "alluxio.master.keytab.file";
        public static final String MASTER_METASTORE = "alluxio.master.metastore";
        public static final String MASTER_METASTORE_DIR = "alluxio.master.metastore.dir";
        public static final String MASTER_METASTORE_INODE_CACHE_EVICT_BATCH_SIZE = "alluxio.master.metastore.inode.cache.evict.batch.size";
        public static final String MASTER_METASTORE_INODE_CACHE_HIGH_WATER_MARK_RATIO = "alluxio.master.metastore.inode.cache.high.water.mark.ratio";
        public static final String MASTER_METASTORE_INODE_CACHE_LOW_WATER_MARK_RATIO = "alluxio.master.metastore.inode.cache.low.water.mark.ratio";
        public static final String MASTER_METASTORE_INODE_CACHE_MAX_SIZE = "alluxio.master.metastore.inode.cache.max.size";
        public static final String MASTER_METASTORE_INODE_ITERATION_CRAWLER_COUNT = "alluxio.master.metastore.inode.iteration.crawler.count";
        public static final String MASTER_METASTORE_INODE_ENUMERATOR_BUFFER_COUNT = "alluxio.master.metastore.inode.enumerator.buffer.count";
        public static final String MASTER_METASTORE_INODE_INHERIT_OWNER_AND_GROUP = "alluxio.master.metastore.inode.inherit.owner.and.group";
        public static final String MASTER_PERSISTENCE_CHECKER_INTERVAL_MS = "alluxio.master.persistence.checker.interval";
        public static final String MASTER_METRICS_SERVICE_THREADS = "alluxio.master.metrics.service.threads";
        public static final String MASTER_METRICS_TIME_SERIES_INTERVAL = "alluxio.master.metrics.time.series.interval";
        public static final String MASTER_PERSISTENCE_INITIAL_INTERVAL_MS = "alluxio.master.persistence.initial.interval";
        public static final String MASTER_PERSISTENCE_MAX_TOTAL_WAIT_TIME_MS = "alluxio.master.persistence.max.total.wait.time";
        public static final String MASTER_PERSISTENCE_MAX_INTERVAL_MS = "alluxio.master.persistence.max.interval";
        public static final String MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS = "alluxio.master.persistence.scheduler.interval";
        public static final String MASTER_PERSISTENCE_BLACKLIST = "alluxio.master.persistence.blacklist";
        public static final String MASTER_LOG_CONFIG_REPORT_HEARTBEAT_INTERVAL = "alluxio.master.log.config.report.heartbeat.interval";
        public static final String MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_REPAIR = "alluxio.master.periodic.block.integrity.check.repair";
        public static final String MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_INTERVAL = "alluxio.master.periodic.block.integrity.check.interval";
        public static final String MASTER_PRINCIPAL = "alluxio.master.principal";
        public static final String MASTER_REPLICATION_CHECK_INTERVAL_MS = "alluxio.master.replication.check.interval";
        public static final String MASTER_RPC_PORT = "alluxio.master.rpc.port";
        public static final String MASTER_RPC_EXECUTOR_PARALLELISM = "alluxio.master.rpc.executor.parallelism";
        public static final String MASTER_RPC_EXECUTOR_MIN_RUNNABLE = "alluxio.master.rpc.executor.min.runnable";
        public static final String MASTER_RPC_EXECUTOR_CORE_POOL_SIZE = "alluxio.master.rpc.executor.core.pool.size";
        public static final String MASTER_RPC_EXECUTOR_MAX_POOL_SIZE = "alluxio.master.rpc.executor.max.pool.size";
        public static final String MASTER_RPC_EXECUTOR_KEEPALIVE = "alluxio.master.rpc.executor.keepalive";
        public static final String MASTER_SERVING_THREAD_TIMEOUT = "alluxio.master.serving.thread.timeout";
        public static final String MASTER_SKIP_ROOT_ACL_CHECK = "alluxio.master.skip.root.acl.check";
        public static final String MASTER_STARTUP_BLOCK_INTEGRITY_CHECK_ENABLED = "alluxio.master.startup.block.integrity.check.enabled";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS = "alluxio.master.tieredstore.global.level0.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS = "alluxio.master.tieredstore.global.level1.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS = "alluxio.master.tieredstore.global.level2.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVELS = "alluxio.master.tieredstore.global.levels";
        public static final String MASTER_TIERED_STORE_GLOBAL_MEDIUMTYPE = "alluxio.master.tieredstore.global.mediumtype";
        public static final String MASTER_TTL_CHECKER_INTERVAL_MS = "alluxio.master.ttl.checker.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_INTERVAL = "alluxio.master.ufs.active.sync.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_MAX_ACTIVITIES = "alluxio.master.ufs.active.sync.max.activities";
        public static final String MASTER_UFS_ACTIVE_SYNC_THREAD_POOL_SIZE = "alluxio.master.ufs.active.sync.thread.pool.size";
        public static final String MASTER_UFS_ACTIVE_SYNC_POLL_TIMEOUT = "alluxio.master.ufs.active.sync.poll.timeout";
        public static final String MASTER_UFS_ACTIVE_SYNC_EVENT_RATE_INTERVAL = "alluxio.master.ufs.active.sync.event.rate.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_MAX_AGE = "alluxio.master.ufs.active.sync.max.age";
        public static final String MASTER_UFS_ACTIVE_SYNC_INITIAL_SYNC_ENABLED = "alluxio.master.ufs.active.sync.initial.sync.enabled";
        public static final String MASTER_UFS_BLOCK_LOCATION_CACHE_CAPACITY = "alluxio.master.ufs.block.location.cache.capacity";
        public static final String MASTER_UFS_MANAGED_BLOCKING_ENABLED = "alluxio.master.ufs.managed.blocking.enabled";
        public static final String MASTER_UFS_PATH_CACHE_CAPACITY = "alluxio.master.ufs.path.cache.capacity";
        public static final String MASTER_UFS_PATH_CACHE_THREADS = "alluxio.master.ufs.path.cache.threads";
        public static final String MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED = "alluxio.master.unsafe.direct.persist.object.enabled";
        public static final String MASTER_UPDATE_CHECK_ENABLED = "alluxio.master.update.check.enabled";
        public static final String MASTER_WEB_BIND_HOST = "alluxio.master.web.bind.host";
        public static final String MASTER_WEB_HOSTNAME = "alluxio.master.web.hostname";
        public static final String MASTER_WEB_PORT = "alluxio.master.web.port";
        public static final String MASTER_WHITELIST = "alluxio.master.whitelist";
        public static final String MASTER_WORKER_CONNECT_WAIT_TIME = "alluxio.master.worker.connect.wait.time";
        public static final String MASTER_WORKER_TIMEOUT_MS = "alluxio.master.worker.timeout";
        public static final String MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES = "alluxio.master.journal.checkpoint.period.entries";
        public static final String MASTER_JOURNAL_GC_PERIOD_MS = "alluxio.master.journal.gc.period";
        public static final String MASTER_JOURNAL_GC_THRESHOLD_MS = "alluxio.master.journal.gc.threshold";
        public static final String MASTER_JOURNAL_TEMPORARY_FILE_GC_THRESHOLD_MS = "alluxio.master.journal.temporary.file.gc.threshold";
        public static final String MASTER_FILE_SYSTEM_LISTSTATUS_RESULTS_PER_MESSAGE = "alluxio.master.filesystem.liststatus.result.message.length";
        public static final String SECONDARY_MASTER_METASTORE_DIR = "alluxio.secondary.master.metastore.dir";
        public static final String WORKER_ALLOCATOR_CLASS = "alluxio.worker.allocator.class";
        public static final String WORKER_BIND_HOST = "alluxio.worker.bind.host";
        public static final String WORKER_BLOCK_HEARTBEAT_INTERVAL_MS = "alluxio.worker.block.heartbeat.interval";
        public static final String WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS = "alluxio.worker.block.heartbeat.timeout";
        public static final String WORKER_DATA_FOLDER = "alluxio.worker.data.folder";
        public static final String WORKER_DATA_FOLDER_PERMISSIONS = "alluxio.worker.data.folder.permissions";
        public static final String WORKER_DATA_SERVER_CLASS = "alluxio.worker.data.server.class";
        public static final String WORKER_DATA_SERVER_DOMAIN_SOCKET_ADDRESS = "alluxio.worker.data.server.domain.socket.address";
        public static final String WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID = "alluxio.worker.data.server.domain.socket.as.uuid";
        public static final String WORKER_DATA_TMP_FOLDER = "alluxio.worker.data.folder.tmp";
        public static final String WORKER_DATA_TMP_SUBDIR_MAX = "alluxio.worker.data.tmp.subdir.max";
        public static final String WORKER_EVICTOR_CLASS = "alluxio.worker.evictor.class";
        public static final String WORKER_EVICTOR_LRFU_ATTENUATION_FACTOR = "alluxio.worker.evictor.lrfu.attenuation.factor";
        public static final String WORKER_EVICTOR_LRFU_STEP_FACTOR = "alluxio.worker.evictor.lrfu.step.factor";
        public static final String WORKER_FILESYSTEM_HEARTBEAT_INTERVAL_MS = "alluxio.worker.filesystem.heartbeat.interval";
        public static final String WORKER_FILE_PERSIST_POOL_SIZE = "alluxio.worker.file.persist.pool.size";
        public static final String WORKER_FILE_PERSIST_RATE_LIMIT = "alluxio.worker.file.persist.rate.limit";
        public static final String WORKER_FILE_PERSIST_RATE_LIMIT_ENABLED = "alluxio.worker.file.persist.rate.limit.enabled";
        public static final String WORKER_FILE_BUFFER_SIZE = "alluxio.worker.file.buffer.size";
        public static final String WORKER_FREE_SPACE_TIMEOUT = "alluxio.worker.free.space.timeout";
        public static final String WORKER_HOSTNAME = "alluxio.worker.hostname";
        public static final String WORKER_KEYTAB_FILE = "alluxio.worker.keytab.file";
        public static final String WORKER_MASTER_CONNECT_RETRY_TIMEOUT = "alluxio.worker.master.connect.retry.timeout";
        public static final String WORKER_MEMORY_SIZE = "alluxio.worker.memory.size";
        public static final String WORKER_NETWORK_ASYNC_CACHE_MANAGER_THREADS_MAX = "alluxio.worker.network.async.cache.manager.threads.max";
        public static final String WORKER_NETWORK_BLOCK_READER_THREADS_MAX = "alluxio.worker.network.block.reader.threads.max";
        public static final String WORKER_NETWORK_BLOCK_WRITER_THREADS_MAX = "alluxio.worker.network.block.writer.threads.max";
        public static final String WORKER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = "alluxio.worker.network.writer.buffer.size.messages";
        public static final String WORKER_NETWORK_FLOWCONTROL_WINDOW = "alluxio.worker.network.flowcontrol.window";
        public static final String WORKER_NETWORK_KEEPALIVE_TIME_MS = "alluxio.worker.network.keepalive.time";
        public static final String WORKER_NETWORK_KEEPALIVE_TIMEOUT_MS = "alluxio.worker.network.keepalive.timeout";
        public static final String WORKER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = "alluxio.worker.network.max.inbound.message.size";
        public static final String WORKER_NETWORK_NETTY_BOSS_THREADS = "alluxio.worker.network.netty.boss.threads";
        public static final String WORKER_NETWORK_NETTY_CHANNEL = "alluxio.worker.network.netty.channel";
        public static final String WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD = "alluxio.worker.network.netty.shutdown.quiet.period";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_HIGH = "alluxio.worker.network.netty.watermark.high";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_LOW = "alluxio.worker.network.netty.watermark.low";
        public static final String WORKER_NETWORK_NETTY_WORKER_THREADS = "alluxio.worker.network.netty.worker.threads";
        public static final String WORKER_NETWORK_READER_BUFFER_SIZE_BYTES = "alluxio.worker.network.reader.buffer.size";
        public static final String WORKER_NETWORK_READER_MAX_CHUNK_SIZE_BYTES = "alluxio.worker.network.reader.max.chunk.size.bytes";
        public static final String WORKER_NETWORK_SHUTDOWN_TIMEOUT = "alluxio.worker.network.shutdown.timeout";
        public static final String WORKER_NETWORK_ZEROCOPY_ENABLED = "alluxio.worker.network.zerocopy.enabled";
        public static final String WORKER_BLOCK_MASTER_CLIENT_POOL_SIZE = "alluxio.worker.block.master.client.pool.size";
        public static final String WORKER_PRINCIPAL = "alluxio.worker.principal";
        public static final String WORKER_RPC_PORT = "alluxio.worker.rpc.port";
        public static final String WORKER_SESSION_TIMEOUT_MS = "alluxio.worker.session.timeout";
        public static final String WORKER_STORAGE_CHECKER_ENABLED = "alluxio.worker.storage.checker.enabled";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCK_READERS = "alluxio.worker.tieredstore.block.lock.readers";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCKS = "alluxio.worker.tieredstore.block.locks";
        public static final String WORKER_TIERED_STORE_LEVELS = "alluxio.worker.tieredstore.levels";
        public static final String WORKER_TIERED_STORE_RESERVER_INTERVAL_MS = "alluxio.worker.tieredstore.reserver.interval";
        public static final String WORKER_WEB_BIND_HOST = "alluxio.worker.web.bind.host";
        public static final String WORKER_WEB_HOSTNAME = "alluxio.worker.web.hostname";
        public static final String WORKER_WEB_PORT = "alluxio.worker.web.port";
        public static final String WORKER_UFS_BLOCK_OPEN_TIMEOUT_MS = "alluxio.worker.ufs.block.open.timeout";
        public static final String WORKER_UFS_INSTREAM_CACHE_EXPIRATION_TIME = "alluxio.worker.ufs.instream.cache.expiration.time";
        public static final String WORKER_UFS_INSTREAM_CACHE_ENABLED = "alluxio.worker.ufs.instream.cache.enabled";
        public static final String WORKER_UFS_INSTREAM_CACHE_MAX_SIZE = "alluxio.worker.ufs.instream.cache.max.size";
        public static final String PROXY_S3_WRITE_TYPE = "alluxio.proxy.s3.writetype";
        public static final String PROXY_S3_DELETE_TYPE = "alluxio.proxy.s3.deletetype";
        public static final String PROXY_S3_MULTIPART_TEMPORARY_DIR_SUFFIX = "alluxio.proxy.s3.multipart.temporary.dir.suffix";
        public static final String PROXY_STREAM_CACHE_TIMEOUT_MS = "alluxio.proxy.stream.cache.timeout";
        public static final String PROXY_WEB_BIND_HOST = "alluxio.proxy.web.bind.host";
        public static final String PROXY_WEB_HOSTNAME = "alluxio.proxy.web.hostname";
        public static final String PROXY_WEB_PORT = "alluxio.proxy.web.port";
        public static final String LOCALITY_ORDER = "alluxio.locality.order";
        public static final String LOCALITY_SCRIPT = "alluxio.locality.script";
        public static final String LOCALITY_COMPARE_NODE_IP = "alluxio.locality.compare.node.ip";
        public static final String LOGSERVER_HOSTNAME = "alluxio.logserver.hostname";
        public static final String LOGSERVER_LOGS_DIR = "alluxio.logserver.logs.dir";
        public static final String LOGSERVER_PORT = "alluxio.logserver.port";
        public static final String LOGSERVER_THREADS_MAX = "alluxio.logserver.threads.max";
        public static final String LOGSERVER_THREADS_MIN = "alluxio.logserver.threads.min";
        public static final String USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES = "alluxio.user.block.avoid.eviction.policy.reserved.size.bytes";
        public static final String USER_BLOCK_MASTER_CLIENT_THREADS = "alluxio.user.block.master.client.threads";
        public static final String USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES = "alluxio.user.block.remote.read.buffer.size.bytes";
        public static final String USER_BLOCK_SIZE_BYTES_DEFAULT = "alluxio.user.block.size.bytes.default";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.block.worker.client.pool.gc.threshold";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_SIZE = "alluxio.user.block.worker.client.pool.size";
        public static final String USER_BLOCK_WORKER_CLIENT_READ_RETRY = "alluxio.user.block.worker.client.read.retry";
        public static final String USER_BLOCK_WRITE_LOCATION_POLICY = "alluxio.user.block.write.location.policy.class";
        public static final String USER_CONF_CLUSTER_DEFAULT_ENABLED = "alluxio.user.conf.cluster.default.enabled";
        public static final String USER_CONF_SYNC_INTERVAL = "alluxio.user.conf.sync.interval";
        public static final String USER_DATE_FORMAT_PATTERN = "alluxio.user.date.format.pattern";
        public static final String USER_FILE_BUFFER_BYTES = "alluxio.user.file.buffer.bytes";
        public static final String USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY = "alluxio.user.file.copyfromlocal.block.location.policy.class";
        public static final String USER_FILE_DELETE_UNCHECKED = "alluxio.user.file.delete.unchecked";
        public static final String USER_FILE_MASTER_CLIENT_THREADS = "alluxio.user.file.master.client.threads";
        public static final String USER_FILE_METADATA_LOAD_TYPE = "alluxio.user.file.metadata.load.type";
        public static final String USER_FILE_METADATA_SYNC_INTERVAL = "alluxio.user.file.metadata.sync.interval";
        public static final String USER_FILE_PASSIVE_CACHE_ENABLED = "alluxio.user.file.passive.cache.enabled";
        public static final String USER_FILE_READ_TYPE_DEFAULT = "alluxio.user.file.readtype.default";
        public static final String USER_FILE_PERSIST_ON_RENAME = "alluxio.user.file.persist.on.rename";
        public static final String USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME = "alluxio.user.file.persistence.initial.wait.time";
        public static final String USER_FILE_REPLICATION_MAX = "alluxio.user.file.replication.max";
        public static final String USER_FILE_REPLICATION_MIN = "alluxio.user.file.replication.min";
        public static final String USER_FILE_REPLICATION_DURABLE = "alluxio.user.file.replication.durable";
        public static final String USER_FILE_UFS_TIER_ENABLED = "alluxio.user.file.ufs.tier.enabled";
        public static final String USER_FILE_WAITCOMPLETED_POLL_MS = "alluxio.user.file.waitcompleted.poll";
        public static final String USER_FILE_CREATE_TTL = "alluxio.user.file.create.ttl";
        public static final String USER_FILE_CREATE_TTL_ACTION = "alluxio.user.file.create.ttl.action";
        public static final String USER_FILE_WRITE_TYPE_DEFAULT = "alluxio.user.file.writetype.default";
        public static final String USER_FILE_WRITE_TIER_DEFAULT = "alluxio.user.file.write.tier.default";
        public static final String USER_HOSTNAME = "alluxio.user.hostname";
        public static final String USER_LOCAL_READER_CHUNK_SIZE_BYTES = "alluxio.user.local.reader.chunk.size.bytes";
        public static final String USER_LOCAL_WRITER_CHUNK_SIZE_BYTES = "alluxio.user.local.writer.chunk.size.bytes";
        public static final String USER_METRICS_COLLECTION_ENABLED = "alluxio.user.metrics.collection.enabled";
        public static final String USER_METRICS_HEARTBEAT_INTERVAL_MS = "alluxio.user.metrics.heartbeat.interval";
        public static final String USER_APP_ID = "alluxio.user.app.id";
        public static final String USER_NETWORK_DATA_TIMEOUT_MS = "alluxio.user.network.data.timeout";
        public static final String USER_NETWORK_FLOWCONTROL_WINDOW = "alluxio.user.network.flowcontrol.window";
        public static final String USER_NETWORK_KEEPALIVE_TIME_MS = "alluxio.user.network.keepalive.time";
        public static final String USER_NETWORK_KEEPALIVE_TIMEOUT_MS = "alluxio.user.network.keepalive.timeout";
        public static final String USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = "alluxio.user.network.max.inbound.message.size";
        public static final String USER_NETWORK_NETTY_CHANNEL = "alluxio.user.network.netty.channel";
        public static final String USER_NETWORK_NETTY_WORKER_THREADS = "alluxio.user.network.netty.worker.threads";
        public static final String USER_NETWORK_READER_BUFFER_SIZE_MESSAGES = "alluxio.user.network.reader.buffer.size.messages";
        public static final String USER_NETWORK_READER_CHUNK_SIZE_BYTES = "alluxio.user.network.reader.chunk.size.bytes";
        public static final String USER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = "alluxio.user.network.writer.buffer.size.messages";
        public static final String USER_NETWORK_WRITER_CHUNK_SIZE_BYTES = "alluxio.user.network.writer.chunk.size.bytes";
        public static final String USER_NETWORK_WRITER_CLOSE_TIMEOUT_MS = "alluxio.user.network.writer.close.timeout";
        public static final String USER_NETWORK_WRITER_FLUSH_TIMEOUT = "alluxio.user.network.writer.flush.timeout";
        public static final String USER_NETWORK_ZEROCOPY_ENABLED = "alluxio.user.network.zerocopy.enabled";
        public static final String USER_RPC_RETRY_BASE_SLEEP_MS = "alluxio.user.rpc.retry.base.sleep";
        public static final String USER_RPC_RETRY_MAX_DURATION = "alluxio.user.rpc.retry.max.duration";
        public static final String USER_RPC_RETRY_MAX_SLEEP_MS = "alluxio.user.rpc.retry.max.sleep";
        public static final String USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED = "alluxio.user.ufs.block.location.all.fallback.enabled";
        public static final String USER_UFS_BLOCK_READ_LOCATION_POLICY = "alluxio.user.ufs.block.read.location.policy";
        public static final String USER_UFS_BLOCK_READ_LOCATION_POLICY_DETERMINISTIC_HASH_SHARDS = "alluxio.user.ufs.block.read.location.policy.deterministic.hash.shards";
        public static final String USER_UFS_BLOCK_READ_CONCURRENCY_MAX = "alluxio.user.ufs.block.read.concurrency.max";
        public static final String USER_SHORT_CIRCUIT_ENABLED = "alluxio.user.short.circuit.enabled";
        public static final String USER_WORKER_LIST_REFRESH_INTERVAL = "alluxio.user.worker.list.refresh.interval";
        public static final String USER_METADATA_CACHE_ENABLED = "alluxio.user.metadata.cache.enabled";
        public static final String USER_METADATA_CACHE_MAX_SIZE = "alluxio.user.metadata.cache.max.size";
        public static final String USER_METADATA_CACHE_EXPIRATION_TIME = "alluxio.user.metadata.cache.expiration.time";
        public static final String FUSE_CACHED_PATHS_MAX = "alluxio.fuse.cached.paths.max";
        public static final String FUSE_DEBUG_ENABLED = "alluxio.fuse.debug.enabled";
        public static final String FUSE_FS_NAME = "alluxio.fuse.fs.name";
        public static final String FUSE_MAXWRITE_BYTES = "alluxio.fuse.maxwrite.bytes";
        public static final String FUSE_USER_GROUP_TRANSLATION_ENABLED = "alluxio.fuse.user.group.translation.enabled";
        public static final String SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS = "alluxio.security.authentication.custom.provider.class";
        public static final String SECURITY_AUTHENTICATION_TYPE = "alluxio.security.authentication.type";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_ENABLED = "alluxio.security.authorization.permission.enabled";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP = "alluxio.security.authorization.permission.supergroup";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_UMASK = "alluxio.security.authorization.permission.umask";
        public static final String SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS = "alluxio.security.group.mapping.cache.timeout";
        public static final String SECURITY_GROUP_MAPPING_CLASS = "alluxio.security.group.mapping.class";
        public static final String SECURITY_LOGIN_IMPERSONATION_USERNAME = "alluxio.security.login.impersonation.username";
        public static final String SECURITY_LOGIN_USERNAME = "alluxio.security.login.username";
        public static final String AUTHENTICATION_INACTIVE_CHANNEL_REAUTHENTICATE_PERIOD = "alluxio.security.stale.channel.purge.interval";
        public static final String JOB_MASTER_CLIENT_THREADS = "alluxio.job.master.client.threads";
        public static final String JOB_MASTER_FINISHED_JOB_PURGE_COUNT = "alluxio.job.master.finished.job.purge.count";
        public static final String JOB_MASTER_FINISHED_JOB_RETENTION_TIME = "alluxio.job.master.finished.job.retention.time";
        public static final String JOB_MASTER_JOB_CAPACITY = "alluxio.job.master.job.capacity";
        public static final String JOB_MASTER_WORKER_HEARTBEAT_INTERVAL = "alluxio.job.master.worker.heartbeat.interval";
        public static final String JOB_MASTER_WORKER_TIMEOUT = "alluxio.job.master.worker.timeout";
        public static final String JOB_MASTER_BIND_HOST = "alluxio.job.master.bind.host";
        public static final String JOB_MASTER_HOSTNAME = "alluxio.job.master.hostname";
        public static final String JOB_MASTER_LOST_WORKER_INTERVAL = "alluxio.job.master.lost.worker.interval";
        public static final String JOB_MASTER_RPC_PORT = "alluxio.job.master.rpc.port";
        public static final String JOB_MASTER_WEB_BIND_HOST = "alluxio.job.master.web.bind.host";
        public static final String JOB_MASTER_WEB_HOSTNAME = "alluxio.job.master.web.hostname";
        public static final String JOB_MASTER_WEB_PORT = "alluxio.job.master.web.port";
        public static final String JOB_MASTER_RPC_ADDRESSES = "alluxio.job.master.rpc.addresses";
        public static final String JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES = "alluxio.job.master.embedded.journal.addresses";
        public static final String JOB_MASTER_EMBEDDED_JOURNAL_PORT = "alluxio.job.master.embedded.journal.port";
        public static final String JOB_WORKER_BIND_HOST = "alluxio.job.worker.bind.host";
        public static final String JOB_WORKER_DATA_PORT = "alluxio.job.worker.data.port";
        public static final String JOB_WORKER_HOSTNAME = "alluxio.job.worker.hostname";
        public static final String JOB_WORKER_RPC_PORT = "alluxio.job.worker.rpc.port";
        public static final String JOB_WORKER_THREADPOOL_SIZE = "alluxio.job.worker.threadpool.size";
        public static final String JOB_WORKER_WEB_BIND_HOST = "alluxio.job.worker.web.bind.host";
        public static final String JOB_WORKER_WEB_PORT = "alluxio.job.worker.web.port";
        public static final String ZOOKEEPER_JOB_ELECTION_PATH = "alluxio.zookeeper.job.election.path";
        public static final String ZOOKEEPER_JOB_LEADER_PATH = "alluxio.zookeeper.job.leader.path";
        public static final String JVM_MONITOR_WARN_THRESHOLD_MS = "alluxio.jvm.monitor.warn.threshold";
        public static final String JVM_MONITOR_INFO_THRESHOLD_MS = "alluxio.jvm.monitor.info.threshold";
        public static final String JVM_MONITOR_SLEEP_INTERVAL_MS = "alluxio.jvm.monitor.sleep.interval";
        public static final String MASTER_JVM_MONITOR_ENABLED = "alluxio.master.jvm.monitor.enabled";
        public static final String WORKER_JVM_MONITOR_ENABLED = "alluxio.worker.jvm.monitor.enabled";
        public static final String TABLE_ENABLED = "alluxio.table.enabled";
        public static final String TABLE_CATALOG_PATH = "alluxio.table.catalog.path";
        public static final String TABLE_TRANSFORM_MANAGER_JOB_MONITOR_INTERVAL = "alluxio.table.transform.manager.job.monitor.interval";
        public static final String TABLE_TRANSFORM_MANAGER_JOB_HISTORY_RETENTION_TIME = "alluxio.table.transform.manager.job.history.retention.time";

        private Name() {
        }
    }

    public static final class Builder {
        private String[] mAlias;
        private DefaultSupplier mDefaultSupplier;
        private Object mDefaultValue;
        private String mDescription;
        private String mName;
        private boolean mIgnoredSiteProperty;
        private boolean mIsBuiltIn = true;
        private boolean mIsHidden;
        private ConsistencyCheckLevel mConsistencyCheckLevel = ConsistencyCheckLevel.IGNORE;
        private Scope mScope = Scope.ALL;
        private DisplayType mDisplayType = DisplayType.DEFAULT;

        public Builder(String name) {
            this.mName = name;
        }

        public Builder(Template template, Object ... params) {
            this.mName = String.format(template.mFormat, params);
        }

        public Builder setAlias(String ... aliases) {
            this.mAlias = Arrays.copyOf(aliases, aliases.length);
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDefaultSupplier(DefaultSupplier defaultSupplier) {
            this.mDefaultSupplier = defaultSupplier;
            return this;
        }

        public Builder setDefaultSupplier(Supplier<Object> supplier, String description) {
            this.mDefaultSupplier = new DefaultSupplier(supplier, description);
            return this;
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.mDefaultValue = defaultValue;
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setIsBuiltIn(boolean isBuiltIn) {
            this.mIsBuiltIn = isBuiltIn;
            return this;
        }

        public Builder setIsHidden(boolean isHidden) {
            this.mIsHidden = isHidden;
            return this;
        }

        public Builder setIgnoredSiteProperty(boolean ignoredSiteProperty) {
            this.mIgnoredSiteProperty = ignoredSiteProperty;
            return this;
        }

        public Builder setConsistencyCheckLevel(ConsistencyCheckLevel consistencyCheckLevel) {
            this.mConsistencyCheckLevel = consistencyCheckLevel;
            return this;
        }

        public Builder setScope(Scope scope) {
            this.mScope = scope;
            return this;
        }

        public Builder setDisplayType(DisplayType displayType) {
            this.mDisplayType = displayType;
            return this;
        }

        public PropertyKey build() {
            PropertyKey key = this.buildUnregistered();
            Preconditions.checkState(PropertyKey.register(key), "Cannot register existing key \"%s\"", (Object)this.mName);
            return key;
        }

        public PropertyKey buildUnregistered() {
            DefaultSupplier defaultSupplier = this.mDefaultSupplier;
            if (defaultSupplier == null) {
                String defaultString = String.valueOf(this.mDefaultValue);
                defaultSupplier = this.mDefaultValue == null ? new DefaultSupplier(() -> null, "null") : new DefaultSupplier(() -> defaultString, defaultString);
            }
            PropertyKey key = new PropertyKey(this.mName, this.mDescription, defaultSupplier, this.mAlias, this.mIgnoredSiteProperty, this.mIsHidden, this.mConsistencyCheckLevel, this.mScope, this.mDisplayType, this.mIsBuiltIn);
            return key;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("alias", this.mAlias).add("defaultValue", this.mDefaultValue).add("description", this.mDescription).add("name", this.mName).toString();
        }
    }

    public static enum DisplayType {
        DEFAULT,
        CREDENTIALS;

    }

    public static enum ConsistencyCheckLevel {
        IGNORE,
        WARN,
        ENFORCE;

    }
}

