/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.util.ShellUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.TieredIdentity;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TieredIdentityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TieredIdentityFactory.class);
    private static final Object LOCK = new Object();
    @GuardedBy(value="LOCK")
    private static volatile TieredIdentity sInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TieredIdentity localIdentity(AlluxioConfiguration conf) {
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = TieredIdentityFactory.create(conf);
                    LOG.info("Initialized tiered identity {}", (Object)sInstance);
                }
            }
        }
        return sInstance;
    }

    @VisibleForTesting
    static TieredIdentity create(AlluxioConfiguration conf) {
        TieredIdentity scriptIdentity = TieredIdentityFactory.fromScript(conf);
        ArrayList<TieredIdentity.LocalityTier> tiers = new ArrayList<TieredIdentity.LocalityTier>();
        List<String> orderedTierNames = conf.getList(PropertyKey.LOCALITY_ORDER, ",");
        for (int i = 0; i < orderedTierNames.size(); ++i) {
            String tierName = orderedTierNames.get(i);
            String value = null;
            if (scriptIdentity != null) {
                TieredIdentity.LocalityTier scriptTier = scriptIdentity.getTier(i);
                Preconditions.checkState(scriptTier.getTierName().equals(tierName));
                value = scriptTier.getValue();
            }
            if (conf.isSet(PropertyKey.Template.LOCALITY_TIER.format(tierName))) {
                value = conf.get(PropertyKey.Template.LOCALITY_TIER.format(tierName));
            }
            tiers.add(new TieredIdentity.LocalityTier(tierName, value));
        }
        if (tiers.size() > 0 && ((TieredIdentity.LocalityTier)tiers.get(0)).getTierName().equals("node") && ((TieredIdentity.LocalityTier)tiers.get(0)).getValue() == null) {
            String name = NetworkAddressUtils.getLocalNodeName(conf);
            tiers.set(0, new TieredIdentity.LocalityTier("node", name));
        }
        return new TieredIdentity(tiers);
    }

    @Nullable
    private static TieredIdentity fromScript(AlluxioConfiguration conf) {
        String identityString;
        String scriptName = conf.get(PropertyKey.LOCALITY_SCRIPT);
        Path script = Paths.get(scriptName, new String[0]);
        if (!Files.exists(script, new LinkOption[0])) {
            URL resource = TieredIdentityFactory.class.getClassLoader().getResource(scriptName);
            if (resource != null) {
                script = Paths.get(resource.getPath(), new String[0]);
            } else {
                return null;
            }
        }
        LOG.debug("Found tiered identity script at {}", (Object)script);
        try {
            identityString = ShellUtils.execCommand(script.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to run script %s: %s", script, e.toString()), e);
        }
        try {
            return TieredIdentityFactory.fromString(identityString, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to parse output of running %s: %s", script, e.getMessage()), e);
        }
    }

    public static TieredIdentity fromString(String identityString, AlluxioConfiguration conf) throws IOException {
        HashSet<String> allTiers = Sets.newHashSet(conf.getList(PropertyKey.LOCALITY_ORDER, ","));
        HashMap<String, String> tiers = new HashMap<String, String>();
        for (String tier : identityString.split(",")) {
            String[] parts = tier.split("=");
            if (parts.length != 2) {
                throw new IOException(String.format("Failed to parse tiered identity. The value should be a comma-separated list of key=value pairs, but was %s", identityString));
            }
            String key = parts[0].trim();
            if (tiers.containsKey(key)) {
                throw new IOException(String.format("Encountered repeated tier definition for %s when parsing tiered identity from string %s", key, identityString));
            }
            if (!allTiers.contains(key)) {
                throw new IOException(String.format("Unrecognized tier: %s. The tiers defined by %s are %s", key, PropertyKey.LOCALITY_ORDER.toString(), allTiers));
            }
            tiers.put(key, parts[1].trim());
        }
        ArrayList<TieredIdentity.LocalityTier> tieredIdentity = new ArrayList<TieredIdentity.LocalityTier>();
        for (String localityTier : conf.getList(PropertyKey.LOCALITY_ORDER, ",")) {
            String value = tiers.getOrDefault(localityTier, null);
            tieredIdentity.add(new TieredIdentity.LocalityTier(localityTier, value));
        }
        return new TieredIdentity(tieredIdentity);
    }
}

