/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.org.apache.commons.httpclient.Header;
import alluxio.shaded.client.org.apache.commons.httpclient.HttpClient;
import alluxio.shaded.client.org.apache.commons.httpclient.methods.GetMethod;
import alluxio.shaded.client.org.apache.commons.httpclient.methods.HeadMethod;
import alluxio.shaded.client.org.apache.commons.httpclient.methods.PostMethod;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, Integer timeout, IProcessInputStream processInputStream) throws IOException {
        block4: {
            Preconditions.checkNotNull(timeout, "timeout");
            Preconditions.checkNotNull(processInputStream, "processInputStream");
            PostMethod postMethod = new PostMethod(url);
            try {
                HttpClient httpClient = new HttpClient();
                httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
                httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
                int statusCode = httpClient.executeMethod(postMethod);
                if (statusCode == 200 || statusCode == 201) {
                    InputStream inputStream = postMethod.getResponseBodyAsStream();
                    processInputStream.process(inputStream);
                    break block4;
                }
                throw new IOException("Failed to perform POST request. Status code: " + statusCode);
            }
            finally {
                postMethod.releaseConnection();
            }
        }
    }

    public static String post(String url, Integer timeout) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        HttpUtils.post(url, timeout, inputStream -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    contentBuffer.append(line);
                }
            }
        });
        return contentBuffer.toString();
    }

    public static InputStream getInputStream(String url, Integer timeout) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        final GetMethod getMethod = new GetMethod(url);
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        int statusCode = httpClient.executeMethod(getMethod);
        if (statusCode != 200 && statusCode != 201) {
            throw new IOException("Failed to perform GET request. Status code: " + statusCode);
        }
        InputStream inputStream = getMethod.getResponseBodyAsStream();
        return new BufferedInputStream(inputStream){

            @Override
            public void close() throws IOException {
                getMethod.releaseConnection();
            }
        };
    }

    public static void get(String url, Integer timeout, IProcessInputStream processInputStream) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        Preconditions.checkNotNull(processInputStream, "processInputStream");
        try (InputStream inputStream = HttpUtils.getInputStream(url, timeout);){
            processInputStream.process(inputStream);
        }
    }

    public static String get(String url, Integer timeout) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        StringBuilder contentBuffer = new StringBuilder();
        HttpUtils.get(url, timeout, inputStream -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    contentBuffer.append(line);
                }
            }
        });
        return contentBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Header[] head(String url, Integer timeout) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(timeout, "timeout");
        HeadMethod headMethod = new HeadMethod(url);
        try {
            HttpClient httpClient = new HttpClient();
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
            int statusCode = httpClient.executeMethod(headMethod);
            if (statusCode == 200 || statusCode == 201) {
                Header[] headerArray = headMethod.getResponseHeaders();
                return headerArray;
            }
            LOG.error("Failed to perform HEAD request. Status code: {}", (Object)statusCode);
        }
        catch (Exception e) {
            LOG.error("Failed to execute URL request: {}", (Object)url, (Object)e);
        }
        finally {
            headMethod.releaseConnection();
        }
        return null;
    }

    public static interface IProcessInputStream {
        public void process(InputStream var1) throws IOException;
    }
}

