/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.webui.NodeInfo;
import alluxio.wire.WorkerInfo;
import java.util.Arrays;
import java.util.Collection;

@ThreadSafe
public final class WebUtils {
    public static String convertByteArrayToStringWithoutEscape(byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = offset; i < length && i < data.length; ++i) {
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    public static String convertMsToShortClockTime(long millis) {
        Preconditions.checkArgument(millis >= 0L, "Negative values are not supported");
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long mins = millis % 3600000L / 60000L;
        long secs = millis % 60000L / 1000L;
        return String.format("%d d, %d h, %d m, and %d s", days, hours, mins, secs);
    }

    public static NodeInfo[] generateOrderedNodeInfos(Collection<WorkerInfo> workerInfos) {
        Object[] ret = new NodeInfo[workerInfos.size()];
        int index = 0;
        for (WorkerInfo workerInfo : workerInfos) {
            ret[index++] = new NodeInfo(workerInfo);
        }
        Arrays.sort(ret);
        return ret;
    }

    private WebUtils() {
    }
}

