/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.InconsistentPropertyValues;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public final class InconsistentProperty {
    private String mName = "";
    private Map<Optional<String>, List<String>> mValues = new HashMap<Optional<String>, List<String>>();
    private static final String OPTIONAL_STRING_VAL = "__Optional__";

    public InconsistentProperty() {
    }

    protected InconsistentProperty(alluxio.grpc.InconsistentProperty inconsistentProperty) {
        this.mName = inconsistentProperty.getName();
        this.mValues = new HashMap<Optional<String>, List<String>>(inconsistentProperty.getValuesCount());
        for (Map.Entry<String, InconsistentPropertyValues> entry : inconsistentProperty.getValuesMap().entrySet()) {
            if (entry.getKey().equals(OPTIONAL_STRING_VAL)) {
                this.mValues.put(Optional.empty(), entry.getValue().getValuesList());
                continue;
            }
            this.mValues.put(Optional.of(entry.getKey()), entry.getValue().getValuesList());
        }
    }

    public String getName() {
        return this.mName;
    }

    public Map<Optional<String>, List<String>> getValues() {
        return this.mValues;
    }

    public InconsistentProperty setName(String name) {
        this.mName = name;
        return this;
    }

    public InconsistentProperty setValues(Map<Optional<String>, List<String>> values) {
        this.mValues = values;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InconsistentProperty)) {
            return false;
        }
        InconsistentProperty that = (InconsistentProperty)o;
        return this.mName.equals(that.mName) && this.mValues.equals(that.mValues);
    }

    public int hashCode() {
        return Objects.hashCode(this.mName, this.mValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("key", this.mName).add("values", InconsistentProperty.formatValues(this.mValues)).toString();
    }

    private static String formatValues(Map<Optional<String>, List<String>> values) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry<Optional<String>, List<String>> entry : values.entrySet()) {
            joiner.add(String.format("%s (%s)", entry.getKey().orElse("no value set"), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue())));
        }
        return joiner.toString();
    }

    public alluxio.grpc.InconsistentProperty toProto() {
        HashMap<String, InconsistentPropertyValues> inconsistentPropsMap = new HashMap<String, InconsistentPropertyValues>();
        for (Map.Entry<Optional<String>, List<String>> entry : this.mValues.entrySet()) {
            String pKey = OPTIONAL_STRING_VAL;
            if (entry.getKey().isPresent() && !entry.getKey().get().isEmpty()) {
                pKey = entry.getKey().get();
            }
            inconsistentPropsMap.put(pKey, InconsistentPropertyValues.newBuilder().addAllValues((Iterable<String>)entry.getValue()).build());
        }
        return alluxio.grpc.InconsistentProperty.newBuilder().setName(this.mName).putAllValues(inconsistentPropsMap).build();
    }

    public static InconsistentProperty fromProto(alluxio.grpc.InconsistentProperty inconsistentProperty) {
        return new InconsistentProperty(inconsistentProperty);
    }
}

