package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 **
 * This interface contains meta master service endpoints for Alluxio clients.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.17.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/meta_master.proto")
public final class MetaMasterClientServiceGrpc {

  private MetaMasterClientServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.meta.MetaMasterClientService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.BackupPOptions,
      alluxio.grpc.BackupPResponse> getBackupMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Backup",
      requestType = alluxio.grpc.BackupPOptions.class,
      responseType = alluxio.grpc.BackupPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.BackupPOptions,
      alluxio.grpc.BackupPResponse> getBackupMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.BackupPOptions, alluxio.grpc.BackupPResponse> getBackupMethod;
    if ((getBackupMethod = MetaMasterClientServiceGrpc.getBackupMethod) == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        if ((getBackupMethod = MetaMasterClientServiceGrpc.getBackupMethod) == null) {
          MetaMasterClientServiceGrpc.getBackupMethod = getBackupMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.BackupPOptions, alluxio.grpc.BackupPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.meta.MetaMasterClientService", "Backup"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.BackupPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.BackupPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MetaMasterClientServiceMethodDescriptorSupplier("Backup"))
                  .build();
          }
        }
     }
     return getBackupMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetConfigReportPOptions,
      alluxio.grpc.GetConfigReportPResponse> getGetConfigReportMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetConfigReport",
      requestType = alluxio.grpc.GetConfigReportPOptions.class,
      responseType = alluxio.grpc.GetConfigReportPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetConfigReportPOptions,
      alluxio.grpc.GetConfigReportPResponse> getGetConfigReportMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetConfigReportPOptions, alluxio.grpc.GetConfigReportPResponse> getGetConfigReportMethod;
    if ((getGetConfigReportMethod = MetaMasterClientServiceGrpc.getGetConfigReportMethod) == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        if ((getGetConfigReportMethod = MetaMasterClientServiceGrpc.getGetConfigReportMethod) == null) {
          MetaMasterClientServiceGrpc.getGetConfigReportMethod = getGetConfigReportMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetConfigReportPOptions, alluxio.grpc.GetConfigReportPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.meta.MetaMasterClientService", "GetConfigReport"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetConfigReportPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetConfigReportPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MetaMasterClientServiceMethodDescriptorSupplier("GetConfigReport"))
                  .build();
          }
        }
     }
     return getGetConfigReportMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMasterInfoPOptions,
      alluxio.grpc.GetMasterInfoPResponse> getGetMasterInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetMasterInfo",
      requestType = alluxio.grpc.GetMasterInfoPOptions.class,
      responseType = alluxio.grpc.GetMasterInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMasterInfoPOptions,
      alluxio.grpc.GetMasterInfoPResponse> getGetMasterInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMasterInfoPOptions, alluxio.grpc.GetMasterInfoPResponse> getGetMasterInfoMethod;
    if ((getGetMasterInfoMethod = MetaMasterClientServiceGrpc.getGetMasterInfoMethod) == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        if ((getGetMasterInfoMethod = MetaMasterClientServiceGrpc.getGetMasterInfoMethod) == null) {
          MetaMasterClientServiceGrpc.getGetMasterInfoMethod = getGetMasterInfoMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetMasterInfoPOptions, alluxio.grpc.GetMasterInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.meta.MetaMasterClientService", "GetMasterInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMasterInfoPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMasterInfoPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MetaMasterClientServiceMethodDescriptorSupplier("GetMasterInfo"))
                  .build();
          }
        }
     }
     return getGetMasterInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions,
      alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetMetrics",
      requestType = alluxio.grpc.GetMetricsPOptions.class,
      responseType = alluxio.grpc.GetMetricsPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions,
      alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions, alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod;
    if ((getGetMetricsMethod = MetaMasterClientServiceGrpc.getGetMetricsMethod) == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        if ((getGetMetricsMethod = MetaMasterClientServiceGrpc.getGetMetricsMethod) == null) {
          MetaMasterClientServiceGrpc.getGetMetricsMethod = getGetMetricsMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetMetricsPOptions, alluxio.grpc.GetMetricsPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.meta.MetaMasterClientService", "GetMetrics"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMetricsPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMetricsPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MetaMasterClientServiceMethodDescriptorSupplier("GetMetrics"))
                  .build();
          }
        }
     }
     return getGetMetricsMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.CheckpointPOptions,
      alluxio.grpc.CheckpointPResponse> getCheckpointMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Checkpoint",
      requestType = alluxio.grpc.CheckpointPOptions.class,
      responseType = alluxio.grpc.CheckpointPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.CheckpointPOptions,
      alluxio.grpc.CheckpointPResponse> getCheckpointMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.CheckpointPOptions, alluxio.grpc.CheckpointPResponse> getCheckpointMethod;
    if ((getCheckpointMethod = MetaMasterClientServiceGrpc.getCheckpointMethod) == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        if ((getCheckpointMethod = MetaMasterClientServiceGrpc.getCheckpointMethod) == null) {
          MetaMasterClientServiceGrpc.getCheckpointMethod = getCheckpointMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.CheckpointPOptions, alluxio.grpc.CheckpointPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.meta.MetaMasterClientService", "Checkpoint"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.CheckpointPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.CheckpointPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new MetaMasterClientServiceMethodDescriptorSupplier("Checkpoint"))
                  .build();
          }
        }
     }
     return getCheckpointMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MetaMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    return new MetaMasterClientServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MetaMasterClientServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    return new MetaMasterClientServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MetaMasterClientServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    return new MetaMasterClientServiceFutureStub(channel);
  }

  /**
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio clients.
   * </pre>
   */
  public static abstract class MetaMasterClientServiceImplBase implements alluxio.shaded.client.io.grpc.BindableService {

    /**
     * <pre>
     **
     * Backs up the Alluxio master to the specified URI
     * </pre>
     */
    public void backup(alluxio.grpc.BackupPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.BackupPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getBackupMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns server-side configuration report.
     * </pre>
     */
    public void getConfigReport(alluxio.grpc.GetConfigReportPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetConfigReportPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetConfigReportMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns information about the master.
     * </pre>
     */
    public void getMasterInfo(alluxio.grpc.GetMasterInfoPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMasterInfoPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetMasterInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public void getMetrics(alluxio.grpc.GetMetricsPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetMetricsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Creates a checkpoint in the primary master journal system.
     * </pre>
     */
    public void checkpoint(alluxio.grpc.CheckpointPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.CheckpointPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCheckpointMethod(), responseObserver);
    }

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getBackupMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.BackupPOptions,
                alluxio.grpc.BackupPResponse>(
                  this, METHODID_BACKUP)))
          .addMethod(
            getGetConfigReportMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetConfigReportPOptions,
                alluxio.grpc.GetConfigReportPResponse>(
                  this, METHODID_GET_CONFIG_REPORT)))
          .addMethod(
            getGetMasterInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetMasterInfoPOptions,
                alluxio.grpc.GetMasterInfoPResponse>(
                  this, METHODID_GET_MASTER_INFO)))
          .addMethod(
            getGetMetricsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetMetricsPOptions,
                alluxio.grpc.GetMetricsPResponse>(
                  this, METHODID_GET_METRICS)))
          .addMethod(
            getCheckpointMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.CheckpointPOptions,
                alluxio.grpc.CheckpointPResponse>(
                  this, METHODID_CHECKPOINT)))
          .build();
    }
  }

  /**
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetaMasterClientServiceStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<MetaMasterClientServiceStub> {
    private MetaMasterClientServiceStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private MetaMasterClientServiceStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetaMasterClientServiceStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetaMasterClientServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Backs up the Alluxio master to the specified URI
     * </pre>
     */
    public void backup(alluxio.grpc.BackupPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.BackupPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getBackupMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns server-side configuration report.
     * </pre>
     */
    public void getConfigReport(alluxio.grpc.GetConfigReportPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetConfigReportPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetConfigReportMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns information about the master.
     * </pre>
     */
    public void getMasterInfo(alluxio.grpc.GetMasterInfoPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMasterInfoPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetMasterInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public void getMetrics(alluxio.grpc.GetMetricsPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetMetricsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Creates a checkpoint in the primary master journal system.
     * </pre>
     */
    public void checkpoint(alluxio.grpc.CheckpointPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.CheckpointPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCheckpointMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetaMasterClientServiceBlockingStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<MetaMasterClientServiceBlockingStub> {
    private MetaMasterClientServiceBlockingStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private MetaMasterClientServiceBlockingStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetaMasterClientServiceBlockingStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetaMasterClientServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Backs up the Alluxio master to the specified URI
     * </pre>
     */
    public alluxio.grpc.BackupPResponse backup(alluxio.grpc.BackupPOptions request) {
      return blockingUnaryCall(
          getChannel(), getBackupMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns server-side configuration report.
     * </pre>
     */
    public alluxio.grpc.GetConfigReportPResponse getConfigReport(alluxio.grpc.GetConfigReportPOptions request) {
      return blockingUnaryCall(
          getChannel(), getGetConfigReportMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns information about the master.
     * </pre>
     */
    public alluxio.grpc.GetMasterInfoPResponse getMasterInfo(alluxio.grpc.GetMasterInfoPOptions request) {
      return blockingUnaryCall(
          getChannel(), getGetMasterInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public alluxio.grpc.GetMetricsPResponse getMetrics(alluxio.grpc.GetMetricsPOptions request) {
      return blockingUnaryCall(
          getChannel(), getGetMetricsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Creates a checkpoint in the primary master journal system.
     * </pre>
     */
    public alluxio.grpc.CheckpointPResponse checkpoint(alluxio.grpc.CheckpointPOptions request) {
      return blockingUnaryCall(
          getChannel(), getCheckpointMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetaMasterClientServiceFutureStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<MetaMasterClientServiceFutureStub> {
    private MetaMasterClientServiceFutureStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private MetaMasterClientServiceFutureStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetaMasterClientServiceFutureStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetaMasterClientServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Backs up the Alluxio master to the specified URI
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.BackupPResponse> backup(
        alluxio.grpc.BackupPOptions request) {
      return futureUnaryCall(
          getChannel().newCall(getBackupMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns server-side configuration report.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetConfigReportPResponse> getConfigReport(
        alluxio.grpc.GetConfigReportPOptions request) {
      return futureUnaryCall(
          getChannel().newCall(getGetConfigReportMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns information about the master.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetMasterInfoPResponse> getMasterInfo(
        alluxio.grpc.GetMasterInfoPOptions request) {
      return futureUnaryCall(
          getChannel().newCall(getGetMasterInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetMetricsPResponse> getMetrics(
        alluxio.grpc.GetMetricsPOptions request) {
      return futureUnaryCall(
          getChannel().newCall(getGetMetricsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Creates a checkpoint in the primary master journal system.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.CheckpointPResponse> checkpoint(
        alluxio.grpc.CheckpointPOptions request) {
      return futureUnaryCall(
          getChannel().newCall(getCheckpointMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_BACKUP = 0;
  private static final int METHODID_GET_CONFIG_REPORT = 1;
  private static final int METHODID_GET_MASTER_INFO = 2;
  private static final int METHODID_GET_METRICS = 3;
  private static final int METHODID_CHECKPOINT = 4;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MetaMasterClientServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MetaMasterClientServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_BACKUP:
          serviceImpl.backup((alluxio.grpc.BackupPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.BackupPResponse>) responseObserver);
          break;
        case METHODID_GET_CONFIG_REPORT:
          serviceImpl.getConfigReport((alluxio.grpc.GetConfigReportPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetConfigReportPResponse>) responseObserver);
          break;
        case METHODID_GET_MASTER_INFO:
          serviceImpl.getMasterInfo((alluxio.grpc.GetMasterInfoPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMasterInfoPResponse>) responseObserver);
          break;
        case METHODID_GET_METRICS:
          serviceImpl.getMetrics((alluxio.grpc.GetMetricsPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse>) responseObserver);
          break;
        case METHODID_CHECKPOINT:
          serviceImpl.checkpoint((alluxio.grpc.CheckpointPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.CheckpointPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MetaMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MetaMasterClientServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.MetaMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MetaMasterClientService");
    }
  }

  private static final class MetaMasterClientServiceFileDescriptorSupplier
      extends MetaMasterClientServiceBaseDescriptorSupplier {
    MetaMasterClientServiceFileDescriptorSupplier() {}
  }

  private static final class MetaMasterClientServiceMethodDescriptorSupplier
      extends MetaMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MetaMasterClientServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MetaMasterClientServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MetaMasterClientServiceFileDescriptorSupplier())
              .addMethod(getBackupMethod())
              .addMethod(getGetConfigReportMethod())
              .addMethod(getGetMasterInfoMethod())
              .addMethod(getGetMetricsMethod())
              .addMethod(getCheckpointMethod())
              .build();
        }
      }
    }
    return result;
  }
}
