/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.security.authentication;

import alluxio.shaded.client.io.grpc.Channel;

import java.util.UUID;

/**
 * A gRPC channel with authentication state.
 */
public abstract class AuthenticatedChannel extends Channel {
  /**
   * @return whether the channel is authenticated
   */
  public abstract boolean isAuthenticated();

  /**
   * @return the channel Id used for authentication
   */
  public abstract UUID getChannelId();

  /**
   * Closes the authentication session with the server.
   */
  public abstract void close();
}
