// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/type/postal_address.proto

package alluxio.shaded.client.com.google.type;

/**
 * <pre>
 * Represents a postal address, e.g. for postal delivery or payments addresses.
 * Given a postal address, a postal service can deliver items to a premise, P.O.
 * Box or similar.
 * It is not intended to model geographical locations (roads, towns,
 * mountains).
 * In typical usage an address would be created via user input or from importing
 * existing data, depending on the type of process.
 * Advice on address input / editing:
 *  - Use an i18n-ready address widget such as
 *    https://github.alluxio.shaded.client.com.googlei18n/libaddressinput)
 * - Users should not be presented with UI elements for input or editing of
 *   fields outside countries where that field is used.
 * For more guidance on how to use this schema, please see:
 * https://support.google.alluxio.shaded.client.com.business/answer/6397478
 * </pre>
 *
 * Protobuf type {@code google.type.PostalAddress}
 */
public  final class PostalAddress extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.type.PostalAddress)
    PostalAddressOrBuilder {
  // Use PostalAddress.newBuilder() to construct.
  private PostalAddress(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PostalAddress() {
    revision_ = 0;
    regionCode_ = "";
    languageCode_ = "";
    postalCode_ = "";
    sortingCode_ = "";
    administrativeArea_ = "";
    locality_ = "";
    sublocality_ = "";
    addressLines_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
    recipients_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
    alluxio.shaded.client.org.nization_ = "";
  }

  @java.lang.Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private PostalAddress(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            revision_ = input.readInt32();
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            regionCode_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            languageCode_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            postalCode_ = s;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            sortingCode_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            administrativeArea_ = s;
            break;
          }
          case 58: {
            java.lang.String s = input.readStringRequireUtf8();

            locality_ = s;
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();

            sublocality_ = s;
            break;
          }
          case 74: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              addressLines_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000100;
            }
            addressLines_.add(s);
            break;
          }
          case 82: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000200) == 0x00000200)) {
              recipients_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000200;
            }
            recipients_.add(s);
            break;
          }
          case 90: {
            java.lang.String s = input.readStringRequireUtf8();

            alluxio.shaded.client.org.nization_ = s;
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
        addressLines_ = addressLines_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000200) == 0x00000200)) {
        recipients_ = recipients_.getUnmodifiableView();
      }
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_descriptor;
  }

  protected alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            alluxio.shaded.client.com.google.type.PostalAddress.class, alluxio.shaded.client.com.google.type.PostalAddress.Builder.class);
  }

  private int bitField0_;
  public static final int REVISION_FIELD_NUMBER = 1;
  private int revision_;
  /**
   * <pre>
   * The schema revision of the `PostalAddress`.
   * All new revisions **must** be backward alluxio.shaded.client.com.atible with old revisions.
   * </pre>
   *
   * <code>int32 revision = 1;</code>
   */
  public int getRevision() {
    return revision_;
  }

  public static final int REGION_CODE_FIELD_NUMBER = 2;
  private volatile java.lang.Object regionCode_;
  /**
   * <pre>
   * Required. CLDR region code of the country/region of the address. This
   * is never inferred and it is up to the user to ensure the value is
   * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
   * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   */
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Required. CLDR region code of the country/region of the address. This
   * is never inferred and it is up to the user to ensure the value is
   * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
   * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object languageCode_;
  /**
   * <pre>
   * Optional. BCP-47 language code of the contents of this address (if
   * known). This is often the UI language of the input form or is expected
   * to match one of the languages used in the address' country/region, or their
   * transliterated equivalents.
   * This can affect formatting in certain countries, but is not critical
   * to the correctness of the data and will never affect any validation or
   * other non-formatting related operations.
   * If this value is not known, it should be omitted (rather than specifying a
   * possibly incorrect default).
   * Examples: "zh-Hant", "ja", "ja-Latn", "en".
   * </pre>
   *
   * <code>string language_code = 3;</code>
   */
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. BCP-47 language code of the contents of this address (if
   * known). This is often the UI language of the input form or is expected
   * to match one of the languages used in the address' country/region, or their
   * transliterated equivalents.
   * This can affect formatting in certain countries, but is not critical
   * to the correctness of the data and will never affect any validation or
   * other non-formatting related operations.
   * If this value is not known, it should be omitted (rather than specifying a
   * possibly incorrect default).
   * Examples: "zh-Hant", "ja", "ja-Latn", "en".
   * </pre>
   *
   * <code>string language_code = 3;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTAL_CODE_FIELD_NUMBER = 4;
  private volatile java.lang.Object postalCode_;
  /**
   * <pre>
   * Optional. Postal code of the address. Not all countries use or require
   * postal codes to be present, but where they are used, they may trigger
   * additional validation with other parts of the address (e.g. state/zip
   * validation in the U.S.A.).
   * </pre>
   *
   * <code>string postal_code = 4;</code>
   */
  public java.lang.String getPostalCode() {
    java.lang.Object ref = postalCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postalCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. Postal code of the address. Not all countries use or require
   * postal codes to be present, but where they are used, they may trigger
   * additional validation with other parts of the address (e.g. state/zip
   * validation in the U.S.A.).
   * </pre>
   *
   * <code>string postal_code = 4;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getPostalCodeBytes() {
    java.lang.Object ref = postalCode_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      postalCode_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SORTING_CODE_FIELD_NUMBER = 5;
  private volatile java.lang.Object sortingCode_;
  /**
   * <pre>
   * Optional. Additional, country-specific, sorting code. This is not used
   * in most regions. Where it is used, the value is either a string like
   * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
   * alone, representing the "sector code" (Jamaica), "delivery area indicator"
   * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
   * </pre>
   *
   * <code>string sorting_code = 5;</code>
   */
  public java.lang.String getSortingCode() {
    java.lang.Object ref = sortingCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sortingCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. Additional, country-specific, sorting code. This is not used
   * in most regions. Where it is used, the value is either a string like
   * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
   * alone, representing the "sector code" (Jamaica), "delivery area indicator"
   * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
   * </pre>
   *
   * <code>string sorting_code = 5;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getSortingCodeBytes() {
    java.lang.Object ref = sortingCode_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      sortingCode_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADMINISTRATIVE_AREA_FIELD_NUMBER = 6;
  private volatile java.lang.Object administrativeArea_;
  /**
   * <pre>
   * Optional. Highest administrative subdivision which is used for postal
   * addresses of a country or region.
   * For example, this can be a state, a province, an oblast, or a prefecture.
   * Specifically, for Spain this is the province and not the autonomous
   * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
   * Many countries don't use an administrative area in postal addresses. E.g.
   * in Switzerland this should be left unpopulated.
   * </pre>
   *
   * <code>string administrative_area = 6;</code>
   */
  public java.lang.String getAdministrativeArea() {
    java.lang.Object ref = administrativeArea_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      administrativeArea_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. Highest administrative subdivision which is used for postal
   * addresses of a country or region.
   * For example, this can be a state, a province, an oblast, or a prefecture.
   * Specifically, for Spain this is the province and not the autonomous
   * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
   * Many countries don't use an administrative area in postal addresses. E.g.
   * in Switzerland this should be left unpopulated.
   * </pre>
   *
   * <code>string administrative_area = 6;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getAdministrativeAreaBytes() {
    java.lang.Object ref = administrativeArea_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      administrativeArea_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALITY_FIELD_NUMBER = 7;
  private volatile java.lang.Object locality_;
  /**
   * <pre>
   * Optional. Generally refers to the city/town portion of the address.
   * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
   * In regions of the world where localities are not well defined or do not fit
   * into this structure well, leave locality empty and use address_lines.
   * </pre>
   *
   * <code>string locality = 7;</code>
   */
  public java.lang.String getLocality() {
    java.lang.Object ref = locality_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locality_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. Generally refers to the city/town portion of the address.
   * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
   * In regions of the world where localities are not well defined or do not fit
   * into this structure well, leave locality empty and use address_lines.
   * </pre>
   *
   * <code>string locality = 7;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getLocalityBytes() {
    java.lang.Object ref = locality_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      locality_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBLOCALITY_FIELD_NUMBER = 8;
  private volatile java.lang.Object sublocality_;
  /**
   * <pre>
   * Optional. Sublocality of the address.
   * For example, this can be neighborhoods, boroughs, districts.
   * </pre>
   *
   * <code>string sublocality = 8;</code>
   */
  public java.lang.String getSublocality() {
    java.lang.Object ref = sublocality_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sublocality_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. Sublocality of the address.
   * For example, this can be neighborhoods, boroughs, districts.
   * </pre>
   *
   * <code>string sublocality = 8;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getSublocalityBytes() {
    java.lang.Object ref = sublocality_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      sublocality_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDRESS_LINES_FIELD_NUMBER = 9;
  private alluxio.shaded.client.com.google.protobuf.LazyStringList addressLines_;
  /**
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address alluxio.shaded.client.com.onents until it was at least
   * partially resolved.
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
      getAddressLinesList() {
    return addressLines_;
  }
  /**
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address alluxio.shaded.client.com.onents until it was at least
   * partially resolved.
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   */
  public int getAddressLinesCount() {
    return addressLines_.size();
  }
  /**
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address alluxio.shaded.client.com.onents until it was at least
   * partially resolved.
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   */
  public java.lang.String getAddressLines(int index) {
    return addressLines_.get(index);
  }
  /**
   * <pre>
   * Unstructured address lines describing the lower levels of an address.
   * Because values in address_lines do not have type information and may
   * sometimes contain multiple values in a single field (e.g.
   * "Austin, TX"), it is important that the line order is clear. The order of
   * address lines should be "envelope order" for the country/region of the
   * address. In places where this can vary (e.g. Japan), address_language is
   * used to make it explicit (e.g. "ja" for large-to-small ordering and
   * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
   * an address can be selected based on the language.
   * The minimum permitted structural representation of an address consists
   * of a region_code with all remaining information placed in the
   * address_lines. It would be possible to format such an address very
   * approximately without geocoding, but no semantic reasoning could be
   * made about any of the address alluxio.shaded.client.com.onents until it was at least
   * partially resolved.
   * Creating an address only containing a region_code and address_lines, and
   * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
   * addresses (as opposed to guessing which parts of the address should be
   * localities or administrative areas).
   * </pre>
   *
   * <code>repeated string address_lines = 9;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getAddressLinesBytes(int index) {
    return addressLines_.getByteString(index);
  }

  public static final int RECIPIENTS_FIELD_NUMBER = 10;
  private alluxio.shaded.client.com.google.protobuf.LazyStringList recipients_;
  /**
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
      getRecipientsList() {
    return recipients_;
  }
  /**
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   */
  public int getRecipientsCount() {
    return recipients_.size();
  }
  /**
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   */
  public java.lang.String getRecipients(int index) {
    return recipients_.get(index);
  }
  /**
   * <pre>
   * Optional. The recipient at the address.
   * This field may, under certain circumstances, contain multiline information.
   * For example, it might contain "care of" information.
   * </pre>
   *
   * <code>repeated string recipients = 10;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getRecipientsBytes(int index) {
    return recipients_.getByteString(index);
  }

  public static final int ORGANIZATION_FIELD_NUMBER = 11;
  private volatile java.lang.Object alluxio.shaded.client.org.nization_;
  /**
   * <pre>
   * Optional. The name of the alluxio.shaded.client.org.nization at the address.
   * </pre>
   *
   * <code>string alluxio.shaded.client.org.nization = 11;</code>
   */
  public java.lang.String getOrganization() {
    java.lang.Object ref = alluxio.shaded.client.org.nization_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alluxio.shaded.client.org.nization_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. The name of the alluxio.shaded.client.org.nization at the address.
   * </pre>
   *
   * <code>string alluxio.shaded.client.org.nization = 11;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getOrganizationBytes() {
    java.lang.Object ref = alluxio.shaded.client.org.nization_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      alluxio.shaded.client.org.nization_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    if (revision_ != 0) {
      output.writeInt32(1, revision_);
    }
    if (!getRegionCodeBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, regionCode_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (!getPostalCodeBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 4, postalCode_);
    }
    if (!getSortingCodeBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sortingCode_);
    }
    if (!getAdministrativeAreaBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 6, administrativeArea_);
    }
    if (!getLocalityBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 7, locality_);
    }
    if (!getSublocalityBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sublocality_);
    }
    for (int i = 0; i < addressLines_.size(); i++) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 9, addressLines_.getRaw(i));
    }
    for (int i = 0; i < recipients_.size(); i++) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 10, recipients_.getRaw(i));
    }
    if (!getOrganizationBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 11, alluxio.shaded.client.org.nization_);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (revision_ != 0) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteInt32Size(1, revision_);
    }
    if (!getRegionCodeBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(2, regionCode_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(3, languageCode_);
    }
    if (!getPostalCodeBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(4, postalCode_);
    }
    if (!getSortingCodeBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(5, sortingCode_);
    }
    if (!getAdministrativeAreaBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(6, administrativeArea_);
    }
    if (!getLocalityBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(7, locality_);
    }
    if (!getSublocalityBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(8, sublocality_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < addressLines_.size(); i++) {
        dataSize += alluxio.shaded.client.com.uteStringSizeNoTag(addressLines_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAddressLinesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < recipients_.size(); i++) {
        dataSize += alluxio.shaded.client.com.uteStringSizeNoTag(recipients_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRecipientsList().size();
    }
    if (!getOrganizationBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(11, alluxio.shaded.client.org.nization_);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof alluxio.shaded.client.com.google.type.PostalAddress)) {
      return super.equals(obj);
    }
    alluxio.shaded.client.com.google.type.PostalAddress other = (alluxio.shaded.client.com.google.type.PostalAddress) obj;

    boolean result = true;
    result = result && (getRevision()
        == other.getRevision());
    result = result && getRegionCode()
        .equals(other.getRegionCode());
    result = result && getLanguageCode()
        .equals(other.getLanguageCode());
    result = result && getPostalCode()
        .equals(other.getPostalCode());
    result = result && getSortingCode()
        .equals(other.getSortingCode());
    result = result && getAdministrativeArea()
        .equals(other.getAdministrativeArea());
    result = result && getLocality()
        .equals(other.getLocality());
    result = result && getSublocality()
        .equals(other.getSublocality());
    result = result && getAddressLinesList()
        .equals(other.getAddressLinesList());
    result = result && getRecipientsList()
        .equals(other.getRecipientsList());
    result = result && getOrganization()
        .equals(other.getOrganization());
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision();
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + POSTAL_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getPostalCode().hashCode();
    hash = (37 * hash) + SORTING_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSortingCode().hashCode();
    hash = (37 * hash) + ADMINISTRATIVE_AREA_FIELD_NUMBER;
    hash = (53 * hash) + getAdministrativeArea().hashCode();
    hash = (37 * hash) + LOCALITY_FIELD_NUMBER;
    hash = (53 * hash) + getLocality().hashCode();
    hash = (37 * hash) + SUBLOCALITY_FIELD_NUMBER;
    hash = (53 * hash) + getSublocality().hashCode();
    if (getAddressLinesCount() > 0) {
      hash = (37 * hash) + ADDRESS_LINES_FIELD_NUMBER;
      hash = (53 * hash) + getAddressLinesList().hashCode();
    }
    if (getRecipientsCount() > 0) {
      hash = (37 * hash) + RECIPIENTS_FIELD_NUMBER;
      hash = (53 * hash) + getRecipientsList().hashCode();
    }
    hash = (37 * hash) + ORGANIZATION_FIELD_NUMBER;
    hash = (53 * hash) + getOrganization().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.type.PostalAddress parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(alluxio.shaded.client.com.google.type.PostalAddress prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a postal address, e.g. for postal delivery or payments addresses.
   * Given a postal address, a postal service can deliver items to a premise, P.O.
   * Box or similar.
   * It is not intended to model geographical locations (roads, towns,
   * mountains).
   * In typical usage an address would be created via user input or from importing
   * existing data, depending on the type of process.
   * Advice on address input / editing:
   *  - Use an i18n-ready address widget such as
   *    https://github.alluxio.shaded.client.com.googlei18n/libaddressinput)
   * - Users should not be presented with UI elements for input or editing of
   *   fields outside countries where that field is used.
   * For more guidance on how to use this schema, please see:
   * https://support.google.alluxio.shaded.client.com.business/answer/6397478
   * </pre>
   *
   * Protobuf type {@code google.type.PostalAddress}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.type.PostalAddress)
      alluxio.shaded.client.com.google.type.PostalAddressOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_descriptor;
    }

    protected alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              alluxio.shaded.client.com.google.type.PostalAddress.class, alluxio.shaded.client.com.google.type.PostalAddress.Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.type.PostalAddress.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      revision_ = 0;

      regionCode_ = "";

      languageCode_ = "";

      postalCode_ = "";

      sortingCode_ = "";

      administrativeArea_ = "";

      locality_ = "";

      sublocality_ = "";

      addressLines_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      recipients_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000200);
      alluxio.shaded.client.org.nization_ = "";

      return this;
    }

    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.type.PostalAddressProto.internal_static_google_type_PostalAddress_descriptor;
    }

    public alluxio.shaded.client.com.google.type.PostalAddress getDefaultInstanceForType() {
      return alluxio.shaded.client.com.google.type.PostalAddress.getDefaultInstance();
    }

    public alluxio.shaded.client.com.google.type.PostalAddress build() {
      alluxio.shaded.client.com.google.type.PostalAddress result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public alluxio.shaded.client.com.google.type.PostalAddress buildPartial() {
      alluxio.shaded.client.com.google.type.PostalAddress result = new alluxio.shaded.client.com.google.type.PostalAddress(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.revision_ = revision_;
      result.regionCode_ = regionCode_;
      result.languageCode_ = languageCode_;
      result.postalCode_ = postalCode_;
      result.sortingCode_ = sortingCode_;
      result.administrativeArea_ = administrativeArea_;
      result.locality_ = locality_;
      result.sublocality_ = sublocality_;
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        addressLines_ = addressLines_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.addressLines_ = addressLines_;
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        recipients_ = recipients_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000200);
      }
      result.recipients_ = recipients_;
      result.alluxio.shaded.client.org.nization_ = alluxio.shaded.client.org.nization_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof alluxio.shaded.client.com.google.type.PostalAddress) {
        return mergeFrom((alluxio.shaded.client.com.google.type.PostalAddress)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(alluxio.shaded.client.com.google.type.PostalAddress other) {
      if (other == alluxio.shaded.client.com.google.type.PostalAddress.getDefaultInstance()) return this;
      if (other.getRevision() != 0) {
        setRevision(other.getRevision());
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (!other.getPostalCode().isEmpty()) {
        postalCode_ = other.postalCode_;
        onChanged();
      }
      if (!other.getSortingCode().isEmpty()) {
        sortingCode_ = other.sortingCode_;
        onChanged();
      }
      if (!other.getAdministrativeArea().isEmpty()) {
        administrativeArea_ = other.administrativeArea_;
        onChanged();
      }
      if (!other.getLocality().isEmpty()) {
        locality_ = other.locality_;
        onChanged();
      }
      if (!other.getSublocality().isEmpty()) {
        sublocality_ = other.sublocality_;
        onChanged();
      }
      if (!other.addressLines_.isEmpty()) {
        if (addressLines_.isEmpty()) {
          addressLines_ = other.addressLines_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureAddressLinesIsMutable();
          addressLines_.addAll(other.addressLines_);
        }
        onChanged();
      }
      if (!other.recipients_.isEmpty()) {
        if (recipients_.isEmpty()) {
          recipients_ = other.recipients_;
          bitField0_ = (bitField0_ & ~0x00000200);
        } else {
          ensureRecipientsIsMutable();
          recipients_.addAll(other.recipients_);
        }
        onChanged();
      }
      if (!other.getOrganization().isEmpty()) {
        alluxio.shaded.client.org.nization_ = other.alluxio.shaded.client.org.nization_;
        onChanged();
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      alluxio.shaded.client.com.google.type.PostalAddress parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (alluxio.shaded.client.com.google.type.PostalAddress) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int revision_ ;
    /**
     * <pre>
     * The schema revision of the `PostalAddress`.
     * All new revisions **must** be backward alluxio.shaded.client.com.atible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     */
    public int getRevision() {
      return revision_;
    }
    /**
     * <pre>
     * The schema revision of the `PostalAddress`.
     * All new revisions **must** be backward alluxio.shaded.client.com.atible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     */
    public Builder setRevision(int value) {
      
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The schema revision of the `PostalAddress`.
     * All new revisions **must** be backward alluxio.shaded.client.com.atible with old revisions.
     * </pre>
     *
     * <code>int32 revision = 1;</code>
     */
    public Builder clearRevision() {
      
      revision_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";
    /**
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
     * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
     * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
     * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     */
    public Builder setRegionCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      regionCode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
     * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     */
    public Builder clearRegionCode() {
      
      regionCode_ = getDefaultInstance().getRegionCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. CLDR region code of the country/region of the address. This
     * is never inferred and it is up to the user to ensure the value is
     * correct. See http://cldr.unicode.alluxio.shaded.client.org. and
     * http://www.unicode.alluxio.shaded.client.org.cldr/charts/30/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     */
    public Builder setRegionCodeBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      regionCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     */
    public Builder setLanguageCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     */
    public Builder clearLanguageCode() {
      
      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. BCP-47 language code of the contents of this address (if
     * known). This is often the UI language of the input form or is expected
     * to match one of the languages used in the address' country/region, or their
     * transliterated equivalents.
     * This can affect formatting in certain countries, but is not critical
     * to the correctness of the data and will never affect any validation or
     * other non-formatting related operations.
     * If this value is not known, it should be omitted (rather than specifying a
     * possibly incorrect default).
     * Examples: "zh-Hant", "ja", "ja-Latn", "en".
     * </pre>
     *
     * <code>string language_code = 3;</code>
     */
    public Builder setLanguageCodeBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      languageCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object postalCode_ = "";
    /**
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     */
    public java.lang.String getPostalCode() {
      java.lang.Object ref = postalCode_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postalCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getPostalCodeBytes() {
      java.lang.Object ref = postalCode_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        postalCode_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     */
    public Builder setPostalCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      postalCode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     */
    public Builder clearPostalCode() {
      
      postalCode_ = getDefaultInstance().getPostalCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Postal code of the address. Not all countries use or require
     * postal codes to be present, but where they are used, they may trigger
     * additional validation with other parts of the address (e.g. state/zip
     * validation in the U.S.A.).
     * </pre>
     *
     * <code>string postal_code = 4;</code>
     */
    public Builder setPostalCodeBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      postalCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sortingCode_ = "";
    /**
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     */
    public java.lang.String getSortingCode() {
      java.lang.Object ref = sortingCode_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sortingCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getSortingCodeBytes() {
      java.lang.Object ref = sortingCode_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sortingCode_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     */
    public Builder setSortingCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      sortingCode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     */
    public Builder clearSortingCode() {
      
      sortingCode_ = getDefaultInstance().getSortingCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Additional, country-specific, sorting code. This is not used
     * in most regions. Where it is used, the value is either a string like
     * "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number
     * alone, representing the "sector code" (Jamaica), "delivery area indicator"
     * (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
     * </pre>
     *
     * <code>string sorting_code = 5;</code>
     */
    public Builder setSortingCodeBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      sortingCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object administrativeArea_ = "";
    /**
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     */
    public java.lang.String getAdministrativeArea() {
      java.lang.Object ref = administrativeArea_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        administrativeArea_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getAdministrativeAreaBytes() {
      java.lang.Object ref = administrativeArea_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        administrativeArea_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     */
    public Builder setAdministrativeArea(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      administrativeArea_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     */
    public Builder clearAdministrativeArea() {
      
      administrativeArea_ = getDefaultInstance().getAdministrativeArea();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Highest administrative subdivision which is used for postal
     * addresses of a country or region.
     * For example, this can be a state, a province, an oblast, or a prefecture.
     * Specifically, for Spain this is the province and not the autonomous
     * alluxio.shaded.client.com.unity (e.g. "Barcelona" and not "Catalonia").
     * Many countries don't use an administrative area in postal addresses. E.g.
     * in Switzerland this should be left unpopulated.
     * </pre>
     *
     * <code>string administrative_area = 6;</code>
     */
    public Builder setAdministrativeAreaBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      administrativeArea_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locality_ = "";
    /**
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     */
    public java.lang.String getLocality() {
      java.lang.Object ref = locality_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locality_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getLocalityBytes() {
      java.lang.Object ref = locality_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        locality_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     */
    public Builder setLocality(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      locality_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     */
    public Builder clearLocality() {
      
      locality_ = getDefaultInstance().getLocality();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Generally refers to the city/town portion of the address.
     * Examples: US city, IT alluxio.shaded.client.com.ne, UK post town.
     * In regions of the world where localities are not well defined or do not fit
     * into this structure well, leave locality empty and use address_lines.
     * </pre>
     *
     * <code>string locality = 7;</code>
     */
    public Builder setLocalityBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      locality_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sublocality_ = "";
    /**
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     */
    public java.lang.String getSublocality() {
      java.lang.Object ref = sublocality_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sublocality_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getSublocalityBytes() {
      java.lang.Object ref = sublocality_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sublocality_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     */
    public Builder setSublocality(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      sublocality_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     */
    public Builder clearSublocality() {
      
      sublocality_ = getDefaultInstance().getSublocality();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. Sublocality of the address.
     * For example, this can be neighborhoods, boroughs, districts.
     * </pre>
     *
     * <code>string sublocality = 8;</code>
     */
    public Builder setSublocalityBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      sublocality_ = value;
      onChanged();
      return this;
    }

    private alluxio.shaded.client.com.google.protobuf.LazyStringList addressLines_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureAddressLinesIsMutable() {
      if (!((bitField0_ & 0x00000100) == 0x00000100)) {
        addressLines_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList(addressLines_);
        bitField0_ |= 0x00000100;
       }
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
        getAddressLinesList() {
      return addressLines_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public int getAddressLinesCount() {
      return addressLines_.size();
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public java.lang.String getAddressLines(int index) {
      return addressLines_.get(index);
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getAddressLinesBytes(int index) {
      return addressLines_.getByteString(index);
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public Builder setAddressLines(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAddressLinesIsMutable();
      addressLines_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public Builder addAddressLines(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAddressLinesIsMutable();
      addressLines_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public Builder addAllAddressLines(
        java.lang.Iterable<java.lang.String> values) {
      ensureAddressLinesIsMutable();
      alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, addressLines_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public Builder clearAddressLines() {
      addressLines_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unstructured address lines describing the lower levels of an address.
     * Because values in address_lines do not have type information and may
     * sometimes contain multiple values in a single field (e.g.
     * "Austin, TX"), it is important that the line order is clear. The order of
     * address lines should be "envelope order" for the country/region of the
     * address. In places where this can vary (e.g. Japan), address_language is
     * used to make it explicit (e.g. "ja" for large-to-small ordering and
     * "ja-Latn" or "en" for small-to-large). This way, the most specific line of
     * an address can be selected based on the language.
     * The minimum permitted structural representation of an address consists
     * of a region_code with all remaining information placed in the
     * address_lines. It would be possible to format such an address very
     * approximately without geocoding, but no semantic reasoning could be
     * made about any of the address alluxio.shaded.client.com.onents until it was at least
     * partially resolved.
     * Creating an address only containing a region_code and address_lines, and
     * then geocoding is the recommended way to handle alluxio.shaded.client.com.letely unstructured
     * addresses (as opposed to guessing which parts of the address should be
     * localities or administrative areas).
     * </pre>
     *
     * <code>repeated string address_lines = 9;</code>
     */
    public Builder addAddressLinesBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureAddressLinesIsMutable();
      addressLines_.add(value);
      onChanged();
      return this;
    }

    private alluxio.shaded.client.com.google.protobuf.LazyStringList recipients_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureRecipientsIsMutable() {
      if (!((bitField0_ & 0x00000200) == 0x00000200)) {
        recipients_ = new alluxio.shaded.client.com.google.protobuf.LazyStringArrayList(recipients_);
        bitField0_ |= 0x00000200;
       }
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ProtocolStringList
        getRecipientsList() {
      return recipients_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public int getRecipientsCount() {
      return recipients_.size();
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public java.lang.String getRecipients(int index) {
      return recipients_.get(index);
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getRecipientsBytes(int index) {
      return recipients_.getByteString(index);
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public Builder setRecipients(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureRecipientsIsMutable();
      recipients_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public Builder addRecipients(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureRecipientsIsMutable();
      recipients_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public Builder addAllRecipients(
        java.lang.Iterable<java.lang.String> values) {
      ensureRecipientsIsMutable();
      alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, recipients_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public Builder clearRecipients() {
      recipients_ = alluxio.shaded.client.com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The recipient at the address.
     * This field may, under certain circumstances, contain multiline information.
     * For example, it might contain "care of" information.
     * </pre>
     *
     * <code>repeated string recipients = 10;</code>
     */
    public Builder addRecipientsBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureRecipientsIsMutable();
      recipients_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object alluxio.shaded.client.org.nization_ = "";
    /**
     * <pre>
     * Optional. The name of the alluxio.shaded.client.org.nization at the address.
     * </pre>
     *
     * <code>string alluxio.shaded.client.org.nization = 11;</code>
     */
    public java.lang.String getOrganization() {
      java.lang.Object ref = alluxio.shaded.client.org.nization_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alluxio.shaded.client.org.nization_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. The name of the alluxio.shaded.client.org.nization at the address.
     * </pre>
     *
     * <code>string alluxio.shaded.client.org.nization = 11;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getOrganizationBytes() {
      java.lang.Object ref = alluxio.shaded.client.org.nization_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alluxio.shaded.client.org.nization_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. The name of the alluxio.shaded.client.org.nization at the address.
     * </pre>
     *
     * <code>string alluxio.shaded.client.org.nization = 11;</code>
     */
    public Builder setOrganization(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      alluxio.shaded.client.org.nization_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The name of the alluxio.shaded.client.org.nization at the address.
     * </pre>
     *
     * <code>string alluxio.shaded.client.org.nization = 11;</code>
     */
    public Builder clearOrganization() {
      
      alluxio.shaded.client.org.nization_ = getDefaultInstance().getOrganization();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The name of the alluxio.shaded.client.org.nization at the address.
     * </pre>
     *
     * <code>string alluxio.shaded.client.org.nization = 11;</code>
     */
    public Builder setOrganizationBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      alluxio.shaded.client.org.nization_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.type.PostalAddress)
  }

  // @@protoc_insertion_point(class_scope:google.type.PostalAddress)
  private static final alluxio.shaded.client.com.google.type.PostalAddress DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new alluxio.shaded.client.com.google.type.PostalAddress();
  }

  public static alluxio.shaded.client.com.google.type.PostalAddress getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<PostalAddress>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<PostalAddress>() {
    public PostalAddress parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new PostalAddress(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<PostalAddress> parser() {
    return PARSER;
  }

  @java.lang.Override
  public alluxio.shaded.client.com.google.protobuf.Parser<PostalAddress> getParserForType() {
    return PARSER;
  }

  public alluxio.shaded.client.com.google.type.PostalAddress getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

