/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.alluxio.shaded.client.com.ression;

import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;

/**
 * Per-frame implementation of deflate alluxio.shaded.client.com.ressor.
 */
class PerFrameDeflateEncoder extends DeflateEncoder {

    /**
     * Constructor
     * @param alluxio.shaded.client.com.ressionLevel alluxio.shaded.client.com.ression level of the alluxio.shaded.client.com.ressor.
     * @param windowSize maximum size of the window alluxio.shaded.client.com.ressor buffer.
     * @param noContext true to disable context takeover.
     */
    public PerFrameDeflateEncoder(int alluxio.shaded.client.com.ressionLevel, int windowSize, boolean noContext) {
        super(alluxio.shaded.client.com.ressionLevel, windowSize, noContext);
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return (msg instanceof TextWebSocketFrame ||
                msg instanceof BinaryWebSocketFrame ||
                msg instanceof ContinuationWebSocketFrame) &&
                    ((WebSocketFrame) msg).content().readableBytes() > 0 &&
                    (((WebSocketFrame) msg).rsv() & WebSocketExtension.RSV1) == 0;
    }

    @Override
    protected int rsv(WebSocketFrame msg) {
        return msg.rsv() | WebSocketExtension.RSV1;
    }

    @Override
    protected boolean removeFrameTail(WebSocketFrame msg) {
        return true;
    }

}
