/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.alluxio.shaded.client.com.ression;

import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;

/**
 * Extends <tt>alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.alluxio.shaded.client.com.ression.WebSocketServerExtensionHandler</tt>
 * to handle the most alluxio.shaded.client.com.on WebSocket Compression Extensions.
 *
 * See <tt>alluxio.shaded.client.io.netty.example.http.websocketx.html5.WebSocketServer</tt> for usage.
 */
public class WebSocketServerCompressionHandler extends WebSocketServerExtensionHandler {

    /**
     * Constructor with default configuration.
     */
    public WebSocketServerCompressionHandler() {
        super(new PerMessageDeflateServerExtensionHandshaker(),
                new DeflateFrameServerExtensionHandshaker());
    }

}
