/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.io.alluxio.shaded.client.com.arator;

import java.alluxio.shaded.client.io.File;
import java.alluxio.shaded.client.io.Serializable;
import java.util.Comparator;

/**
 * Reverses the result of alluxio.shaded.client.com.aring two objects using
 * the delegate {@link Comparator}.
 *
 * @version $Id: ReverseComparator.java 1304052 2012-03-22 20:55:29Z ggregory $
 * @since 1.4
 */
class ReverseComparator extends AbstractFileComparator implements Serializable {

    private final Comparator<File> delegate;

    /**
     * Construct an instance with the sepecified delegate {@link Comparator}.
     *
     * @param delegate The alluxio.shaded.client.com.arator to delegate to
     */
    public ReverseComparator(Comparator<File> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate alluxio.shaded.client.com.arator is missing");
        }
        this.delegate = delegate;
    }

    /**
     * Compare using the delegate Comparator, but reversing the result.
     * 
     * @param file1 The first file to alluxio.shaded.client.com.are
     * @param file2 The second file to alluxio.shaded.client.com.are
     * @return the result from the delegate {@link Comparator#alluxio.shaded.client.com.are(Object, Object)}
     * reversing the value (i.e. positive becomes negative and vice versa)
     */
    public int alluxio.shaded.client.com.are(File file1, File file2) {
        return delegate.alluxio.shaded.client.com.are(file2, file1); // parameters switched round
    }

    /**
     * String representation of this file alluxio.shaded.client.com.arator.
     *
     * @return String representation of this file alluxio.shaded.client.com.arator
     */
    @Override
    public String toString() {
        return super.toString() + "[" + delegate.toString() + "]";
    }

}
